/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2010 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

/* float.h standard header -- IEEE 754 version */
#ifndef _FLOAT
#define _FLOAT
#ifndef _YVALS
 #include <yvals.h>
#endif /* _YVALS */

_C_STD_BEGIN

		/* TYPE DEFINITIONS */
 #ifndef _DVALS
  #define _DVALS
typedef struct
	{	/* parameters for a floating-point type */
	int _Ddig, _Dmdig, _Dmax10e, _Dmaxe, _Dmin10e, _Dmine;
	union
		{	/* union of short array and all floats */
		unsigned short _Us[8];
		float _Float;
		double _Double;
		long double _Long_double;
		} _Deps, _Dmax, _Dmin;
	} _Dvals;
 #endif /* _DVALS */

		/* DECLARATIONS */
_C_LIB_DECL
extern /* const */ _Dvals _Dbl, _Flt, _Ldbl;
_END_C_LIB_DECL

		/* COMMON PROPERTIES */
#define FLT_RADIX		2

 #ifdef _FRND
  #define FLT_ROUNDS		_FRND

 #else /* _FRND */
  #define FLT_ROUNDS		-1	/* indeterminable */
 #endif /* _FRND */

 #if _HAS_C9X

 #ifdef _FEVAL
  #define FLT_EVAL_METHOD	_FEVAL

 #else /* _FEVAL */
  #define FLT_EVAL_METHOD	-1	/* indeterminable */
 #endif /* _FEVAL */

 #if _DLONG == 0
  #define DECIMAL_DIG		17	/* 64-bit long double */

 #elif _DLONG == 1
  #define DECIMAL_DIG		21	/* 80-bit long double */

 #else /* 1 < _DLONG */
  #define DECIMAL_DIG		35	/* 128-bit SPARC long double */
 #endif /* _DLONG */

 #endif /* _IS_C9X */

		/* float PROPERTIES */
/* _CSTD _Flt._Deps._Float */
#define FLT_EPSILON		1.1920928955078125e-07f
/* _CSTD _Flt._Dmax._Float */
#define FLT_MAX			6.8056469327705771962340836696903385088e+38f
/* _CSTD _Flt._Dmin._Float */
#define FLT_MIN			1.1754943508222875079687365372222456778186655567720875215087517062784172594547271728515625e-38f
#define FLT_DIG			6		/* _CSTD _Flt._Ddig */
#define FLT_MANT_DIG	24		/* _CSTD _Flt._Dmdig */
#define FLT_MAX_10_EXP	38		/* _CSTD _Flt._Dmax10e */
#define FLT_MAX_EXP		129		/* _CSTD _Flt._Dmaxe */
#define FLT_MIN_10_EXP	-37		/* _CSTD _Flt._Dmin10e */
#define FLT_MIN_EXP		-125	/* _CSTD _Flt._Dmine */

		/* double PROPERTIES */
/* _CSTD _Dbl._Deps._Double */
#define DBL_EPSILON		((double)2.220446049250313080847263336181640625e-16L)
/* _CSTD _Dbl._Dmax._Double */
#define DBL_MAX			((double)1.79769313486231570814527423731704356798070567525e+308L)
/* _CSTD _Dbl._Dmin._Double */
#define DBL_MIN			((double)2.22507385850720138309023271733240406421921598047e-308L)
#define DBL_DIG			15		/* _CSTD _Dbl._Ddig */
#define DBL_MANT_DIG	53		/* _CSTD _Dbl._Dmdig */
#define DBL_MAX_10_EXP	308		/* _CSTD _Dbl._Dmax10e */
#define DBL_MAX_EXP		1024	/* _CSTD _Dbl._Dmaxe */
#define DBL_MIN_10_EXP	-307	/* _CSTD _Dbl._Dmin10e */
#define DBL_MIN_EXP		-1021	/* _CSTD _Dbl._Dmine */

		/* long double PROPERTIES */
 #if _DLONG == 0
  /* _CSTD _Ldbl._Deps._Long_double */
  #define LDBL_EPSILON		2.220446049250313080847263336181640625e-16L
  /* _CSTD _Ldbl._Dmax._Long_double */
  #define LDBL_MAX			1.79769313486231570814527423731704356798070567525e+308L
  /* _CSTD _Ldbl._Dmin._Long_double */
  #define LDBL_MIN			2.22507385850720138309023271733240406421921598047e-308L
  #define LDBL_DIG			15		/* _CSTD _Ldbl._Ddig */
  #define LDBL_MANT_DIG		53		/* _CSTD _Ldbl._Dmdig */
  #define LDBL_MAX_10_EXP	308		/* _CSTD _Ldbl._Dmax10e */
  #define LDBL_MAX_EXP		1024	/* _CSTD _Ldbl._Dmaxe */
  #define LDBL_MIN_10_EXP	-307	/* _CSTD _Ldbl._Dmin10e */
  #define LDBL_MIN_EXP		-1021	/* _CSTD _Ldbl._Dmine */
 #endif	/* _DLONG */

_C_STD_END
#endif /* _FLOAT */

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:0216 */
