/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2009 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __CELL_SPURS_POLICY_MODULE2_H__
#define __CELL_SPURS_POLICY_MODULE2_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpursWorkloadId */
#include <cell/spurs/error.h>
#include <cell/spurs/policy_module_types.h>
#include <cell/spurs/common.h>			/* cellSpursGetWorkloadId() */

#ifdef __cplusplus
extern "C" {
#endif

/* new entry with status */
void cellSpursModuleEntryStatus(uintptr_t, uint64_t arg, CellSpursModulePollStatus status) __attribute__((naked,noreturn));
void cellSpursModuleMainStatus(CellSpursModulePollStatus status, uint64_t arg);
void cellSpursModuleExit(void) __attribute__((__noreturn__));
unsigned cellSpursModulePollStatus(CellSpursModulePollStatus *status);
int _cellSpursWorkloadFlagReceiver2(CellSpursWorkloadId, unsigned set);
uint64_t _cellSpursGetWorkloadFlag(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

/*
 * for compatibility
 */
#define cellSpursModuleExit(context)\
		cellSpursModuleExit()

/*
 * ready count interfaces for policy module
 */
#include <cell/spurs/ready_count.h>

#define cellSpursModuleReadyCountSwap(context, value)\
		_cellSpursReadyCountOperator(cellSpursGetWorkloadId(), _CELL_SPURS_READY_COUNT_SWAP, value, 0);

#define cellSpursModuleReadyCountCompareAndSwap(context, compare, swap)\
		_cellSpursReadyCountOperator(cellSpursGetWorkloadId(), _CELL_SPURS_READY_COUNT_CAS, compare, swap)

#define cellSpursModuleReadyCountAdd(context, value)\
		_cellSpursReadyCountOperator(cellSpursGetWorkloadId(), _CELL_SPURS_READY_COUNT_ADD, value, 0);

/*
 * workload flag
 */
static inline
int cellSpursModuleSetWorkloadFlagReceiver2(void)
{
	return _cellSpursWorkloadFlagReceiver2(cellSpursGetWorkloadId(), 1);
}

static inline
int cellSpursModuleUnsetWorkloadFlagReceiver2(void)
{
	return _cellSpursWorkloadFlagReceiver2(cellSpursGetWorkloadId(), 0);
}

static inline
int cellSpursGetWorkloadFlag(uint64_t *flag)
{
	if (flag == 0) {
		return CELL_SPURS_POLICY_MODULE_ERROR_NULL_POINTER;
	}
	*flag = _cellSpursGetWorkloadFlag();
	return CELL_OK;
}

#endif /* __CELL_SPURS_POLICY_MODULE2_H__ */
/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
