/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2009 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __CELL_SPURS_POLICY_MODULE_H__
#define __CELL_SPURS_POLICY_MODULE_H__ 1

#include <cell/spurs/policy_module2.h>

#ifdef __cplusplus
extern "C" {
#endif

/* for compatibility: no more APIs requiring context */
void cellSpursModuleEntry(uintptr_t context, uint64_t ea) __attribute__((naked,noreturn));
void cellSpursModuleMain(uintptr_t context, uint64_t ea);
unsigned cellSpursModulePoll(void);
int _cellSpursRequestIdleSpu(CellSpursWorkloadId, unsigned count);
int _cellSpursWorkloadFlagReceiver(CellSpursWorkloadId, unsigned set);

#ifdef __cplusplus
} /* extern "C" */
#endif

/*
 * for compatibility
 */
#define cellSpursModulePoll(context)\
		cellSpursModulePoll()

/*
 * alias of SPURS common interfaces
 */
#define cellSpursModuleGetSpuId(context)\
		cellSpursGetCurrentSpuId()

#define cellSpursModuleGetWorkloadId(context)\
		cellSpursGetWorkloadId()

/*
 * idle SPU request operation for policy module
 */
#define cellSpursModuleRequestIdleSpu(context, count)\
		(void)_cellSpursRequestIdleSpu(cellSpursGetWorkloadId(), count)

static inline
int cellSpursRequestIdleSpu(unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id, unsigned count)
{
	(void)ls;
	(void)eaSpurs;
	return _cellSpursRequestIdleSpu(id, count);
}

/*
 * workload flag
 */
static inline
int cellSpursModuleSetWorkloadFlagReceiver(void)
{
	return _cellSpursWorkloadFlagReceiver(cellSpursGetWorkloadId(), 1);
}

static inline
int cellSpursModuleUnsetWorkloadFlagReceiver(void)
{
	return _cellSpursWorkloadFlagReceiver(cellSpursGetWorkloadId(), 0);
}

#endif /* __CELL_SPURS_POLICY_MODULE_H__ */
/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
