/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2009 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_JOBQUEUE_PORT2_H__
#define __CELL_SPURS_JOBQUEUE_PORT2_H__

/* standard C++ header */
#include <stdint.h>

/* spurs */
#include <cell/spurs/job_descriptor.h>

/* job queue */
#include <cell/spurs/job_queue.h>
#include <cell/spurs/job_queue_port2_types.h>
#include <cell/spurs/job_queue_port2_cpp_types.h>

#ifdef __cplusplus
extern "C" {
#endif

	/* get information */
	uint64_t cellSpursJobQueuePort2GetJobQueue(uint64_t eaPort2);

	int cellSpursJobQueuePort2Create(uint64_t eaPort2, uint64_t eaJobQueue);
	int cellSpursJobQueuePort2Destroy(uint64_t eaPort2);

	int _cellSpursJobQueuePort2PushJobBody(uint64_t eaPort2, uint64_t eaJob, size_t sizeDesc, unsigned tag, unsigned int dmaTag, unsigned flag, unsigned isAutoRelease);
	int _cellSpursJobQueuePort2PushJobListBody(uint64_t eaPort2, uint64_t eaJobList, unsigned tag, unsigned int dmaTag, unsigned flag);
	int _cellSpursJobQueuePort2CopyPushJobBody(uint64_t eaPort2, const CellSpursJobHeader* pJob, size_t sizeDesc, size_t sizeDescFromPool, unsigned tag, unsigned int dmaTag, unsigned flag);


	/* Jobdescriptor Checker */
	static inline int _cellSpursJobQueueCheckJobFromSpuWithPort2Internal(uint64_t eaPort2, uint64_t eaJobDesc, size_t sizeJobDesc, unsigned int dmaTag)
	{
		if (eaPort2 == 0) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if (eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueueCheckJobFromSpuWithJobqueueInternal(cellSpursJobQueuePort2GetJobQueue(eaPort2), eaJobDesc, sizeJobDesc, dmaTag);
	}
	static inline int _cellSpursJobQueueCheckJobListFromSpuWithPort2Internal(uint64_t eaPort2, uint64_t eaJobList, unsigned int dmaTag)
	{
		if (eaPort2 == 0) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if (eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueueCheckJobListFromSpuWithJobqueueInternal(cellSpursJobQueuePort2GetJobQueue(eaPort2), eaJobList, dmaTag);
	}
	static inline int _cellSpursJobQueueCheckJobWithPort2Internal(uint64_t eaPort2, const CellSpursJobHeader* pJobDesc, size_t sizeJobDesc)
	{
		if (eaPort2 == 0) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if (eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueueCheckJobWithJobqueueInternal(cellSpursJobQueuePort2GetJobQueue(eaPort2), pJobDesc, sizeJobDesc);
	}


	/* external interface for push */

	static inline int cellSpursJobQueuePort2PushJob(uint64_t eaPort2, uint64_t eaJob, size_t sizeDesc, unsigned tag, unsigned int dmaTag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(_cellSpursJobQueueCheckJobFromSpuWithPort2Internal(eaPort2, eaJob, sizeDesc, dmaTag));
#endif
		return _cellSpursJobQueuePort2PushJobBody(eaPort2, eaJob, sizeDesc, tag, dmaTag, flag, 0);
	}

	static inline int cellSpursJobQueuePort2PushJobList(uint64_t eaPort2, uint64_t eaJobList, unsigned tag, unsigned int dmaTag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(_cellSpursJobQueueCheckJobListFromSpuWithPort2Internal(eaPort2, eaJobList, dmaTag));
#endif
		return _cellSpursJobQueuePort2PushJobListBody(eaPort2, eaJobList, tag, dmaTag, flag);
	}

	static inline int cellSpursJobQueuePort2CopyPushJob(uint64_t eaPort2, const CellSpursJobHeader* pJob, size_t sizeDesc, size_t sizeDescFromPool, unsigned tag, unsigned int dmaTag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(_cellSpursJobQueueCheckJobWithPort2Internal(eaPort2, pJob, sizeDesc));
#endif
		return _cellSpursJobQueuePort2CopyPushJobBody(eaPort2, pJob, sizeDesc, sizeDescFromPool, tag, dmaTag, flag);
	}

	static inline int cellSpursJobQueuePort2PushAndReleaseJob(uint64_t eaPort2, uint64_t eaJob, size_t sizeDesc, unsigned tag, unsigned int dmaTag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(_cellSpursJobQueueCheckJobFromSpuWithPort2Internal(eaPort2, eaJob, sizeDesc, dmaTag));
#endif
		return _cellSpursJobQueuePort2PushJobBody(eaPort2, eaJob, sizeDesc, tag, dmaTag, flag, 1);
	}

	int cellSpursJobQueuePort2AllocateJobDescriptor(uint64_t eaPort2, size_t sizeDesc, unsigned int dmaTag, unsigned flag, uint64_t *eaAllocatedJobDesc);
	int cellSpursJobQueuePort2Sync(uint64_t eaPort2, unsigned flag);
	int cellSpursJobQueuePort2PushFlush(uint64_t eaPort2, unsigned int dmaTag, unsigned flag);
	int cellSpursJobQueuePort2PushSync(uint64_t eaPort2, unsigned tagMask, unsigned int dmaTag, unsigned flag);

#ifdef __cplusplus
}

__CELL_SPURS_JOBQUEUE_BEGIN

class Port2Stub
{
protected:
	// member variables
	uint64_t mEaPort2;

	Port2Stub(const Port2Stub&);
	Port2Stub& operator = (const Port2Stub&);

private:

public:
	static const unsigned	kFlagSyncJob = CELL_SPURS_JOBQUEUE_FLAG_SYNC_JOB;
	static const unsigned	kFlagExclusiveJob = CELL_SPURS_JOBQUEUE_FLAG_EXCLUSIVE_JOB;
	static const unsigned	kFlagNonBlocking = CELL_SPURS_JOBQUEUE_FLAG_NON_BLOCKING;

	Port2Stub() : mEaPort2(0) {}
	~Port2Stub() {}

	int create(uint64_t eaJobQueue, void *reserved = 0)
	{
		(void)reserved;
		return cellSpursJobQueuePort2Create(mEaPort2, eaJobQueue);
	}

	int destroy()
	{
		return cellSpursJobQueuePort2Destroy(mEaPort2);
	}

	int pushJob(uint64_t eaJob, size_t sizeDesc, unsigned tag, unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2PushJob(mEaPort2, eaJob, sizeDesc, tag, dmaTag, flag);
	}
	int pushJobList(uint64_t eaJobList, unsigned tag, unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2PushJobList(mEaPort2, eaJobList, tag, dmaTag, flag);
	}
	int copyPushJob(const CellSpursJobHeader *pJob, size_t sizeDesc, size_t sizeDescFromPool, unsigned tag, unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2CopyPushJob(mEaPort2, pJob, sizeDesc, sizeDescFromPool, tag, dmaTag, flag);
	}
	int pushAndReleaseJob(uint64_t eaJob, size_t sizeDesc, unsigned tag, unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2PushAndReleaseJob(mEaPort2, eaJob, sizeDesc, tag, dmaTag, flag);
	}

	int allocateJobDescriptor(size_t sizeDesc, unsigned int dmaTag, unsigned flag, uint64_t *eaAllocatedJobDesc)
	{
		return cellSpursJobQueuePort2AllocateJobDescriptor(mEaPort2, sizeDesc, dmaTag, flag, eaAllocatedJobDesc);
	}

	int sync(unsigned flag)
	{
		return cellSpursJobQueuePort2Sync(mEaPort2, flag);
	}
	int pushFlush(unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2PushFlush(mEaPort2, dmaTag, flag);
	}
	int pushSync(unsigned tagMask, unsigned int dmaTag, unsigned flag)
	{
		return cellSpursJobQueuePort2PushSync(mEaPort2, tagMask, dmaTag, flag);
	}

	uint64_t getJobQueue()
	{
		return cellSpursJobQueuePort2GetJobQueue(mEaPort2);
	}
	void setObject(uint64_t eaPort2)
	{
		mEaPort2 = eaPort2;
	}
	uint64_t getObject()
	{
		return mEaPort2;
	}
};

__CELL_SPURS_JOBQUEUE_END

#endif /* #ifdef __cplusplus */

#endif /* __CELL_SPURS_JOBQUEUE_PORT2_H__ */
