/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001 
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _MULTISTREAM_MP3_SPULIB_H_
#define _MULTISTREAM_MP3_SPULIB_H_



#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif


typedef struct CellMSMP3Context
{
	float decodeBuff[544];
	float oldBlock[576];
	char  oldFrame[512];
} CellMSMP3Context;

#define CELL_MSMP3_SPU_WORKSPACE_SIZE          (1024*110)

////////////////////////////////////////////////////////////////////////////////////////////////////
// cellMSMP3IntegratedDecoderSpuDecode
////////////////////////////////////////////////////////////////////////////////////////////////////
//	Decodes a single MP3 instance
// 
// Requires:
// 	void * pLocalWorkspace		pointer to 128 byte aligned local workspace of WORKSPACE_SIZE size
// 	void * pMainRamAddr         address the PPU side was initialized at, see cellMSMP3IntegratedDecoderInit()
// 	void * pinBuffer            pointer to MP3 packet
// 	int  *pnBytesRead           address of returned bytes read variable
// 	int  *pnBytesWritten        address of returned bytes written variable
// 	CellMSMP3Context *pContext0   pointer to local memory context (must be persistent between calls)
// 	CellMSMP3Context *pContext1   pointer to local memory context (must be persistent between calls)
// 	int *pnCount                internal counter, set to 1 for first call on stream decoding
// 
// 
// Returns:
// 	short *pOut
// 		>0		Pointer to PCM data of *pnBytesWritten size. If decoding stereo data, there will also
// 				be *pnBytesWritten for the right channel, located at an offset of 4096 bytes.
// 		0		Failed
////////////////////////////////////////////////////////////////////////////////////////////////////
short* cellMSMP3IntegratedDecoderSpuDecode( void* pLocalWorkspace, void* pMainRamAddr, void *pInBuffer, int *pnBytesRead, int *pnBytesWritten, CellMSMP3Context* pContext0, CellMSMP3Context* pContext1, int* pnCount );


#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif

#endif //_MULTISTREAM_MP3_SPULIB_H_

