/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _TEMPLATE_MATCHING_H_
#define _TEMPLATE_MATCHING_H_

#include <cell/spurs.h>

#include "TemplateMatchingInfo.h"
#include "vision_param.h"
#include "cellImage.h"
#include "sample_vision_util_spurs.h"


#define TEMPLATE_MATCHING_OK 0
#define TEMPLATE_MATCHING_ERROR -1

#define TEMPLATE_MATCHING_ALIGN 128
#define TEMPLATE_MATCHING_RESULT_ALIGN 16


//////////////////////////
//TemplateMatchingResult
//////////////////////////
typedef struct TemplateMatchingResult{
	float mPosX; //center position
	float mPosY; //center position
	float mScore;
} __attribute__((aligned(TEMPLATE_MATCHING_RESULT_ALIGN))) TemplateMatchingResult;


//////////////////////////
//TemplateMatching
//////////////////////////
class TemplateMatching{
public:
	TemplateMatching();
	~TemplateMatching();
	static int GetAlign(void); //static member function
	static int GetWorkingMemorySize(int size); //static member function
	int Initialize(const void *work, const CellSpurs2 *spurs);
	int Finalize(void);
	
	int ExecTemplateMatching(const CellImage *image, const TemplateMatchingInfo *tmInfo);

	const TemplateMatchingResult *GetResult(void) const { return &mResult; }
	int GetUsedTemplate(void) const { return mUsedTemplate; }
	
	const TemplateMatchingResult *GetTemplateResult(int num) const
	{ return &mTemplateResult[sizeof(TemplateMatchingResult) * num]; }
	
private:
	//spurs tastset
	CellSpursTaskset2 mSpursTaskset; //CELL_SPURS_TASKSET_ALIGN (128 byte align)
	//task
	SampleVisionUtilTask2 mBlockMatchingTask; //SAMPLE_VISION_UTIL_TASK_ALIGN (16 byte align)

	TemplateMatchingResult mResult; //matching result
	TemplateMatchingResult mTemplateResult[TM_TEMPLATE_NUM_MAX]; //matching result of each template
	
	BlockMatchingInfo mBMInfo; //for SPU(DMA) process
	
	bool mInit;
	int mUsedTemplate;
}; //TemplateMatching


#endif // _TEMPLATE_MATCHING_H_
