/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _SPU_SHUFFLEBYTES_MASKS_H_
#define _SPU_SHUFFLEBYTES_MASKS_H_

#define extract_b_mask (vec_uchar16)(vec_uint4){0x00020406, 0x080A0C0E, 0x10121416, 0x181A1C1E}
#define extract_r_mask (vec_uchar16)(vec_uint4){0x01030507, 0x090B0D0F, 0x11131517, 0x191B1D1F}

#define interp_b_mask   (vec_uchar16)(vec_uint4){0x00100111, 0x02120313, 0x04140515, 0x06160717}
#define interp_r_mask   (vec_uchar16)(vec_uint4){0x08180919, 0x0A1A0B1B, 0x0C1C0D1D, 0x0E1E0F1F}

//#define int4_to_short8_mask   (vec_uchar16)(vec_uint4){0x80038007, 0x800B800F, 0x80138017, 0x801B801F}
#define int4_to_short8_mask   (vec_uchar16)(vec_uint4){0x02030607, 0x0A0B0E0F, 0x12131617, 0x1A1B1E1F}

#define int4_hi_to_short8_mask (vec_uchar16)(vec_uint4){0x00010405, 0x08090c0d, 0x10111415, 0x18191c1d}

#define short8_to_int4_lo_mask (vec_uchar16)(vec_uint4){0x00018080, 0x02038080, 0x04058080, 0x06078080}
#define short8_to_int4_hi_mask (vec_uchar16)(vec_uint4){0x08098080, 0x0a0b8080, 0x0c0d8080, 0x0e0f8080}

//
#define short8_to_int4_lo_mask2 (vec_uchar16)(vec_uint4){0x80800001, 0x80800203, 0x80800405, 0x80800607}
#define short8_to_int4_hi_mask2 (vec_uchar16)(vec_uint4){0x80800809, 0x80800a0b, 0x80800c0d, 0x80800e0f}

#define short8_to_char16_mask (vec_uchar16)(vec_uint4){0x01030507, 0x090B0D0F, 0x11131517, 0x191B1D1F}
#define short8_hi_to_char16_mask (vec_uchar16)(vec_uint4){0x00020406, 0x080a0c0e, 0x10121416, 0x181a1c1e}

#define char16_to_short8_lo_mask (vec_uchar16)(vec_uint4){0x00800180, 0x02800380, 0x04800580, 0x06800780}
#define char16_to_short8_hi_mask (vec_uchar16)(vec_uint4){0x08800980, 0x0a800b80, 0x0c800d80, 0x0e800f80}

//
#define char16_to_short8_lo_mask2 (vec_uchar16)(vec_uint4){0x80008001, 0x80028003, 0x80048005, 0x80068007}
#define char16_to_short8_hi_mask2 (vec_uchar16)(vec_uint4){0x80088009, 0x800a800b, 0x800c800d, 0x800e800f}

#define char16_interleave_lo_mask (vec_uchar16)(vec_uint4){0x00100111, 0x02120313, 0x04140515, 0x06160717}
#define char16_interleave_hi_mask (vec_uchar16)(vec_uint4){0x08180919, 0x0a1a0b1b, 0x0c1c0d1d, 0x0e1e0f1f}

#define short8_interleave_lo_mask (vec_uchar16)(vec_uint4){0x00011011, 0x02031213, 0x04051415, 0x06071617}
#define short8_interleave_hi_mask (vec_uchar16)(vec_uint4){0x08091819, 0x0A0B1A1B, 0x0C0D1C1D, 0x0E0F1E1F}


#define float8_to_float4_mask     (vec_uchar16)(vec_uint4){0x00010203, 0x08090A0B, 0x10111213, 0x18191A1B}
#define float8_to_float4_mask_alt (vec_uchar16)(vec_uint4){0x04050607, 0x0C0D0E0F, 0x14151617, 0x1C1D1E1F}

#define interp_b_mask_0 (vec_uchar16)(vec_uint4){0x80808000, 0x80808010, 0x80808001, 0x80808011}
#define interp_b_mask_1 (vec_uchar16)(vec_uint4){0x80808002, 0x80808012, 0x80808003, 0x80808013}
#define interp_b_mask_2 (vec_uchar16)(vec_uint4){0x80808004, 0x80808014, 0x80808005, 0x80808015}
#define interp_b_mask_3 (vec_uchar16)(vec_uint4){0x80808006, 0x80808016, 0x80808007, 0x80808017}

#define interp_r_mask_0 (vec_uchar16)(vec_uint4){0x80808008, 0x80808018, 0x80808009, 0x80808019}
#define interp_r_mask_1 (vec_uchar16)(vec_uint4){0x8080800A, 0x8080801A, 0x8080800B, 0x8080801B}
#define interp_r_mask_2 (vec_uchar16)(vec_uint4){0x8080800C, 0x8080801C, 0x8080800D, 0x8080801D}
#define interp_r_mask_3 (vec_uchar16)(vec_uint4){0x8080800E, 0x8080801E, 0x8080800F, 0x8080801F}

#define interp_rgba_mask_hi (vec_uchar16)(vec_uint4){0x00011011, 0x02031213, 0x04051415, 0x06071617}
#define interp_rgba_mask_lo (vec_uchar16)(vec_uint4){0x08091819, 0x0A0B1A1B, 0x0C0D1C1D, 0x0E0F1E1F}
#define dqword_byteshift_left1 (vec_uchar16)(vec_uint4){0x01020304,0x05060708,0x090a0b0c,0x0d0e0f10}
#define dqword_byteshift_right1 (vec_uchar16)(vec_uint4){0x1f000102,0x03040506,0x0708090a,0x0b0c0d0e}

#define dqword_byteshift_left2 (vec_uchar16)(vec_uint4){0x02030405,0x06070809,0x0a0b0c0d,0x0e0f1011}
#define dqword_byteshift_right2 (vec_uchar16)(vec_uint4){0x1e1f0001,0x02030405,0x06070809,0x0a0b0c0d}

#define dqword_byteshift_left4 (vec_uchar16)(vec_uint4){0x04050607,0x08090a0b,0x0c0d0e0f,0x10111213}
#define dqword_byteshift_right4 (vec_uchar16)(vec_uint4){0x1c1d1e1f,0x00010203,0x04050607,0x08090a0b}

#endif //_SPU_SHUFFLEBYTES_MASKS_H_
