/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _SAMPLE_VISION_UTIL_TASK_H_
#define _SAMPLE_VISION_UTIL_TASK_H_

#include <cell/spurs.h>

#include "sample_vision_util_spurs.h"
#include "vision_param.h"
#include "cellImage.h"

#ifdef __cplusplus
extern "C" {
#endif


int sampleVisionUtilResizeHalf(CellSpursTaskset2 *visionTaskset,
							   SampleVisionUtilTask2 *visionTask,
							   const CellImage *in,
							   CellImage *out);

int sampleVisionUtilBlockMatching16x16(CellSpursTaskset2 *visionTaskset,
									   SampleVisionUtilTask2 *visionTask,
									   const CellImage *target,
									   const unsigned char *ref,
									   BlockMatchingInfo *pos
									   );


int sampleVisionTaskRun(
	CellSpursTaskset2 *taskset,
	SampleVisionUtilTask2 *task,
	VisionParam       *param,
	char              *spu_program
	);
int sampleVisionTaskBegin(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task,
	VisionParam           *param,
	char                  *spu_program
	);
int sampleVisionTaskEnd(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task
	);
int sampleVisionTaskTryEnd(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task
	);


#ifdef __cplusplus
}
#endif

#endif // _SAMPLE_VISION_UTIL_TASK_H_
