/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#include <stdlib.h>
#include <cell/spurs.h>

#define VERVOSE_DEBUG 0

#include "debug.h"
#include "sample_vision_util_spurs.h"
#include "sample_vision_util_task.h"
#include "vision_param.h"
#include "sample_vision_elf_binary_ext.h"
#include "cellImage.h"


VisionParam gParamResizeHalf; //need global declaration for DMA
VisionParam gParamBlockMatching16x16; //need global declaration for DMA


/******************************************************************************
 * sampleVisionUtilResizeHalf()
 *****************************************************************************/
int sampleVisionUtilResizeHalf(CellSpursTaskset2 *visionTaskset,
							   SampleVisionUtilTask2 *visionTask,
							   const CellImage *in,
							   CellImage *out)
{
	int ret;

	gParamResizeHalf.data[0] = (uint64_t)in;
	gParamResizeHalf.data[1] = (uint64_t)out;
	
	ret = sampleVisionTaskRun(visionTaskset, visionTask, &gParamResizeHalf,
						_binary_task_sample_vision_resize_half_spu_elf_start);
	
	if( ret != CELL_OK ) {
		return ret;
	}

	return ret;
}

/******************************************************************************
 * sampleVisionUtilBlockMatching16x16()
 *****************************************************************************/
int sampleVisionUtilBlockMatching16x16(CellSpursTaskset2 *visionTaskset,
									   SampleVisionUtilTask2 *visionTask,
									   const CellImage *target,
									   const unsigned char *ref,
									   BlockMatchingInfo *pos
									   )
{
	int ret;
	
	gParamBlockMatching16x16.data[0]=  (uint64_t)target; //search image
	gParamBlockMatching16x16.data[1]=  (uint64_t)ref; //template
	gParamBlockMatching16x16.data[2]=  (uint64_t)pos;

	ret = sampleVisionTaskRun(visionTaskset, visionTask, &gParamBlockMatching16x16,
							  _binary_task_sample_vision_block_matching_16x16_spu_elf_start);

	if( ret != CELL_OK ) {
		return ret;
	}

	return ret;
}


/******************************************************************************
 * sampleVisionTaskRun()
 *****************************************************************************/
int sampleVisionTaskRun(
	CellSpursTaskset2 *taskset,
	SampleVisionUtilTask2 *task,
	VisionParam       *gParam,
	char              *spu_program
	)
{
	int ret;
	
	PPU_DEBUG("##### sampeVisionTaskRun() start... #####\n"); 

	ret = sampleVisionTaskBegin(taskset, task, gParam, spu_program);
	if (ret != CELL_OK) {
		PPU_DEBUG("sampleVisionTaskBegin() failed.(%#x)\n", ret);
		goto end;
	}
	
	/**********
	 *  wait  *
	 **********/
	
	/* join task */
	ret = sampleVisionTaskEnd(taskset, task);
	if (ret != CELL_OK) {
		PPU_DEBUG("sampleVisionTaskEnd() failed.(%#x)\n", ret);
	}
	
end:
	PPU_DEBUG("##### sampeVisionTaskRun() completed... #####\n");
	return ret;
}


/******************************************************************************
 * sampleVisionTaskBegin()
 *****************************************************************************/
int sampleVisionTaskBegin(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task,
	VisionParam           *gParam,
	char                  *spu_program
	)
{
	int ret;
	
	task->taskArg.u64[0] = (uintptr_t)gParam;
	task->taskArg.u64[1] = (uintptr_t)task->taskReturn;

	/* create run-complete type spurs task */
	ret = cellSpursCreateTask2(
		taskset,
		&task->taskId,
		spu_program,
		&task->taskArg,
		NULL
		);
	if (ret != CELL_OK) {
		PPU_DEBUG("cellSpursCreateTask2() failed. (%#x)\n", ret);
	}
	
	/*************
	 *  no wait  *
	 *************/
	return ret;
}

/******************************************************************************
 * sampleVisionTaskEnd()
 *****************************************************************************/
int sampleVisionTaskEnd(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task
	)
{
	int ret;
	int exitCode;
	
	/**********
	 *  wait  *
	 **********/
	ret = cellSpursJoinTask2(taskset, task->taskId, &exitCode);
	if (ret != CELL_OK) {
		PPU_DEBUG("cellSpursJoinTask2() failed. (%#x)\n", ret);
		return ret;
	}
	
	return exitCode;
}

/******************************************************************************
 * sampleVisionTaskTryEnd()
 *****************************************************************************/
int sampleVisionTaskTryEnd(
	CellSpursTaskset2     *taskset,
	SampleVisionUtilTask2 *task
	)
{
	int ret;
	int exitCode;
	
	/*************
	 *  no wait  *
	 *************/
	ret = cellSpursTryJoinTask2(taskset, task->taskId, &exitCode);
	if (ret != CELL_OK) {
		if (ret == CELL_SPURS_TASK_ERROR_AGAIN) {
			PPU_DEBUG("VisionTask is still in process.\n");
		} else {
			PPU_DEBUG("cellSpursTryJoinTask2() failed. (%#x)\n", ret);
		}
		return ret;
	}
	
	return exitCode;
}


