/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _SAMPLE_VISION_UTIL_SPURS_H_
#define _SAMPLE_VISION_UTIL_SPURS_H_

#include <cell/spurs.h>

#define SAMPLE_VISION_UTIL_TASK_ALIGN 16

typedef struct SampleVisionUtilTask2 {
	uint32_t				taskReturn[4];	/* 16 bytes */
	CellSpursTaskArgument	taskArg;		/* 16 bytes */
	CellSpursTaskId			taskId;			/*  4 bytes */
	uint32_t				padding0;		/*  4 bytes */
	uint32_t				padding1;		/*  4 bytes */
	uint32_t				padding2;		/*  4 bytes */
} __attribute__((aligned(SAMPLE_VISION_UTIL_TASK_ALIGN))) SampleVisionUtilTask2;


#ifdef __cplusplus
extern "C" {
#endif

int sampleVisionUtilTask2GetAlign(void);

int sampleVisionUtilInitializeEx(
	CellSpurs2					*visionSpurs,
	CellSpursTaskset2			*visionTaskset,
	const uint8_t				priorities[8],
	int32_t						numOfSpus
);

int sampleVisionUtilFinalizeEx(
	CellSpursTaskset2			*visionTaskset
);


#ifdef __cplusplus
}
#endif

#endif // _SAMPLE_VISION_UTIL_SPURS_H_
