/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>

#include <cell/spurs.h>

#include "debug.h"
#include "sample_vision_util_spurs.h"

#define VISION_TASKSET_NAME "VisionTaskset"


int sampleVisionUtilTask2GetAlign(void)
{
	return SAMPLE_VISION_UTIL_TASK_ALIGN;
}

int sampleVisionUtilInitializeEx(
	CellSpurs2					*visionSpurs,
	CellSpursTaskset2			*visionTaskset,
	const uint8_t				priorities[8],
	int32_t						numOfSpus
)
{
	int ret;

	DEBUG_MSG(("##### sampleVisionInitializeEx() start... #####\n"));

	CellSpursTasksetAttribute2 attributeTaskset;
	cellSpursTasksetAttribute2Initialize(&attributeTaskset);

	// priorities from api parameter
	attributeTaskset.name = VISION_TASKSET_NAME;
	attributeTaskset.argTaskset = 0;
	memcpy(attributeTaskset.priority, priorities, sizeof(priorities));
	attributeTaskset.maxContention = numOfSpus;

	ret = cellSpursCreateTaskset2((CellSpurs*)visionSpurs, visionTaskset, &attributeTaskset);
	if (ret != CELL_OK) {
		
		//ERROR(("cellSpursCreateTaskset2() failed. (%#x)\n", ret));
		goto err1;
	}

	DEBUG_MSG(("##### sampleVisionInitializeEx() succeeded #####\n"));

	return ret;

err1:
	DEBUG_MSG(("##### sampleVisionInitializeEx() failed #####\n"));

	return ret;
}

int sampleVisionUtilFinalizeEx(
	CellSpursTaskset2			*visionTaskset
)
{
	int ret;

	DEBUG_MSG(("##### sampleVisionFinalizeEx() start... #####\n"));

	ret = cellSpursDestroyTaskset2(visionTaskset);
	if (ret != CELL_OK) {
		ERROR(("cellSpursDestroyTaskset2() failed. (%#x)\n", ret));
	}

	DEBUG_MSG(("##### sampleVisionFinalizeEx() completed #####\n"));

	return ret;
}

