/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _VISION_PARAM_H_
#define _VISION_PARAM_H_

#include <stdint.h>

#define VISION_PARAM_ALIGN 16
#define BLOCK_MATCHING_INFO_ALIGN 16

typedef struct VisionParam{
	uint64_t data[4]; //32 bytes
} __attribute__((aligned(VISION_PARAM_ALIGN))) VisionParam;


typedef struct BlockMatchingInfo{
	float ix; //4 Bytes
	float iy; //4 Bytes
	float ox; //4 Bytes
	float oy; //4 Bytes
	float score; //4 Bytes
	float roll; //4 Bytes
	float dummy[2]; //8 Bytes
} __attribute__((aligned(BLOCK_MATCHING_INFO_ALIGN))) BlockMatchingInfo;


#endif // _VISION_PARAM_H_
