/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _CELLIMAGE_H_
#define _CELLIMAGE_H_

#ifdef __SPU__
#include <cell/dma.h>
#endif //__SPU__

#ifdef __PPU__
#include <stdio.h>
#include <stdint.h>
#endif //__PPU__


#define CELL_IMAGE_ALIGN 16 //CellImage class alignment
#define CELL_IMAGE_DATA_ALIGN 128 //*mData alignment

enum CELL_IMAGE_DATA_ALLOCATE_MODE {
	CELL_IMAGE_DATA_ALLOCATE_EXTERNAL = 0, //data allocated external
	CELL_IMAGE_DATA_ALLOCATE_INTERNAL = 1  //data allocated internal
};

/*
 * CellImage
 */
class CellImage{
	uint64_t mData; //integer decraration for DMA (semantically pointer of image data)
	uint16_t mDataAllocateMode; //0: not allocate mData, 1: allocate mData
	short mWidth; 
	short mHeight;
public:
	int GetWidth() { return mWidth; }
	int GetHeight() { return mHeight; }
	int GetDataAllocateMode() { return mDataAllocateMode; }

#ifdef __SPU__
	CellImage() { ; }
	~CellImage() { ; }
	
	uint64_t GetData() { return (uint64_t)mData;}
#endif //__SPU__
	
#ifdef __PPU__
	CellImage();
	~CellImage();

	static int GetAlign(void);
	static int GetWorkingMemorySize(int size, int width, int height, int mode);
	int Initialize(const void *work, int width, int height, int mode );
	void Finalize(void);

	void SetData(void *data); // assign image data pointer
	void CopyData(void *data); // copy image data

	uint8_t *GetData() const { return (uint8_t*)(uintptr_t)mData; }
#endif //__PPU__
} __attribute__((aligned(CELL_IMAGE_ALIGN)));


#endif // _CELLIMAGE_H_

