/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "cellImage.h"
#include "memory.h"


/******************************************************************************
 * CellImage (constructor)
 *****************************************************************************/
CellImage::
CellImage()
{
	mWidth = 0;
	mHeight = 0;
	mDataAllocateMode = CELL_IMAGE_DATA_ALLOCATE_EXTERNAL;
	mData = NULL;
}

/******************************************************************************
 * ~CellImage (destructor)
 *****************************************************************************/
CellImage::
~CellImage()
{
	mData = NULL;
}


/******************************************************************************
 * GetAlign()
 *****************************************************************************/
int CellImage::
GetAlign(void)
{
	return CELL_IMAGE_ALIGN;
}

/******************************************************************************
 * GetWorkingMemorySize()
 *****************************************************************************/
int CellImage::
GetWorkingMemorySize(int size, int width, int height, int mode)
{
	int memsize = size;

	if(mode == CELL_IMAGE_DATA_ALLOCATE_EXTERNAL) { //allocate external
	}
	else if(mode == CELL_IMAGE_DATA_ALLOCATE_INTERNAL){ //allocate internal
		memsize += sizeof_byte_align(CELL_IMAGE_DATA_ALIGN, memsize,
									 sizeof(unsigned char) * width * height);
	}

	return (memsize - size);
}

/******************************************************************************
 * Initialize()
 *****************************************************************************/
int CellImage::
Initialize(const void *work, int width, int height, int mode)
{
	unsigned char *p = (unsigned char*)work;
	
	if(mode == CELL_IMAGE_DATA_ALLOCATE_EXTERNAL) { //allocate external
		mData = NULL;
		mDataAllocateMode = CELL_IMAGE_DATA_ALLOCATE_EXTERNAL;
	}
	else if(mode == CELL_IMAGE_DATA_ALLOCATE_INTERNAL) { //allocate internal
		p += assign_memory_byte_align(CELL_IMAGE_DATA_ALIGN, (void *)p, (void *)&mData,
									  sizeof(unsigned char) * width * height);
		mDataAllocateMode = CELL_IMAGE_DATA_ALLOCATE_INTERNAL;
	}
	else {
		mData = NULL;
		mDataAllocateMode = CELL_IMAGE_DATA_ALLOCATE_EXTERNAL;
	}
	
	mWidth = width;
	mHeight = height;
	
	return (int)(p - (unsigned char*)work);
}

/******************************************************************************
 * Finalize()
 *****************************************************************************/
void CellImage::
Finalize(void)
{
	mData = NULL;
}

/******************************************************************************
 * SetData()
 *****************************************************************************/
void CellImage::
SetData(void *data)
{
	mData = (uint64_t)data;
}

/******************************************************************************
 * CopyData()
 *****************************************************************************/
void CellImage::
CopyData(void *data)
{
	memcpy((void*)(uintptr_t)mData, data, sizeof(uint8_t) * mWidth * mHeight);
}

