/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#include <cell/spurs.h>
#include <cell/dma.h>

#include <spu_intrinsics.h>

#include <cell/face.h>
#include "sample_face_util_detection_result.h"
CellFaceDetectionParam			gDetectParam;
SampleFaceUtilDetectionResult	gDetectResult;

int cellSpursTaskMain(qword argTask, uint64_t argTaskset)
{
	int status;

	(void)argTaskset;
	uint64_t inParamEa  = spu_extract((vec_ullong2)argTask, 0);
	uint64_t outParamEa = spu_extract((vec_ullong2)argTask, 1);

	cellDmaGet(&gDetectParam, inParamEa, sizeof(gDetectParam), 0, 0, 0);
	cellDmaWaitTagStatusAll(1<<0);

	status = cellFaceDetection3D(&gDetectParam, &gDetectResult.numFace);

	cellDmaPut(&gDetectResult, outParamEa, sizeof(gDetectResult), 0, 0, 0);
	cellDmaWaitTagStatusAll(1<<0);

	return status;
}
