/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#include <stdio.h>
#include <string.h>

#include <cell/spurs.h>

#include <cell/face.h>
#include "sample_face_util.h"

#define SPURS_TASKSET_NAME "FaceTaskset"

int sampleFaceUtilInitializeEx(
	CellSpurs2 *faceSpurs,
	CellSpursTaskset2 *faceTaskset,
	const uint8_t priorities[8],
	int32_t numOfSpus
	)
{
	int ret;
	
	DEBUG_MSG(("##### sampleFaceUtilInitializeEx() start... #####\n"));
	
	CellSpursTasksetAttribute2 attributeTaskset;
	cellSpursTasksetAttribute2Initialize(&attributeTaskset);
	
	// priorities from api parameter
	// const uint8_t priorities[8] = {1, 1, 1, 1, 1, 1, 1, 1};
	attributeTaskset.name = SPURS_TASKSET_NAME;
	attributeTaskset.argTaskset = 0;
	memcpy(attributeTaskset.priority, priorities, sizeof(priorities));
	attributeTaskset.maxContention = numOfSpus;
	
	ret = cellSpursCreateTaskset2((CellSpurs*)faceSpurs, faceTaskset, &attributeTaskset);
	if (ret != CELL_OK) {
		ERROR(("cellSpursCreateTaskset2() failed. (%#x)\n", ret));
		goto err1;
	}
	
	DEBUG_MSG(("##### sampleFaceUtilInitializeEx() succeeded #####\n"));
	
	return ret;
	
err1:
	DEBUG_MSG(("##### sampleFaceUtilInitializeEx() failed #####\n"));
	
	return ret;
}

int sampleFaceUtilFinalizeEx(
	CellSpursTaskset2 *faceTaskset
	)
{
	int ret;
	
	DEBUG_MSG(("##### sampleFaceUtilFinalizeEx() start... #####\n"));
	ret = cellSpursDestroyTaskset2(faceTaskset);
	if (ret != CELL_OK) {
		ERROR(("cellSpursDestroyTaskset2() failed. (%#x)\n", ret));
	}
	DEBUG_MSG(("##### sampleFaceUtilFinalizeEx() completed #####\n"));
	
	return ret;
}
