/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#include <stdlib.h>
#include <cell/spurs.h>
#include <cell/face.h>
#include "sample_face_util.h"
#include "task/sample_face_util_similarity_result.h"

/* embedded SPU ELF symbols */
extern char _binary_task_sample_face_util_similarity2_spu_elf_start[];

int sampleFaceUtilSimilarity2TaskBegin(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*simTask,
	CellFaceSimilarity2Param	*simParam
)
{
	int ret;

	simTask->taskArg.u64[0] = (uintptr_t)simParam;
	simTask->taskArg.u64[1] = (uintptr_t)simTask->taskReturn;

	/* create run-complete type spurs task */
	ret = cellSpursCreateTask2(
		faceTaskset,
		&simTask->taskId,
		_binary_task_sample_face_util_similarity2_spu_elf_start,
		&simTask->taskArg,
		NULL
	);
	if (ret != CELL_OK) {
		ERROR(("cellSpursCreateTask2() failed. (%#x)\n", ret));
	}

	/*************
	 *  no wait  *
	 *************/
	return ret;
}

int sampleFaceUtilSimilarity2TaskEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*simTask,
	float					*maxScore,
	int32_t					*maxScoreId
)
{
	int ret;
	int exitCode;

	/**********
	 *  wait  *
	 **********/
	ret = cellSpursJoinTask2(faceTaskset, simTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		ERROR(("cellSpursJoinTask2() failed. (%#x)\n", ret));
		return ret;
	}

	*maxScore   = ((SampleFaceUtilSimilarityResult*)(simTask->taskReturn))->maxScore;
	*maxScoreId = ((SampleFaceUtilSimilarityResult*)(simTask->taskReturn))->maxScoreId;

	return exitCode;
}

int sampleFaceUtilSimilarity2TaskTryEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*simTask,
	float					*maxScore,
	int32_t					*maxScoreId
)
{
	int ret;
	int exitCode;

	/*************
	 *  no wait  *
	 *************/
	ret = cellSpursTryJoinTask2(faceTaskset, simTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		if (ret == CELL_SPURS_TASK_ERROR_AGAIN) {
			DEBUG_MSG(("SimilarityTask is still in process.\n"));
		}
		else {
			ERROR(("cellSpursTryJoinTask2() failed. (%#x)\n", ret));
		}
		return ret;
	}

	*maxScore   = ((SampleFaceUtilSimilarityResult*)(simTask->taskReturn))->maxScore;
	*maxScoreId = ((SampleFaceUtilSimilarityResult*)(simTask->taskReturn))->maxScoreId;

	return exitCode;
}
