/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#include <stdlib.h>
#include <cell/spurs.h>
#include <cell/face.h>
#include "sample_face_util.h"

/* embedded SPU ELF symbols */
extern char _binary_task_sample_face_util_parts_spu_elf_start[];

int sampleFaceUtilPartsTaskBegin(
	CellSpursTaskset2	*faceTaskset,
	SampleFaceUtilTask2	*partsTask,
	CellFacePartsParam	*partsParam
)
{
	int ret;

	partsTask->taskArg.u64[0] = (uintptr_t)partsParam;
	partsTask->taskArg.u64[1] = (uintptr_t)partsTask->taskReturn;

	/* create run-complete type spurs task */
	ret = cellSpursCreateTask2(
		faceTaskset,
		&partsTask->taskId,
		_binary_task_sample_face_util_parts_spu_elf_start,
		&partsTask->taskArg,
		NULL
	);
	if (ret != CELL_OK) {
		ERROR(("cellSpursCreateTask2() failed. (%#x)\n", ret));
	}

	/*************
	 *  no wait  *
	 *************/
	return ret;
}

int sampleFaceUtilPartsTaskEnd(
	CellSpursTaskset2	*faceTaskset,
	SampleFaceUtilTask2	*partsTask
)
{
	int ret;
	int exitCode;

	/**********
	 *  wait  *
	 **********/
	ret = cellSpursJoinTask2(faceTaskset, partsTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		ERROR(("cellSpursJoinTask2() failed. (%#x)\n", ret));
		return ret;
	}

	return exitCode;
}

int sampleFaceUtilPartsTaskTryEnd(
	CellSpursTaskset2	*faceTaskset,
	SampleFaceUtilTask2	*partsTask
)
{
	int ret;
	int exitCode;

	/*************
	 *  no wait  *
	 *************/
	ret = cellSpursTryJoinTask2(faceTaskset, partsTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		if (ret == CELL_SPURS_TASK_ERROR_AGAIN) {
			DEBUG_MSG(("PartsTask is still in process.\n"));
		}
		else {
			ERROR(("cellSpursTryJoinTask2() failed. (%#x)\n", ret));
		}
		return ret;
	}

	return exitCode;
}
