/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#include <stdlib.h>
#include <cell/spurs.h>
#include <cell/face.h>
#include "sample_face_util.h"

/* embedded SPU ELF symbols */
extern char _binary_task_sample_face_util_feature2_spu_elf_start[];

int sampleFaceUtilFeature2TaskBegin(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*featureTask,
	CellFaceFeature2Param	*featureParam
)
{
	int ret;

	featureTask->taskArg.u64[0] = (uintptr_t)featureParam;
	featureTask->taskArg.u64[1] = (uintptr_t)featureTask->taskReturn;

	/* create run-complete type spurs task */
	ret = cellSpursCreateTask2(
		faceTaskset,
		&featureTask->taskId,
		_binary_task_sample_face_util_feature2_spu_elf_start,
		&featureTask->taskArg,
		NULL
	);
	if (ret != CELL_OK) {
		ERROR(("cellSpursCreateTask2() failed. (%#x)\n", ret));
	}

	/**********
	 *  wait  *
	 **********/
	return ret;
}

int sampleFaceUtilFeature2TaskEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*featureTask
)
{
	int ret;
	int exitCode;

	/**********
	 *  wait  *
	 **********/
	ret = cellSpursJoinTask2(faceTaskset, featureTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		ERROR(("cellSpursJoinTask2() failed. (%#x)\n", ret));
		return ret;
	}

	return exitCode;
}

int sampleFaceUtilFeature2TaskTryEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*featureTask
)
{
	int ret;
	int exitCode;

	/**********
	 *  wait  *
	 **********/
	ret = cellSpursTryJoinTask2(faceTaskset, featureTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		if (ret == CELL_SPURS_TASK_ERROR_AGAIN) {
			DEBUG_MSG(("FeatureTask is still in process.\n"));
		}
		else {
			ERROR(("cellSpursTryJoinTask2() failed. (%#x)\n", ret));
		}
		return ret;
	}

	return exitCode;
}
