/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2011 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#include <stdlib.h>
#include <cell/spurs.h>
#include <cell/face.h>
#include "sample_face_util.h"
#include "task/sample_face_util_detection_result.h"

/* embedded SPU ELF symbols */
extern char _binary_task_sample_face_util_detection_3D_spu_elf_start[];

int sampleFaceUtilDetection3DTaskBegin(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*detectTask,
	CellFaceDetectionParam	*detectParam
)
{
	int ret;

	detectTask->taskArg.u64[0] = (uintptr_t)detectParam;
	detectTask->taskArg.u64[1] = (uintptr_t)detectTask->taskReturn;

	/* create run-complete type spurs task */
	ret = cellSpursCreateTask2(
		faceTaskset,
		&detectTask->taskId,
		_binary_task_sample_face_util_detection_3D_spu_elf_start,
		&detectTask->taskArg,
		NULL
	);
	if (ret != CELL_OK) {
		ERROR(("cellSpursCreateTask2() failed. (%#x)\n", ret));
	}

	/*************
	 *  no wait  *
	 *************/
	return ret;
}

int sampleFaceUtilDetection3DTaskEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*detectTask,
	int32_t					*numFace
)
{
	int ret;
	int exitCode;

	/**********
	 *  wait  *
	 **********/
	ret = cellSpursJoinTask2(faceTaskset, detectTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		ERROR(("cellSpursJoinTask2() failed. (%#x)\n", ret));
		return ret;
	}

	*numFace = ((SampleFaceUtilDetectionResult*)(detectTask->taskReturn))->numFace;

	return exitCode;
}

int sampleFaceUtilDetection3DTaskTryEnd(
	CellSpursTaskset2		*faceTaskset,
	SampleFaceUtilTask2		*detectTask,
	int32_t					*numFace
)
{
	int ret;
	int exitCode;

	/*************
	 *  no wait  *
	 *************/
	ret = cellSpursTryJoinTask2(faceTaskset, detectTask->taskId, &exitCode);
	if (ret != CELL_OK) {
		if (ret == CELL_SPURS_TASK_ERROR_AGAIN) {
			DEBUG_MSG(("Detection3DTask is still in process.\n"));
		}
		else {
			ERROR(("cellSpursTryJoinTask2() failed. (%#x)\n", ret));
		}
		return ret;
	}

	*numFace = ((SampleFaceUtilDetectionResult*)(detectTask->taskReturn))->numFace;

	return exitCode;
}
