/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __SAMPLE_FACE_UTIL_H__
#define __SAMPLE_FACE_UTIL_H__

#include <cell/spurs.h>
#include <cell/face.h>
#include "debug.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SAMPLE_FACE_UTIL_TASK_ALIGN 16

typedef struct SampleFaceUtilTask2 {
	uint32_t				taskReturn[4];	/* 16 bytes */
	CellSpursTaskArgument	taskArg;		/* 16 bytes */
	CellSpursTaskId			taskId;			/*  4 bytes */
	uint32_t				padding0;		/*  4 bytes */
	uint32_t				padding1;		/*  4 bytes */
	uint32_t				padding2;		/*  4 bytes */
} __attribute__((aligned(SAMPLE_FACE_UTIL_TASK_ALIGN))) SampleFaceUtilTask2;

int sampleFaceUtilTask2GetAlign(void);

int sampleFaceUtilInitializeEx(
	CellSpurs2					*faceSpurs,
	CellSpursTaskset2			*faceTaskset,
	const uint8_t				priorities[8],
	int32_t						numOfSpus
);

int sampleFaceUtilFinalizeEx(
	CellSpursTaskset2			*faceTaskset
);

int sampleFaceUtilDetection3DTaskBegin(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*detectTask,
	CellFaceDetectionParam		*detectParam
);
int sampleFaceUtilDetection3DTaskEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*detectTask,
	int32_t						*numFace
);
int sampleFaceUtilDetection3DTaskTryEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*detectTask,
	int32_t						*numFace
);

int sampleFaceUtilPartsTaskBegin(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*partsTask,
	CellFacePartsParam			*partsParam
);
int sampleFaceUtilPartsTaskEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*partsTask
);
int sampleFaceUtilPartsTaskTryEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*partsTask
);

int sampleFaceUtilFeature2TaskBegin(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*featureTask,
	CellFaceFeature2Param		*featureParam
);
int sampleFaceUtilFeature2TaskEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*featureTask
);
int sampleFaceUtilFeature2TaskTryEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*featureTask
);

int sampleFaceUtilSimilarity2TaskBegin(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*simTask,
	CellFaceSimilarity2Param	*simParam
);
int sampleFaceUtilSimilarity2TaskEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*simTask,
	float						*maxScore,
	int32_t						*maxScoreId
);
int sampleFaceUtilSimilarity2TaskTryEnd(
	CellSpursTaskset2			*faceTaskset,
	SampleFaceUtilTask2			*simTask,
	float						*maxScore,
	int32_t						*maxScoreId
);
#ifdef __cplusplus
}
#endif

#endif // __SAMPLE_FACE_UTIL_H__
