/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __LOCAL_FACE_SEARCH_H__
#define __LOCAL_FACE_SEARCH_H__

#include <cell/face.h>
#include <cell/spurs.h>

#include "LocalSearchInfo.h"
#include "sample_face_util.h"


#define LOCAL_FACE_SEARCH_SELF_OVERLAP_THRE 0.6f
#define LOCAL_FACE_SEARCH_OTHER_OVERLAP_THRE 0.6f
#define LOCAL_FACE_SEARCH_SCAN_FACE_MARGIN_X 8
#define LOCAL_FACE_SEARCH_SCAN_FACE_MARGIN_Y 8

#define LOCAL_FACE_SEARCH_OK CELL_FACE_OK
#define LOCAL_FACE_SEARCH_ERROR -1

#define LOCAL_FACE_SEARCH_ALIGN 128


#define MAX_LOCAL_DETECT_NUM 4 //max local detection num

//////////////////////////////////////
// LocalFaceSearch
//////////////////////////////////////
class LocalFaceSearch {
public:
	LocalFaceSearch();
	~LocalFaceSearch();

	static int GetAlign(void); //static member function
	static int GetWorkingMemorySize(int size, int width, int height, int rowstride, int maxTarget); //static member function
	int Initialize(const void *work, const CellSpurs2 *spurs, int width, int height, int rowstride, int maxTarget);
	int Finalize(void);
	
	int ExecFaceSearch(const unsigned char *image, //input
					   const int *targetStatus, //input
					   const LocalSearchInfo *lsInfo, //input
					   int target //input
					   );
	const CellFaceDetectionResult* GetCurrResult(void) const { return &mCurrResult; }
	const CellFacePartsResult* GetPartsResult(int num) const { return &mPartsResult[num]; }
	const CellFacePartsResult* GetPartsResultAll(void) const { return mPartsResult; }
	const CellFacePosition* GetPositionResult(void) const { return &mPosition; }
	void GetPositionResultXYCenter(float *x, float *y) const;
	void GetPositionPartsEyeCenter(float *x, float *y) const;
	void GetPositionResultPose(float *yaw, float *pitch, float *roll) const;
	bool GetDetectPartsFlag(void) const { return mDetectPartsFlag; }
	bool GetOverlapFlag(void) const { return mOverlapFlag; }

private:
	//spurs tastset
	CellSpursTaskset2 mSpursTaskset; //CELL_SPURS_TASKSET_ALIGN (128 byte align)
	//spurs task
	SampleFaceUtilTask2 mDetectTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mPartsTask;  //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mFeatureTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mSimilarityTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)

	//local search result
	CellFaceDetectionParam mDetectParam; //16 byte align
	CellFaceDetectionResult mDetectResult[MAX_LOCAL_DETECT_NUM]; //for detection candidate
	CellFaceDetectionResult mCurrResult; //16 byte align, only one target
	CellFaceOptParamLocalSearch mDetectOpt; //16 byte align
	CellFaceDetectionResultData mDetectData; //16 byte align, for search base

	//parts
	CellFacePosition mPosition; //16 byte align
	CellFacePartsParam mPartsParam;  //16 byte align
	CellFacePartsResult mPartsResult[CELL_FACE_PARTS_NUM_MAX]; //16 byte align
	
	bool mInit;

	//image size 
	int mWidth;
	int mHeight;
	int mRowstride;

	int mMaxTarget;
	bool mOverlapFlag; //other target overlap flag
	bool mDetectPartsFlag; //4 parts detect flag

	//working area
	unsigned char *mWorkingArea; //size depends on image size
	                             //128 byte align
	
	//////////////////////////////////////
	// private function
	//////////////////////////////////////
	bool CheckOverlap(const CellFaceDetectionResult& a, const CellFaceDetectionResult& b,
					  const float thresh);
}; //LocalFaceSearch


#endif //__LOCAL_FACE_SEARCH_H__
