/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_FACE_TRACKER_INTERNAL_H__
#define __CELL_FACE_TRACKER_INTERNAL_H__

#include <cell/spurs.h>

#include "FaceRegisterInfo.h"
#include "LocalSearchInfo.h"
#include "TemplateMatchingInfo.h"
#include "GlobalFaceSearch.h"
#include "LocalFaceSearch.h"
#include "TemplateMatching.h"
#include "TargetInfo.h"
#include "cellImage.h"

#define CELL_FACE_TRACKER_LS_EMPTY_THRE 10
#define CELL_FACE_TRACKER_TM_EMPTY_THRE 10

//layer
#define TEMPLATE_LAYER_VGA   1
#define TEMPLATE_LAYER_QVGA  2
#define TEMPLATE_LAYER_QQVGA 3


//////////////////////////////////////////////////////////////////////
//private
//////////////////////////////////////////////////////////////////////
//structure 
typedef struct CellFaceTracker{
	//Global Search
	GlobalFaceSearch mGlobalSearch; //128 byte align
	//Local Search
	LocalFaceSearch mLocalSearch; //128 byte align
	//Template Matching
	TemplateMatching mTemplateMatching; //128 byte align

	//spurs tastset
	CellSpursTaskset2 mSpursTaskset; //CELL_SPURS_TASKSET_ALIGN (128 byte align)
	//task
	SampleVisionUtilTask2 mResizeHalfTask; //SAMPLE_VISION_UTIL_TASK_ALIGN (16 byte align)
	
	//Image Information
	int mImageWidth;
	int mImageHeight;
	int mImageRowstride;

	unsigned char *mImageQVGA;  //[mImageRowstride/2 *mImageHeight/2] need allocation
	unsigned char *mImageQQVGA; //[mImageRowstride/4 *mImageHeight/4] need allocation
	CellImage mCellImageVGA; // for vision (image data is only pointer) (16 byte align)
	CellImage mCellImageQVGA; // for vision (image data is only pointer) (16 byte align)
	CellImage mCellImageQQVGA; // for vision (image data is only pointer) (16 byte align)
	
	CellImage **mCellLayerImage; //only pointer [mMaxTarget]
	
	//Target Information
	unsigned int mProcessCount; //process counter
	int mMaxTarget;
	int *mTargetStatus; //[mMaxTarget]
	int *mTrackCount; //[mMaxTarget]
	int *mLocalSearchTimingOffset; //[mMaxTarget]
	int *mTemplateLayer; //[mMaxTarget]
	FaceRegisterInfo *mFaceRegisterInfo; //[mMaxTarget] 16 byte align
	LocalSearchInfo *mLocalSearchInfo; //[mMaxTarget] 16 byte align
	TemplateMatchingInfo *mTemplateMatchingInfo; //[mMaxTarget] 16 byte align
	int *mUsedTemplate; //[mMaxTarget]

	//control
	int mLocalSearchInterval; //local search interval timing

} CellFaceTracker;


#ifdef __cplusplus
extern "C" {
#endif

int cellFaceTrackerSelectTemplateLayer(const CellFaceDetectionResult *face,
									   const CellFacePartsResult *parts,
									   int width, int height);

void cellFaceTrackerSetLayerImage(int tgt, int layer);
void cellFaceTrackerSetLayerImageAndTemplate(int tgt, int layer);
void cellFaceTrackerConvLayerPosition(int layer, float *x, float *y);
void cellFaceTrackerUpdateDataBeforeTemplateMatching(int tgt, int layer);
void cellFaceTrackerUpdateDataAfterLocalSearch(int tgt, const CellFaceDetectionResult *face);
void cellFaceTrackerConvOriginalLayerPosition(int layer, float *x, float *y);
void cellFaceTrackerUpdateDataAfterTemplateMatching(int tgt);
void cellFaceTrackerUpdatePreviousTemplate(int tgt);
void cellFaceTrackerUpdateAdditionalAndPreviousTemplate(int tgt);

//for debug
void cellFaceTrackerPrintTargetInfo(FILE *fp, int tgt);


#ifdef __cplusplus
}
#endif


#endif // __CELL_FACE_TRACKER_INTERNAL_H__
