#########################################################
# SCE CONFIDENTIAL
# PlayStation(R)3 Programmer Tool Runtime Library 475.001
# Copyright (C) 2011 Sony Computer Entertainment Inc.
# All Rights Reserved.
#########################################################

CELL_MK_DIR ?= $(CELL_SDK)/samples/mk
include $(CELL_MK_DIR)/sdk.makedef.mk

SUBDIRS		+=	global_face_search
SUBDIRS		+=	local_face_search
SUBDIRS		+=	template_matching
SUBDIRS		+=	sample_face_util
SUBDIRS		+=	sample_vision

PPU_SRCS		=	libface_tracker_main.cpp
PPU_SRCS		+=	common/memory.cpp
PPU_SRCS		+=	face_target_info/FaceRegisterInfo.cpp
PPU_SRCS		+=	face_target_info/LocalSearchInfo.cpp
PPU_SRCS		+=	face_target_info/TemplateMatchingInfo.cpp
PPU_SRCS		+=	global_face_search/global_face_search.a
PPU_SRCS		+=	local_face_search/local_face_search.a
PPU_SRCS		+=	template_matching/template_matching.a
PPU_SRCS		+=	sample_face_util/sample_face_util.a
PPU_SRCS		+=	sample_vision/sample_vision.a

ifneq ($(FACE_LIB_DIR_RELATIVE),)
FACE_LIB_DIR	?= $(FACE_LIB_DIR_RELATIVE)
else
FACE_LIB_DIR	?= $(CELL_SDK)/target
endif

PPU_INCDIRS		=	-I../../include
PPU_INCDIRS		+=	-I./common
PPU_INCDIRS		+=	-I./face_target_info
PPU_INCDIRS		+=	-I./local_face_search
PPU_INCDIRS		+=	-I./global_face_search
PPU_INCDIRS		+=	-I./template_matching
PPU_INCDIRS		+=	-I./sample_face_util
PPU_INCDIRS		+=	-I./sample_vision
PPU_INCDIRS		+=	-I./sample_vision/common
PPU_INCDIRS		+=	-I$(FACE_LIB_DIR)/common/include

PPU_LIB_TARGET	=	../../lib/libface_tracker.a

ifneq ($(FACE_TRACKER_LIB_BUILD), DEBUG)
PPU_DBG_FLAGS	=
PPU_CXXFLAGS	+= -DNDEBUG
PPU_CFLAGS		+= -DNDEBUG
EXTRA_TARGET	=	remove_unneeded_simbols
remove_unneeded_simbols:
	$(PPU_STRIP) -x $(PPU_LIB_TARGET)
endif
PPU_CXXFLAGS	+= -fno-exceptions -fno-rtti

include $(CELL_MK_DIR)/sdk.target.mk
