/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __GLOBAL_FACE_SEARCH_H__
#define __GLOBAL_FACE_SEARCH_H__

#include <cell/spurs.h>
#include <cell/face.h>

#include "FaceRegisterInfo.h"
#include "LocalSearchInfo.h"
#include "sample_face_util.h"
#include "TargetInfo.h"


#define GLOBAL_FACE_SEARCH_OVERLAP_THRE 0.5f
#define GLOBAL_FACE_SEARCH_SIMILARITY_THRE 10.0f

#define GLOBAL_FACE_SEARCH_OK CELL_FACE_OK
#define GLOBAL_FACE_SEARCH_ERROR -1

#define GLOBAL_FACE_SEARCH_ALIGN 128

//callback function argument definition (same definition in face_tracker.h)
typedef void (*CellFaceTrackerCallbackFunc)(const CellFaceFeature2 *feature,
											const void *data);

class GlobalFaceSearch{
public:
	GlobalFaceSearch();
	~GlobalFaceSearch();

	static int GetAlign(void); //static member function
	static int GetWorkingMemorySize(int size, int width, int height, int rowstride,
									int maxTarget); //static member function
	int Initialize(const void *work, const CellSpurs2 *spurs, 
				   int width, int height, int rowstride, int maxTarget);
	int Finalize(void);
	
	int ExecFaceSearch(const unsigned char *image, //input Y image
					   const int *targetStatus, //input
					   const FaceRegisterInfo *frInfo, //input
					   const LocalSearchInfo *lsInfo, //input
					   const CellFaceTrackerCallbackFunc callbackFunc, //input
					   int *numRegisteredNewFace //output
					   );
	
	const CellFaceDetectionResult *GetDetectResult(int num) const {
		return &mGlobalDetectResult[num]; }
	int GetRegisteredTargetNum(int num) const { return mRegisteredTargetNum[num]; }

private:
	//spurs tastset
	CellSpursTaskset2 mSpursTaskset; //CELL_SPURS_TASKSET_ALIGN (128 byte align)
	//spurs task
	SampleFaceUtilTask2 mDetectTask;  //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mPartsTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mFeatureTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	SampleFaceUtilTask2 mSimilarityTask; //SAMPLE_FACE_UTIL_TASK_ALIGN (16 byte align)
	
	//global search result (all)
	CellFaceDetectionParam mDetectParam; //16 byte align
	CellFaceDetectionResult mDetectResult[CELL_FACE_DETECT_NUM_MAX]; //for detection candidate
	CellFacePosition mPosition; //16 byte align
	CellFacePartsParam mPartsParam;  //16 byte align
	CellFacePartsResult mPartsResult[CELL_FACE_PARTS_NUM_MAX];
	//feature
	CellFaceFeature2Param mFeatureParam; //16 byte align
	CellFaceFeature2 mFeature; //16 byte align
	// similarity
	CellFaceSimilarity2Param mSimilarityParam; //16 byte align
	
	bool mInit;
	bool mDetecting;
	
	unsigned char *mSaveImage; //128 byte align data. mRowstride * mHeight
	int *mSaveStatus; //[mMaxTarget]
	CellFaceDetectionResult *mSaveResult; //local search result for overlap check
	                                      //mSaveResult[mMaxTarget]
	                                      //16 byte align

	//global search result (not tracking)
	CellFaceDetectionResult mGlobalDetectResult[CELL_FACE_DETECT_NUM_MAX]; //16 byte align
	int mRegisteredTargetNum[CELL_FACE_DETECT_NUM_MAX];

	//image size 
	int mWidth;
	int mHeight;
	int mRowstride;
	
	int mMaxTarget; //max local search target
	
	//working area
	unsigned char *mWorkingArea; //size depends on image size
	                             //128 byte align data

	//////////////////////////////////////
	// private function
	//////////////////////////////////////
	bool CheckOverlap(const CellFaceDetectionResult& a, const CellFaceDetectionResult& b,
					  const float thresh);

};  //GlobalFaceSearch


#endif //__GLOBAL_FACE_SEARCH_H__
