/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __TEMPLATE_MATCHING_INFO_H__
#define __TEMPLATE_MATCHING_INFO_H__


#define TEMPLATE_MATCHING_INFO_OK 0
#define TEMPLATE_MATCHING_INFO_ERROR -1

#define TEMPLATE_MATCHING_INFO_ALIGN 16


#define TM_SCORE_THRE 0.95f //threshold for all template score
#define TM_SCORE_THRE_BASE 0.90f //threshold of for base template score


#define TM_TEMPLATE_SIZE 16

//template
enum TM_TEMPLATE_NUM { TM_TEMPLATE_FRONT = 0, TM_TEMPLATE_LEFT_ROLL,
	TM_TEMPLATE_RIGHT_ROLL, TM_TEMPLATE_ADDITIONAL, TM_TEMPLATE_PREVIOUS,
	TM_TEMPLATE_NUM_MAX };

#define TM_TEMPLATE_MEM_SIZE (TM_TEMPLATE_SIZE * TM_TEMPLATE_SIZE)
#define TM_TEMPLATE_MEM_SIZE_ALL (TM_TEMPLATE_NUM_MAX * TM_TEMPLATE_MEM_SIZE)



//////////////////////////
//TemplateMatchingInfo
//////////////////////////
class TemplateMatchingInfo{
public:
	
	TemplateMatchingInfo();
	~TemplateMatchingInfo();
	static int GetAlign(void);
	static int GetWorkingMemorySize(int size);
	int Initialize(const void *work);
	int Finalize(void);

	void GetPosition(float *x, float *y) const;
	const unsigned char* GetTemplateAll(void) const { return mTemplate; }
	const unsigned char* GetTemplate(TM_TEMPLATE_NUM num) const
	{ return &mTemplate[TM_TEMPLATE_MEM_SIZE * num]; }
	int GetLostCount(void) const { return mLostCount; }
	
	void SetPosition(float x, float y);
	void SetTemplate(TM_TEMPLATE_NUM num, const unsigned char *tplate);

	void CreateTemplateAll(const unsigned char *image, int width, int height, float x, float y, float roll);
	void UpdateTemplatePrev(const unsigned char *image, int width, int height, float x, float y);
	void UpdateTemplateAdditional(void);
	void ClearTemplateAll(void);
	
	void ClearLostCount(void) { mLostCount = 0; }
	void IncrementLostCount(void) { mLostCount++; }
	
private:
	unsigned char mTemplate[TM_TEMPLATE_MEM_SIZE_ALL] __attribute__((aligned(16)));
	              //1D array [mTemplateSize^2 * mMaxTemplateNum]
	              //need align for DMA
	float mPosX; //template center position x
	float mPosY; //template center position y
	int mLostCount; //template lost count
	
	bool mInit;

	////////////////////////////
	// function
	////////////////////////////
	void CropRollTemplate(TM_TEMPLATE_NUM num, const unsigned char *image,
						 int width, int height, int rowstride,
						 float x, float y, float roll);
};  //TemplateMatchingInfo


#endif //__TEMPLATE_MATCHING_INFO_H__
