/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __LOCAL_SEARCH_INFO_H__
#define __LOCAL_SEARCH_INFO_H__

#include <cell/face.h>

#define LOCAL_SEARCH_INFO_OK 0
#define LOCAL_SEARCH_INFO_ERROR -1

#define LOCAL_SEARCH_INFO_ALIGN 16

//////////////////////////
//LocalSearchInfo
//////////////////////////
class LocalSearchInfo {
public:
	LocalSearchInfo();
	~LocalSearchInfo();
	static int GetAlign(void);
	static int GetWorkingMemorySize(int size);
	int Initialize(const void *work);
	int Finalize(void);

	const CellFaceDetectionResult* GetDetectResult() const { return &mDetectResult; }
	int SetDetectResult(const CellFaceDetectionResult *result);
	int SetDetectResultOffset(float offsetx, float offsety);
	
	int GetLostCount() const { return mLostCount; }
	void IncrementLostCount() { mLostCount++; }
	void ClearLostCount() { mLostCount = 0; }

	void PrintDetectResult();
	void PrintPosition();

private:
	//local search face detection (x,y,w,h,roll,pitch,yaw)
	CellFaceDetectionResult mDetectResult; // 16 byte alignment
	int mLostCount; //local search lost count
	
};  //LocalSearchInfo


#endif //__LOCAL_SEARCH_INFO_H__
