/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <cell/face.h>

#include <new>

#include "LocalSearchInfo.h"

#define max(a, b) (((a) > (b)) ? (a) : (b))

////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////
LocalSearchInfo::
LocalSearchInfo()
{
	
}

////////////////////////////////////////////////
// Destructor
////////////////////////////////////////////////
LocalSearchInfo::
~LocalSearchInfo()
{
	
}

////////////////////////////////////////////////
// GetAlign
////////////////////////////////////////////////
int LocalSearchInfo::
GetAlign(void)
{
	int align = LOCAL_SEARCH_INFO_ALIGN;

	align = max(align, 16); //compare CellFace...
	
	return align;
}

////////////////////////////////////////////////
// GetWorkingMemorySize
////////////////////////////////////////////////
int LocalSearchInfo::
GetWorkingMemorySize(int size)
{
	int memsize = size;

	return (memsize - size);
}

////////////////////////////////////////////////
// Initialize
////////////////////////////////////////////////
int LocalSearchInfo::
Initialize(const void *work)
{
	unsigned char *p = (unsigned char*)work;

	////////////////////////////////
	// set paramter
	////////////////////////////////
	memset(&mDetectResult, 0, sizeof(CellFaceDetectionResult));
	mLostCount = 0;
	
	return (int)(p - (unsigned char*)work);
}

////////////////////////////////////////////////
// Finalize
////////////////////////////////////////////////
int LocalSearchInfo::
Finalize(void)
{
	return LOCAL_SEARCH_INFO_OK;
}

////////////////////////////////////////////////
// SetDetectResult
////////////////////////////////////////////////
int LocalSearchInfo::
SetDetectResult(const CellFaceDetectionResult *result)
{
	memcpy(&mDetectResult, result, sizeof(CellFaceDetectionResult));

	return LOCAL_SEARCH_INFO_OK;
}

////////////////////////////////////////////////
// SetDetectResultOffset
// offsetx, offsety : normalized scale
////////////////////////////////////////////////
int LocalSearchInfo::
SetDetectResultOffset(float offsetx, float offsety)
{
	mDetectResult.faceX += offsetx;
	mDetectResult.faceY += offsety;

	return LOCAL_SEARCH_INFO_OK;
}

