/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __FACE_REGISER_INFO_H__
#define __FACE_REGISER_INFO_H__

#include <cell/face.h>

#define FACE_REGISTER_INFO_OK 0
#define FACE_REGISTER_INFO_ERROR -1

#define FACE_REGISTER_INFO_ALIGN 16

#define FACE_REGISTER_INFO_UNREGISTERED_ID -1

//////////////////////////
//FaceRegisterInfo
//////////////////////////
class FaceRegisterInfo {
public:
	FaceRegisterInfo();
	~FaceRegisterInfo();

	static int GetAlign(void);
	static int GetWorkingMemorySize(int size);
	int Initialize(const void *work);
	int Finalize(void);
	
	int GetID() const { return mID; }
	const CellFaceFeature2* GetFeature() const { return &mFeature; }
	
	int RegisterFaceID(int id, const CellFaceFeature2 *feature);
	int UnregisterFaceID(void);
	
private:
	int mID; //register face id
	CellFaceFeature2 mFeature; //register face feature , 16 byte alignment
	
};  //FaceRegisterInfo



#endif //__FACE_REGISER_INFO_H__
