/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <cell/face.h>

#include <new>

#include "memory.h"
#include "FaceRegisterInfo.h"


#define max(a, b) (((a) > (b)) ? (a) : (b))


////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////
FaceRegisterInfo::
FaceRegisterInfo()
{
	
}

////////////////////////////////////////////////
// Destructor
////////////////////////////////////////////////
FaceRegisterInfo::
~FaceRegisterInfo()
{
	
}

////////////////////////////////////////////////
// GetAlign
////////////////////////////////////////////////
int FaceRegisterInfo::
GetAlign(void)
{
	int align = FACE_REGISTER_INFO_ALIGN;

	align = max(align, 16); //compare CellFaceFeature2 align

	return align;
}

////////////////////////////////////////////////
// GetWorkingMemorySize
////////////////////////////////////////////////
int FaceRegisterInfo::
GetWorkingMemorySize(int size)
{
	int memsize = size;
	
	//increment memsize if you have pointer variables or class

	return (memsize - size);
}

////////////////////////////////////////////////
// Initialize
////////////////////////////////////////////////
int FaceRegisterInfo::
Initialize(const void *work)
{
	unsigned char *p = (unsigned char*)work;

	////////////////////////////////
	// set paramter
	////////////////////////////////
	mID = FACE_REGISTER_INFO_UNREGISTERED_ID;
	memset(&mFeature, 0, sizeof(CellFaceFeature2));
	
	return (int)(p - (unsigned char*)work);
}

////////////////////////////////////////////////
// Finalize
////////////////////////////////////////////////
int FaceRegisterInfo::
Finalize(void)
{
	return FACE_REGISTER_INFO_OK;
}


////////////////////////////////////////////////
// RegistereFaceID
////////////////////////////////////////////////
int FaceRegisterInfo::
RegisterFaceID(int id, const CellFaceFeature2 *feature)
{
	mID = id;
	memcpy(&mFeature, feature, sizeof(CellFaceFeature2));

	return FACE_REGISTER_INFO_OK;
}

////////////////////////////////////////////////
// UnregistereFaceID
////////////////////////////////////////////////
int FaceRegisterInfo::
UnregisterFaceID(void)
{
	mID = FACE_REGISTER_INFO_UNREGISTERED_ID;
	memset(&mFeature, 0, sizeof(CellFaceFeature2));
	
	return FACE_REGISTER_INFO_OK;
}

