/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#include <stdint.h>
#include <stdio.h>
#include "memory.h"

/*******************************************************************************
 * assign_memory_byte_align()
 ********************************************************************************/
int assign_memory_byte_align(int byte, void *work, void *ptr, int memsize)
{
	char *wp = (char *)work;

	wp += skip_byte_align(byte, (unsigned int)wp);
	
	*(char **)ptr = wp;

	wp += memsize;
	
	return (int)(wp - (char *)work);
}

/*******************************************************************************
 * sizeof_byte_align()
 ********************************************************************************/
int sizeof_byte_align(int byte, unsigned int start, int memsize)
{
	unsigned int s = start;

	s += skip_byte_align(byte, s);
	s += memsize;

	return (int)(s - start);
}

/*******************************************************************************
 * skip N Byte Align
 ********************************************************************************/
int skip_byte_align(int byte, unsigned int size)
{
	int bitshift = byte_to_bitshift(byte);
	unsigned int mask = 0x1 << bitshift;
	unsigned int s = size;

	if(s != ((s >> bitshift) << bitshift)) {
		s += mask;
		s >>= bitshift;
		s <<= bitshift;
	}
	
	return (int)(s - size);
}

/***************************************************************************
  byte to bitshit
***************************************************************************/
int byte_to_bitshift(int byte)
{
	int bit = 0;
	while(byte > 1) {
		byte >>= 1;
		bit++;
	}
	return bit;
}
