/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _DEBUG_H_
#define _DEBUG_H_

#include <stdio.h>
#include <stdlib.h>

#ifdef NDEBUG
#define ENABLE_DEBUG_OUTPUT 0
#else
#define ENABLE_DEBUG_OUTPUT 1
#endif

#define ENABLE_ERROR_OUTPUT 1

#if ENABLE_INFO_OUTPUT
#  define INFO(x)     {printf("INFO %s(%d) %s: ", __FILE__, __LINE__, __FUNCTION__); printf x;}
#  define INFO_MSG(x) {printf("INFO: ");                                             printf x;}
#else
#  define INFO(x)
#  define INFO_MSG(x)
#endif // ENABLE_DEBUG

#if ENABLE_DEBUG_OUTPUT
#  define DEBUG(x)     {printf("DEBUG %s(%d) %s: ", __FILE__, __LINE__, __FUNCTION__); printf x;}
#  define DEBUG_MSG(x) {printf("DEBUG: ");                                             printf x;}
#ifdef __SPU__
#include <spu_printf.h>
#define SPU_DEBUG(...) \
	do { \
		spu_printf("[SPU] %s:%d: ", __FILE__, __LINE__); \
		spu_printf(__VA_ARGS__); \
	} while(0)
#endif
#ifdef __PPU__
#include <stdio.h>
#define PPU_DEBUG(...) \
	do { \
		printf("[PPU] %s:%d: ", __FILE__, __LINE__); \
		printf(__VA_ARGS__); \
	} while(0)
#endif
#else
#  define DEBUG(x)
#  define DEBUG_MSG(x)
#ifdef __SPU__
#define SPU_DEBUG(...)
#endif
#ifdef __PPU__
#define PPU_DEBUG(...)
#endif
#endif // ENABLE_DEBUG

#if ENABLE_ERROR_OUTPUT
#  define ERROR(x)     {printf("ERROR %s(%d) %s: ", __FILE__, __LINE__, __FUNCTION__); printf x;}
#  define ERROR_MSG(x) {printf("ERROR: ");                                             printf x;}
#else
#  define ERROR(x)
#  define ERROR_MSG(x)
#endif // ENABLE_ERROR

#endif //_DEBUG_H_
