/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 *                Copyright (C) 2010 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */

 
/*
 * 
 */

#include <PSGL/psgl.h>
#include <PSGL/private.h>
#include <string.h>

const char *_jsMapLookupEnum( const JSenumMap* map, unsigned int count, GLenum e )
{
    for ( GLuint i = 0;i < count;++i )
    {
        if ( map[i].e == e ) return map[i].s;
    }
    return NULL;
}

GLenum _jsMapLookupString( const JSenumMap* map, unsigned int count, const char *s )
{
    if ( s != NULL ) for ( GLuint i = 0;i < count;++i )
        {
            if ( 0 == strcmp( map[i].s, s ) ) return map[i].e;
        }
    return -1U;
}

#ifdef JS_REPORT
#define MAP_ENUM(ENUM) {ENUM, #ENUM}
static JSenumMap _jsGlEnumMap[] =
    {
        MAP_ENUM( GL_FALSE ),
        MAP_ENUM( GL_NO_ERROR ),
        MAP_ENUM( GL_NONE ),
        MAP_ENUM( GL_ZERO ),
        MAP_ENUM( GL_POINTS ),
        MAP_ENUM( GL_ONE ),
        MAP_ENUM( GL_TRUE ),
        MAP_ENUM( GL_LINES ),
        MAP_ENUM( GL_LINE_LOOP ),
        MAP_ENUM( GL_LINE_STRIP ),
        MAP_ENUM( GL_TRIANGLES ),
        MAP_ENUM( GL_TRIANGLE_STRIP ),
        MAP_ENUM( GL_TRIANGLE_FAN ),
        MAP_ENUM( GL_QUADS ),
        MAP_ENUM( GL_QUAD_STRIP ),
        MAP_ENUM( GL_ADD ),
        MAP_ENUM( GL_NEVER ),
        MAP_ENUM( GL_LESS ),
        MAP_ENUM( GL_EQUAL ),
        MAP_ENUM( GL_LEQUAL ),
        MAP_ENUM( GL_GREATER ),
        MAP_ENUM( GL_NOTEQUAL ),
        MAP_ENUM( GL_GEQUAL ),
        MAP_ENUM( GL_ALWAYS ),
        MAP_ENUM( GL_SRC_COLOR ),
        MAP_ENUM( GL_ONE_MINUS_SRC_COLOR ),
        MAP_ENUM( GL_SRC_ALPHA ),
        MAP_ENUM( GL_ONE_MINUS_SRC_ALPHA ),
        MAP_ENUM( GL_DST_ALPHA ),
        MAP_ENUM( GL_ONE_MINUS_DST_ALPHA ),
        MAP_ENUM( GL_DST_COLOR ),
        MAP_ENUM( GL_ONE_MINUS_DST_COLOR ),
        MAP_ENUM( GL_SRC_ALPHA_SATURATE ),
        MAP_ENUM( GL_FRONT ),
        MAP_ENUM( GL_BACK ),
        MAP_ENUM( GL_FRONT_AND_BACK ),
        MAP_ENUM( GL_EXP ),
        MAP_ENUM( GL_EXP2 ),
        MAP_ENUM( GL_CW ),
        MAP_ENUM( GL_CCW ),
        MAP_ENUM( GL_POINT_SMOOTH ),
        MAP_ENUM( GL_SMOOTH_POINT_SIZE_RANGE ),
        MAP_ENUM( GL_LINE_SMOOTH ),
        MAP_ENUM( GL_SMOOTH_LINE_WIDTH_RANGE ),
        MAP_ENUM( GL_CULL_FACE ),
        MAP_ENUM( GL_LIGHTING ),
        MAP_ENUM( GL_LIGHT_MODEL_TWO_SIDE ),
        MAP_ENUM( GL_LIGHT_MODEL_AMBIENT ),
        MAP_ENUM( GL_COLOR_MATERIAL ),
        MAP_ENUM( GL_FOG ),
        MAP_ENUM( GL_FOG_DENSITY ),
        MAP_ENUM( GL_FOG_START ),
        MAP_ENUM( GL_FOG_END ),
        MAP_ENUM( GL_FOG_MODE ),
        MAP_ENUM( GL_FOG_COLOR ),
        MAP_ENUM( GL_DEPTH_TEST ),
        MAP_ENUM( GL_STENCIL_TEST ),
        MAP_ENUM( GL_NORMALIZE ),
        MAP_ENUM( GL_MODELVIEW_MATRIX ),
        MAP_ENUM( GL_PROJECTION_MATRIX ),
        MAP_ENUM( GL_TEXTURE_MATRIX ),
        MAP_ENUM( GL_ALPHA_TEST ),
        MAP_ENUM( GL_DITHER ),
        MAP_ENUM( GL_BLEND ),
        MAP_ENUM( GL_COLOR_LOGIC_OP ),
        MAP_ENUM( GL_SCISSOR_TEST ),
        MAP_ENUM( GL_PERSPECTIVE_CORRECTION_HINT ),
        MAP_ENUM( GL_POINT_SMOOTH_HINT ),
        MAP_ENUM( GL_LINE_SMOOTH_HINT ),
        MAP_ENUM( GL_POLYGON_SMOOTH_HINT ),
        MAP_ENUM( GL_FOG_HINT ),
        MAP_ENUM( GL_TEXTURE_GEN_S ),
        MAP_ENUM( GL_TEXTURE_GEN_T ),
        MAP_ENUM( GL_TEXTURE_GEN_R ),
        MAP_ENUM( GL_TEXTURE_GEN_Q ),
        MAP_ENUM( GL_UNPACK_ALIGNMENT ),
        MAP_ENUM( GL_PACK_ALIGNMENT ),
        MAP_ENUM( GL_MAX_LIGHTS ),
        MAP_ENUM( GL_MAX_TEXTURE_SIZE ),
        MAP_ENUM( GL_MAX_MODELVIEW_STACK_DEPTH ),
        MAP_ENUM( GL_MAX_PROJECTION_STACK_DEPTH ),
        MAP_ENUM( GL_MAX_TEXTURE_STACK_DEPTH ),
        MAP_ENUM( GL_MAX_VIEWPORT_DIMS ),
        MAP_ENUM( GL_SUBPIXEL_BITS ),
        MAP_ENUM( GL_RED_BITS ),
        MAP_ENUM( GL_GREEN_BITS ),
        MAP_ENUM( GL_BLUE_BITS ),
        MAP_ENUM( GL_ALPHA_BITS ),
        MAP_ENUM( GL_DEPTH_BITS ),
        MAP_ENUM( GL_STENCIL_BITS ),
        MAP_ENUM( GL_TEXTURE_2D ),
        MAP_ENUM( GL_DONT_CARE ),
        MAP_ENUM( GL_FASTEST ),
        MAP_ENUM( GL_NICEST ),
        MAP_ENUM( GL_AMBIENT ),
        MAP_ENUM( GL_DIFFUSE ),
        MAP_ENUM( GL_SPECULAR ),
        MAP_ENUM( GL_POSITION ),
        MAP_ENUM( GL_SPOT_DIRECTION ),
        MAP_ENUM( GL_SPOT_EXPONENT ),
        MAP_ENUM( GL_SPOT_CUTOFF ),
        MAP_ENUM( GL_CONSTANT_ATTENUATION ),
        MAP_ENUM( GL_LINEAR_ATTENUATION ),
        MAP_ENUM( GL_QUADRATIC_ATTENUATION ),
        MAP_ENUM( GL_BYTE ),
        MAP_ENUM( GL_UNSIGNED_BYTE ),
        MAP_ENUM( GL_SHORT ),
        MAP_ENUM( GL_UNSIGNED_SHORT ),
        MAP_ENUM( GL_INT ),
        MAP_ENUM( GL_UNSIGNED_INT ),
        MAP_ENUM( GL_FLOAT ),
        MAP_ENUM( GL_HALF_FLOAT_ARB ),
        MAP_ENUM( GL_FIXED ),
        MAP_ENUM( GL_CLEAR ),
        MAP_ENUM( GL_AND ),
        MAP_ENUM( GL_AND_REVERSE ),
        MAP_ENUM( GL_COPY ),
        MAP_ENUM( GL_AND_INVERTED ),
        MAP_ENUM( GL_NOOP ),
        MAP_ENUM( GL_XOR ),
        MAP_ENUM( GL_OR ),
        MAP_ENUM( GL_NOR ),
        MAP_ENUM( GL_EQUIV ),
        MAP_ENUM( GL_INVERT ),
        MAP_ENUM( GL_OR_REVERSE ),
        MAP_ENUM( GL_COPY_INVERTED ),
        MAP_ENUM( GL_OR_INVERTED ),
        MAP_ENUM( GL_NAND ),
        MAP_ENUM( GL_SET ),
        MAP_ENUM( GL_EMISSION ),
        MAP_ENUM( GL_SHININESS ),
        MAP_ENUM( GL_AMBIENT_AND_DIFFUSE ),
        MAP_ENUM( GL_MODELVIEW ),
        MAP_ENUM( GL_PROJECTION ),
        MAP_ENUM( GL_TEXTURE ),
        MAP_ENUM( GL_DEPTH_COMPONENT ),
        MAP_ENUM( GL_RED ),
        MAP_ENUM( GL_GREEN ),
        MAP_ENUM( GL_BLUE ),
        MAP_ENUM( GL_ALPHA ),
        MAP_ENUM( GL_RGB ),
        MAP_ENUM( GL_RGBA ),
        MAP_ENUM( GL_LUMINANCE ),
        MAP_ENUM( GL_LUMINANCE_ALPHA ),
        MAP_ENUM( GL_POINT ),
        MAP_ENUM( GL_LINE ),
        MAP_ENUM( GL_FILL ),
        MAP_ENUM( GL_FLAT ),
        MAP_ENUM( GL_SMOOTH ),
        MAP_ENUM( GL_KEEP ),
        MAP_ENUM( GL_REPLACE ),
        MAP_ENUM( GL_INCR ),
        MAP_ENUM( GL_DECR ),
        MAP_ENUM( GL_VENDOR ),
        MAP_ENUM( GL_RENDERER ),
        MAP_ENUM( GL_VERSION ),
        MAP_ENUM( GL_EXTENSIONS ),
        MAP_ENUM( GL_S ),
        MAP_ENUM( GL_T ),
        MAP_ENUM( GL_R ),
        MAP_ENUM( GL_Q ),
        MAP_ENUM( GL_MODULATE ),
        MAP_ENUM( GL_DECAL ),
        MAP_ENUM( GL_TEXTURE_ENV_MODE ),
        MAP_ENUM( GL_TEXTURE_ENV_COLOR ),
        MAP_ENUM( GL_TEXTURE_ENV ),
        MAP_ENUM( GL_EYE_LINEAR ),
        MAP_ENUM( GL_OBJECT_LINEAR ),
        MAP_ENUM( GL_SPHERE_MAP ),
        MAP_ENUM( GL_TEXTURE_GEN_MODE ),
        MAP_ENUM( GL_OBJECT_PLANE ),
        MAP_ENUM( GL_EYE_PLANE ),
        MAP_ENUM( GL_NEAREST ),
        MAP_ENUM( GL_LINEAR ),
        MAP_ENUM( GL_NEAREST_MIPMAP_NEAREST ),
        MAP_ENUM( GL_LINEAR_MIPMAP_NEAREST ),
        MAP_ENUM( GL_NEAREST_MIPMAP_LINEAR ),
        MAP_ENUM( GL_LINEAR_MIPMAP_LINEAR ),
        MAP_ENUM( GL_TEXTURE_MAG_FILTER ),
        MAP_ENUM( GL_TEXTURE_MIN_FILTER ),
        MAP_ENUM( GL_TEXTURE_WRAP_S ),
        MAP_ENUM( GL_TEXTURE_WRAP_T ),
        MAP_ENUM( GL_CLAMP ),
        MAP_ENUM( GL_REPEAT ),
        MAP_ENUM( GL_R3_G3_B2 ),
        MAP_ENUM( GL_LIGHT0 ),
        MAP_ENUM( GL_LIGHT1 ),
        MAP_ENUM( GL_LIGHT2 ),
        MAP_ENUM( GL_LIGHT3 ),
        MAP_ENUM( GL_LIGHT4 ),
        MAP_ENUM( GL_LIGHT5 ),
        MAP_ENUM( GL_LIGHT6 ),
        MAP_ENUM( GL_LIGHT7 ),
        MAP_ENUM( GL_FLOAT_DEPTH_COMPONENT16_SCE ),
        MAP_ENUM( GL_FLOAT_DEPTH_COMPONENT32_SCE ),
        MAP_ENUM( GL_DEPTH24_STENCIL8_SCE ),
        MAP_ENUM( GL_STENCIL8_SCE ),
        MAP_ENUM( GL_DRAW_DEPTH_SCE ),
        MAP_ENUM( GL_DRAW_STENCIL_SCE ),
        MAP_ENUM( GL_VSYNC_SCE ),
        MAP_ENUM( GL_SKIP_FIRST_VSYNC_SCE ),
        MAP_ENUM( GL_ARGB_SCE ),
        MAP_ENUM( GL_UNSIGNED_INT_24_8_SCE ),
        MAP_ENUM( GL_UNSIGNED_INT_8_24_REV_SCE ),
        MAP_ENUM( GL_ALPHA_LUMINANCE_SCE ),
        MAP_ENUM( GL_UNSIGNED_SHORT_8_8_SCE ),
        MAP_ENUM( GL_UNSIGNED_SHORT_8_8_REV_SCE ),
        MAP_ENUM( GL_UNSIGNED_INT_16_16_SCE ),
        MAP_ENUM( GL_UNSIGNED_INT_16_16_REV_SCE ),
        MAP_ENUM( GL_TEXTURE_GAMMA_REMAP_R_SCE ),
        MAP_ENUM( GL_TEXTURE_GAMMA_REMAP_G_SCE ),
        MAP_ENUM( GL_TEXTURE_GAMMA_REMAP_B_SCE ),
        MAP_ENUM( GL_TEXTURE_GAMMA_REMAP_A_SCE ),
        MAP_ENUM( GL_SHADER_SRGB_REMAP_SCE ),
        MAP_ENUM( GL_DIVIDE_SCE ),
        MAP_ENUM( GL_MODULO_SCE ),
        MAP_ENUM( GL_TEXTURE_FROM_VERTEX_PROGRAM_SCE ),
        MAP_ENUM( GL_SYSTEM_DRAW_SCE ),
        MAP_ENUM( GL_ABGR ),
        MAP_ENUM( GL_UNSIGNED_BYTE_3_3_2 ),
        MAP_ENUM( GL_UNSIGNED_SHORT_4_4_4_4 ),
        MAP_ENUM( GL_UNSIGNED_SHORT_5_5_5_1 ),
        MAP_ENUM( GL_UNSIGNED_INT_8_8_8_8 ),
        MAP_ENUM( GL_UNSIGNED_INT_10_10_10_2 ),
        MAP_ENUM( GL_POLYGON_OFFSET_FILL ),
        MAP_ENUM( GL_POLYGON_OFFSET_LINE ),
        MAP_ENUM( GL_RESCALE_NORMAL ),
        MAP_ENUM( GL_ALPHA4 ),
        MAP_ENUM( GL_ALPHA8 ),
        MAP_ENUM( GL_ALPHA12 ),
        MAP_ENUM( GL_ALPHA16 ),
        MAP_ENUM( GL_LUMINANCE4 ),
        MAP_ENUM( GL_LUMINANCE8 ),
        MAP_ENUM( GL_LUMINANCE12 ),
        MAP_ENUM( GL_LUMINANCE16 ),
        MAP_ENUM( GL_LUMINANCE4_ALPHA4 ),
        MAP_ENUM( GL_LUMINANCE6_ALPHA2 ),
        MAP_ENUM( GL_LUMINANCE8_ALPHA8 ),
        MAP_ENUM( GL_LUMINANCE12_ALPHA4 ),
        MAP_ENUM( GL_LUMINANCE12_ALPHA12 ),
        MAP_ENUM( GL_LUMINANCE16_ALPHA16 ),
        MAP_ENUM( GL_INTENSITY ),
        MAP_ENUM( GL_INTENSITY4 ),
        MAP_ENUM( GL_INTENSITY8 ),
        MAP_ENUM( GL_INTENSITY12 ),
        MAP_ENUM( GL_INTENSITY16 ),
        MAP_ENUM( GL_RGB4 ),
        MAP_ENUM( GL_RGB5 ),
        MAP_ENUM( GL_RGB8 ),
        MAP_ENUM( GL_RGB10 ),
        MAP_ENUM( GL_RGB12 ),
        MAP_ENUM( GL_RGB16 ),
        MAP_ENUM( GL_RGBA2 ),
        MAP_ENUM( GL_RGBA4 ),
        MAP_ENUM( GL_RGB5_A1 ),
        MAP_ENUM( GL_RGBA8 ),
        MAP_ENUM( GL_RGB10_A2 ),
        MAP_ENUM( GL_RGBA12 ),
        MAP_ENUM( GL_RGBA16 ),
        MAP_ENUM( GL_TEXTURE_3D ),
        MAP_ENUM( GL_TEXTURE_WRAP_R ),
        MAP_ENUM( GL_MAX_3D_TEXTURE_SIZE ),
        MAP_ENUM( GL_VERTEX_ARRAY ),
        MAP_ENUM( GL_NORMAL_ARRAY ),
        MAP_ENUM( GL_COLOR_ARRAY ),
        MAP_ENUM( GL_TEXTURE_COORD_ARRAY ),
        MAP_ENUM( GL_MULTISAMPLE ),
        MAP_ENUM( GL_SAMPLE_ALPHA_TO_COVERAGE ),
        MAP_ENUM( GL_SAMPLE_ALPHA_TO_ONE ),
        MAP_ENUM( GL_SAMPLE_COVERAGE ),
        MAP_ENUM( GL_BGR ),
        MAP_ENUM( GL_BGRA ),
        MAP_ENUM( GL_MAX_ELEMENTS_VERTICES ),
        MAP_ENUM( GL_MAX_ELEMENTS_INDICES ),
        MAP_ENUM( GL_CLAMP_TO_EDGE ),
        MAP_ENUM( GL_MIRRORED_REPEAT ),
        MAP_ENUM( GL_MIRROR_CLAMP_EXT ),
        MAP_ENUM( GL_MIRROR_CLAMP_TO_EDGE_EXT ),
        MAP_ENUM( GL_MIRROR_CLAMP_TO_BORDER_EXT ),
        MAP_ENUM( GL_CLAMP_TO_BORDER ),
        MAP_ENUM( GL_TEXTURE_MIN_LOD ),
        MAP_ENUM( GL_TEXTURE_MAX_LOD ),
        /*    MAP_ENUM(GL_TEXTURE_BASE_LEVEL),*/
        MAP_ENUM( GL_TEXTURE_MAX_LEVEL ),
        MAP_ENUM( GL_DEPTH_COMPONENT16 ),
        MAP_ENUM( GL_DEPTH_COMPONENT24 ),
        MAP_ENUM( GL_DEPTH_COMPONENT32 ),
        MAP_ENUM( GL_UNSIGNED_BYTE_2_3_3_REV ),
        MAP_ENUM( GL_UNSIGNED_SHORT_5_6_5 ),
        MAP_ENUM( GL_UNSIGNED_SHORT_5_6_5_REV ),
        MAP_ENUM( GL_UNSIGNED_SHORT_4_4_4_4_REV ),
        MAP_ENUM( GL_UNSIGNED_SHORT_1_5_5_5_REV ),
        MAP_ENUM( GL_UNSIGNED_INT_8_8_8_8_REV ),
        MAP_ENUM( GL_UNSIGNED_INT_2_10_10_10_REV ),
        MAP_ENUM( GL_COMPRESSED_RGB_S3TC_DXT1_EXT ),
        MAP_ENUM( GL_COMPRESSED_RGBA_S3TC_DXT1_EXT ),
        MAP_ENUM( GL_COMPRESSED_RGBA_S3TC_DXT3_EXT ),
        MAP_ENUM( GL_COMPRESSED_RGBA_S3TC_DXT5_EXT ),
        MAP_ENUM( GL_FOG_COORDINATE_SOURCE ),
        MAP_ENUM( GL_FOG_COORDINATE ),
        MAP_ENUM( GL_FRAGMENT_DEPTH ),
        MAP_ENUM( GL_ALIASED_POINT_SIZE_RANGE ),
        MAP_ENUM( GL_ALIASED_LINE_WIDTH_RANGE ),
        MAP_ENUM( GL_TEXTURE0 ),
        MAP_ENUM( GL_TEXTURE1 ),
        MAP_ENUM( GL_TEXTURE2 ),
        MAP_ENUM( GL_TEXTURE3 ),
        MAP_ENUM( GL_TEXTURE4 ),
        MAP_ENUM( GL_TEXTURE5 ),
        MAP_ENUM( GL_TEXTURE6 ),
        MAP_ENUM( GL_TEXTURE7 ),
        MAP_ENUM( GL_TEXTURE8 ),
        MAP_ENUM( GL_TEXTURE9 ),
        MAP_ENUM( GL_TEXTURE10 ),
        MAP_ENUM( GL_TEXTURE11 ),
        MAP_ENUM( GL_TEXTURE12 ),
        MAP_ENUM( GL_TEXTURE13 ),
        MAP_ENUM( GL_TEXTURE14 ),
        MAP_ENUM( GL_TEXTURE15 ),
        MAP_ENUM( GL_TEXTURE16 ),
        MAP_ENUM( GL_TEXTURE17 ),
        MAP_ENUM( GL_TEXTURE18 ),
        MAP_ENUM( GL_TEXTURE19 ),
        MAP_ENUM( GL_TEXTURE20 ),
        MAP_ENUM( GL_TEXTURE21 ),
        MAP_ENUM( GL_TEXTURE22 ),
        MAP_ENUM( GL_TEXTURE23 ),
        MAP_ENUM( GL_TEXTURE24 ),
        MAP_ENUM( GL_TEXTURE25 ),
        MAP_ENUM( GL_TEXTURE26 ),
        MAP_ENUM( GL_TEXTURE27 ),
        MAP_ENUM( GL_TEXTURE28 ),
        MAP_ENUM( GL_TEXTURE29 ),
        MAP_ENUM( GL_TEXTURE30 ),
        MAP_ENUM( GL_TEXTURE31 ),
        MAP_ENUM( GL_MAX_TEXTURE_UNITS ),
        MAP_ENUM( GL_TEXTURE_MAX_ANISOTROPY_EXT ),
        MAP_ENUM( GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT ),
        MAP_ENUM( GL_TEXTURE_FILTER_CONTROL ),
        MAP_ENUM( GL_TEXTURE_LOD_BIAS ),
        MAP_ENUM( GL_NORMAL_MAP ),
        MAP_ENUM( GL_REFLECTION_MAP ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_POSITIVE_X ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_NEGATIVE_X ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_POSITIVE_Y ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_NEGATIVE_Y ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_POSITIVE_Z ),
        MAP_ENUM( GL_TEXTURE_CUBE_MAP_NEGATIVE_Z ),
        MAP_ENUM( GL_PRIMITIVE_RESTART_NV ),
        MAP_ENUM( GL_NUM_COMPRESSED_TEXTURE_FORMATS ),
        MAP_ENUM( GL_COMPRESSED_TEXTURE_FORMATS ),
        MAP_ENUM( GL_RGBA32F_ARB ),
        MAP_ENUM( GL_RGB32F_ARB ),
        MAP_ENUM( GL_ALPHA32F_ARB ),
        MAP_ENUM( GL_LUMINANCE32F_ARB ),
        MAP_ENUM( GL_LUMINANCE_ALPHA32F_ARB ),
        MAP_ENUM( GL_RGBA16F_ARB ),
        MAP_ENUM( GL_RGB16F_ARB ),
        MAP_ENUM( GL_ALPHA16F_ARB ),
        MAP_ENUM( GL_LUMINANCE16F_ARB ),
        MAP_ENUM( GL_LUMINANCE_ALPHA16F_ARB ),
        MAP_ENUM( GL_MAX_DRAW_BUFFERS_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER0_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER1_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER2_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER3_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER4_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER5_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER6_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER7_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER8_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER9_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER10_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER11_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER12_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER13_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER14_ATI ),
        MAP_ENUM( GL_DRAW_BUFFER15_ATI ),
        MAP_ENUM( GL_DEPTH_TEXTURE_MODE_ARB ),
        MAP_ENUM( GL_TEXTURE_COMPARE_MODE_ARB ),
        MAP_ENUM( GL_TEXTURE_COMPARE_FUNC_ARB ),
        MAP_ENUM( GL_COMPARE_R_TO_TEXTURE_ARB ),
        MAP_ENUM( GL_MAX_TEXTURE_COORDS_ARB ),
        MAP_ENUM( GL_MAX_TEXTURE_IMAGE_UNITS_ARB ),
        MAP_ENUM( GL_ARRAY_BUFFER ),
        MAP_ENUM( GL_ELEMENT_ARRAY_BUFFER ),
        MAP_ENUM( GL_READ_ONLY ),
        MAP_ENUM( GL_WRITE_ONLY ),
        MAP_ENUM( GL_READ_WRITE ),
        MAP_ENUM( GL_STREAM_DRAW ),
        MAP_ENUM( GL_STREAM_READ ),
        MAP_ENUM( GL_STREAM_COPY ),
        MAP_ENUM( GL_STATIC_DRAW ),
        MAP_ENUM( GL_STATIC_READ ),
        MAP_ENUM( GL_STATIC_COPY ),
        MAP_ENUM( GL_DYNAMIC_DRAW ),
        MAP_ENUM( GL_DYNAMIC_READ ),
        MAP_ENUM( GL_DYNAMIC_COPY ),
        MAP_ENUM( GL_PIXEL_PACK_BUFFER_ARB ),
        MAP_ENUM( GL_PIXEL_UNPACK_BUFFER_ARB ),
        MAP_ENUM( GL_PALETTE4_RGB8_OES ),
        MAP_ENUM( GL_PALETTE4_RGBA8_OES ),
        MAP_ENUM( GL_PALETTE4_R5_G6_B5_OES ),
        MAP_ENUM( GL_PALETTE4_RGBA4_OES ),
        MAP_ENUM( GL_PALETTE4_RGB5_A1_OES ),
        MAP_ENUM( GL_PALETTE8_RGB8_OES ),
        MAP_ENUM( GL_PALETTE8_RGBA8_OES ),
        MAP_ENUM( GL_PALETTE8_R5_G6_B5_OES ),
        MAP_ENUM( GL_PALETTE8_RGBA4_OES ),
        MAP_ENUM( GL_PALETTE8_RGB5_A1_OES ),
        MAP_ENUM( GL_IMPLEMENTATION_COLOR_READ_TYPE_OES ),
        MAP_ENUM( GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES ),
        MAP_ENUM( GL_FIXED_11_11_10_SCE ),
        MAP_ENUM( GL_MULTISAMPLING_NONE_SCE ),
        MAP_ENUM( GL_MULTISAMPLING_2X_DIAGONAL_CENTERED_SCE ),
        MAP_ENUM( GL_MULTISAMPLING_4X_SQUARE_CENTERED_SCE ),
        MAP_ENUM( GL_MULTISAMPLING_4X_SQUARE_ROTATED_SCE ),
        MAP_ENUM( GL_TEXTURE_TILED_GPU_SCE ),
        MAP_ENUM( GL_TEXTURE_LINEAR_GPU_SCE ),
        MAP_ENUM( GL_TEXTURE_SWIZZLED_GPU_SCE ),
        MAP_ENUM( GL_TEXTURE_LINEAR_SYSTEM_SCE ),
        MAP_ENUM( GL_TEXTURE_SWIZZLED_SYSTEM_SCE ),
        MAP_ENUM( GL_TEXTURE_REFERENCE_BUFFER_SCE ),
        MAP_ENUM( GL_COLOR_ATTACHMENT0_EXT ),
        MAP_ENUM( GL_COLOR_ATTACHMENT1_EXT ),
        MAP_ENUM( GL_COLOR_ATTACHMENT2_EXT ),
        MAP_ENUM( GL_COLOR_ATTACHMENT3_EXT ),
        MAP_ENUM( GL_DEPTH_ATTACHMENT_OES ),
        MAP_ENUM( GL_STENCIL_ATTACHMENT_OES ),
    };

static JSenumMap _jsGlErrorMap[] =
    {
        MAP_ENUM( GL_NO_ERROR ),
        MAP_ENUM( GL_INVALID_ENUM ),
        MAP_ENUM( GL_INVALID_VALUE ),
        MAP_ENUM( GL_INVALID_OPERATION ),
        MAP_ENUM( GL_STACK_OVERFLOW ),
        MAP_ENUM( GL_STACK_UNDERFLOW ),
        MAP_ENUM( GL_OUT_OF_MEMORY ),
        MAP_ENUM( GL_INVALID_FRAMEBUFFER_OPERATION_OES ),
    };

const char *_jsGetGLEnumName( GLenum e )
{
    return _JS_MAP_LOOKUP_ENUM( _jsGlEnumMap, e ) ? : "(UNKNOWN)";
}

const char *_jsGetGLErrorName( GLenum e )
{
    return _JS_MAP_LOOKUP_ENUM( _jsGlErrorMap, e ) ? : "(UNKNOWN)";
}
#endif
