/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _CELL_SYSUTIL_CROSS_CONTROLLER_H_
#define _CELL_SYSUTIL_CROSS_CONTROLLER_H_

#include <sys/types.h>

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */


/* error */
#define CELL_CROSS_CONTROLLER_ERROR_CANCEL                ( (int) 0x8002cd80 )
#define CELL_CROSS_CONTROLLER_ERROR_NETWORK               ( (int) 0x8002cd81 )

#define CELL_CROSS_CONTROLLER_ERROR_OUT_OF_MEMORY         ( (int) 0x8002cd90 )
#define CELL_CROSS_CONTROLLER_ERROR_FATAL                 ( (int) 0x8002cd91 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_PKG_FILENAME  ( (int) 0x8002cd92 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_SIG_FILENAME  ( (int) 0x8002cd93 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_ICON_FILENAME ( (int) 0x8002cd94 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_VALUE         ( (int) 0x8002cd95 )
#define CELL_CROSS_CONTROLLER_ERROR_PKG_FILE_OPEN         ( (int) 0x8002cd96 )
#define CELL_CROSS_CONTROLLER_ERROR_SIG_FILE_OPEN         ( (int) 0x8002cd97 )
#define CELL_CROSS_CONTROLLER_ERROR_ICON_FILE_OPEN        ( (int) 0x8002cd98 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_STATE         ( (int) 0x8002cd99 )
#define CELL_CROSS_CONTROLLER_ERROR_INVALID_PKG_FILE      ( (int) 0x8002cd9a )

#define CELL_CROSS_CONTROLLER_ERROR_INTERNAL              ( (int) 0x8002cda0 )

/* limit of filename in CellCrossControllerParam */
#define CELL_CROSS_CONTROLLER_MAX_FILE_NAME_LEN (255)

typedef struct {
	const char *pPackageFileName;
	const char *pSignatureFileName;
	const char *pIconFileName;
	void *option;
} CellCrossControllerParam;

/* limits of member in CellCrossControllerPackageInfo */
#define CELL_CROSS_CONTROLLER_PKG_TITLE_LEN    (52)
#define CELL_CROSS_CONTROLLER_PKG_TITLE_ID_LEN (10)  /* string like "ABCD12345" */
#define CELL_CROSS_CONTROLLER_PKG_APP_VER_LEN  (6)   /* string link "01.02" */

typedef struct {
	const char *pTitle;
	const char *pTitleId;
	const char *pAppVer;
} CellCrossControllerPackageInfo;

/* status (in CellCrossControllerCallback) */
#define CELL_CROSS_CONTROLLER_STATUS_INITIALIZED   (1)
#define CELL_CROSS_CONTROLLER_STATUS_FINALIZED     (2)

/* callback function */
typedef void (* CellCrossControllerCallback)(int32_t status, int32_t errorCode, void *option, void *userdata);

/* function */
int32_t
cellCrossControllerInitialize(const CellCrossControllerParam *pParam,
							  const CellCrossControllerPackageInfo *pPkgInfo,
							  CellCrossControllerCallback cb,
							  void *userdata);


#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*#ifndef _CELL_SYSUTIL_CROSS_CONTROLLER_H_ */
