/*   SCE CONFIDENTIAL                                       */
/*   PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*   Copyright (C) 2007 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */
#ifndef __PRX_ERROR_H__
#define __PRX_ERROR_H__

#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif							/* __cplusplus */
/*
  CELL_ERROR_FACILITY_LIBHEAP	0x001
  PRX: 0x8001_1001 - 0x8001_1fff
*/

#define CELL_PRX_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_PRX, status)

#define CELL_PRX_OK	CELL_OK

/* ERR: CELL_PRX_MAKE_ERROR(0x0001) */
#define CELL_PRX_ERROR_ERROR	CELL_ERROR_CAST(0x80011001)

/* ERR: CELL_PRX_MAKE_ERROR(0x00d1) */
#define CELL_PRX_ERROR_ILLEGAL_PERM	CELL_ERROR_CAST(0x800110d1)

/* ERR: CELL_PRX_MAKE_ERROR(0x012e) */
#define CELL_PRX_ERROR_UNKNOWN_MODULE	CELL_ERROR_CAST(0x8001112e)

/* ERR: CELL_PRX_MAKE_ERROR(0x0133) */
#define CELL_PRX_ERROR_ALREADY_STARTED	CELL_ERROR_CAST(0x80011133)

/* ERR: CELL_PRX_MAKE_ERROR(0x0134) */
#define CELL_PRX_ERROR_NOT_STARTED	CELL_ERROR_CAST(0x80011134)

/* ERR: CELL_PRX_MAKE_ERROR(0x0135) */
#define CELL_PRX_ERROR_ALREADY_STOPPED	CELL_ERROR_CAST(0x80011135)

/* ERR: CELL_PRX_MAKE_ERROR(0x0136) */
#define CELL_PRX_ERROR_CAN_NOT_STOP	CELL_ERROR_CAST(0x80011136)

/* ERR: CELL_PRX_MAKE_ERROR(0x0138) */
#define CELL_PRX_ERROR_NOT_REMOVABLE	CELL_ERROR_CAST(0x80011138)

/* ERR: CELL_PRX_MAKE_ERROR(0x013a) */
#define CELL_PRX_ERROR_LIBRARY_NOT_YET_LINKED	CELL_ERROR_CAST(0x8001113a)

/* ERR: CELL_PRX_MAKE_ERROR(0x013b) */
#define CELL_PRX_ERROR_LIBRARY_FOUND	CELL_ERROR_CAST(0x8001113b)

/* ERR: CELL_PRX_MAKE_ERROR(0x013c) */
#define CELL_PRX_ERROR_LIBRARY_NOTFOUND	CELL_ERROR_CAST(0x8001113c)

/* ERR: CELL_PRX_MAKE_ERROR(0x013d) */
#define CELL_PRX_ERROR_ILLEGAL_LIBRARY	CELL_ERROR_CAST(0x8001113d)

/* ERR: CELL_PRX_MAKE_ERROR(0x013e) */
#define CELL_PRX_ERROR_LIBRARY_INUSE	CELL_ERROR_CAST(0x8001113e)

/* ERR: CELL_PRX_MAKE_ERROR(0x013f) */
#define CELL_PRX_ERROR_ALREADY_STOPPING	CELL_ERROR_CAST(0x8001113f)

/* ERR: CELL_PRX_MAKE_ERROR(0x0148) */
#define CELL_PRX_ERROR_UNSUPPORTED_PRX_TYPE	CELL_ERROR_CAST(0x80011148)

/* ERR: CELL_PRX_MAKE_ERROR(0x0324) */
#define CELL_PRX_ERROR_INVAL	CELL_ERROR_CAST(0x80011324)

/* ERR: CELL_PRX_MAKE_ERROR(0x0801) */
#define CELL_PRX_ERROR_ILLEGAL_PROCESS	CELL_ERROR_CAST(0x80011801)

/* ERR: CELL_PRX_MAKE_ERROR(0x0881) */
#define CELL_PRX_ERROR_NO_LIBLV2	CELL_ERROR_CAST(0x80011881)

/* ERR: CELL_PRX_MAKE_ERROR(0x0901) */
#define CELL_PRX_ERROR_UNSUPPORTED_ELF_TYPE	CELL_ERROR_CAST(0x80011901)

/* ERR: CELL_PRX_MAKE_ERROR(0x0902) */
#define CELL_PRX_ERROR_UNSUPPORTED_ELF_CLASS	CELL_ERROR_CAST(0x80011902)

/* ERR: CELL_PRX_MAKE_ERROR(0x0904) */
#define CELL_PRX_ERROR_UNDEFINED_SYMBOL	CELL_ERROR_CAST(0x80011904)

/* ERR: CELL_PRX_MAKE_ERROR(0x0905) */
#define CELL_PRX_ERROR_UNSUPPORTED_RELOCATION_TYPE	CELL_ERROR_CAST(0x80011905)

/* ERR: CELL_PRX_MAKE_ERROR(0x0910) */
#define CELL_PRX_ERROR_ELF_IS_REGISTERED	CELL_ERROR_CAST(0x80011910)

/* ERR: CELL_PRX_MAKE_ERROR(0x0911) */
#define CELL_PRX_ERROR_NO_EXIT_ENTRY	CELL_ERROR_CAST(0x80011911)

#ifdef __cplusplus
}
#endif							/* __cplusplus */
#endif							/* __CELL_PRX_ERROR_H__ */
