/*   SCE CONFIDENTIAL                                       */
/*   PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*   Copyright (C) 2010 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */


#ifndef LV2_CRASHDUMP_INCLUDED
#define LV2_CRASHDUMP_INCLUDED


#include <sys/system_types.h>

/*
 * This file is exported to public as sys/crashdump.h
 */

#ifdef __cplusplus
#define CDECL extern "C"
#else // __cplusplus
#define CDECL extern
#endif // __cplusplus


#define SYS_CRASH_DUMP_MAX_LABEL_SIZE (16)

/* To avoid duplicate declarations of SYS_PROCESS_CRASH_DUMP_ENABLED */
extern void ___sys_process_crash_dump_param_def_guard(void);

/* The crashdump enable macro */
#define SYS_PROCESS_CRASH_DUMP_ENABLED( flags1, flags2 )		\
	void ___sys_process_crash_dump_param_def_guard(void) {		\
		__asm__ __volatile("\t.weak __sys_process_crash_dump_param\n"	\
				   "__sys_process_crash_dump_param:\n"		\
				   "\t.long 0x00000020\n"  /* size     */	\
				   "\t.long 0x64756d70\n"  /* magic    */	\
				   "\t.long 0x00000001\n"  /* version  */	\
				   "\t.long 0x00000000\n"  /* reserved */	\
				   "\t.quad " #flags1 "\n" /* flags1   */	\
				   "\t.quad " #flags2 "\n" /* flags2   */);	\
		return;								\
	}


/*
 * This structure represents information about one user log area which can be
 * included in the Crash Dump File (Game). User log area set/get functions use
 * this structure as their argument type. The area specified by the address and
 * the size in this struct is recorded to the Crash Dump File as user log
 * information. The addresses that can be specified are limited to within the
 * range within the process address space that can be accessed by the PPU
 * program.
 */
typedef struct {
  char label[SYS_CRASH_DUMP_MAX_LABEL_SIZE];/* label of a user log area */
  sys_addr_t addr;                          /* address of a user log area */
  size_t size;                              /* size of a user log area */
} sys_crash_dump_log_area_info_t;


CDECL int sys_crash_dump_set_user_log_area(
  uint8_t index,
  sys_crash_dump_log_area_info_t* new_entry);

CDECL int sys_crash_dump_get_user_log_area(
  uint8_t index,
  sys_crash_dump_log_area_info_t* entry);

#endif
/*@}*/
