/*  SCE CONFIDENTIAL                                      */
/*  PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*  Copyright (C) 2012 Sony Computer Entertainment Inc.   */
/*  All Rights Reserved.                                  */
#ifndef _SCE_NP_SNS_H_
#define _SCE_NP_SNS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* constants */
#define SCE_NP_SNS_FB_INVALID_HANDLE     (0)
#define SCE_NP_SNS_FB_HANDLE_SLOT_MAX    (4)

#define SCE_NP_SNS_FB_ACCESS_TOKEN_PARAM_OPTIONS_SILENT (0x00000001)

#define SCE_NP_SNS_FB_PERMISSIONS_LENGTH_MAX  (255)
#define SCE_NP_SNS_FB_LONG_ACCESS_TOKEN_LENGTH_MAX (4096)

/* data */
typedef struct SceNpSnsFbInitParams
{
	void *pool;
	size_t poolSize;
} SceNpSnsFbInitParams;

typedef uint32_t SceNpSnsFbHandle;

typedef struct SceNpSnsFbAccessTokenParam
{
	uint64_t fb_app_id;
	char permissions[SCE_NP_SNS_FB_PERMISSIONS_LENGTH_MAX+1];
	uint32_t options;
} SceNpSnsFbAccessTokenParam;

typedef struct SceNpSnsFbLongAccessTokenResult
{
	uint64_t expiration;
	char access_token[SCE_NP_SNS_FB_LONG_ACCESS_TOKEN_LENGTH_MAX+1];
} SceNpSnsFbLongAccessTokenResult;

/* functions */

int sceNpSnsFbInit(const SceNpSnsFbInitParams *params);
int sceNpSnsFbTerm(void);

int sceNpSnsFbCreateHandle(SceNpSnsFbHandle *handle);
int sceNpSnsFbDestroyHandle(SceNpSnsFbHandle handle);
int sceNpSnsFbAbortHandle(SceNpSnsFbHandle handle);

int sceNpSnsFbGetLongAccessToken(SceNpSnsFbHandle handle,
            const SceNpSnsFbAccessTokenParam *param,
            SceNpSnsFbLongAccessTokenResult *result);

#ifdef __cplusplus
}
#endif

#endif /* _SCE_NP_SNS_H_ */
