/*  SCE CONFIDENTIAL									  */
/*  PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*  Copyright (C) 2014 Sony Computer Entertainment Inc.   */
/*  All Rights Reserved.								  */
#ifndef __SCE_NP_ERROR_H__
#define __SCE_NP_ERROR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* NP Authentication Error (client runtime errors) */
#define SCE_NP_AUTH_EINVAL											0x8002a002
#define SCE_NP_AUTH_ENOMEM											0x8002a004
#define SCE_NP_AUTH_ESRCH											0x8002a005
#define SCE_NP_AUTH_EBUSY											0x8002a00a
#define SCE_NP_AUTH_EABORT											0x8002a00c
#define SCE_NP_AUTH_EEXIST											0x8002a014
#define SCE_NP_AUTH_EINVALID_ARGUMENT								0x8002a015

/* community client library error (0x8002a100 - 0x8002a1ff)*/
/* library has already been initialized */
#define SCE_NP_COMMUNITY_ERROR_ALREADY_INITIALIZED					0x8002a101
/* the library has not yet been initialized */
#define SCE_NP_COMMUNITY_ERROR_NOT_INITIALIZED						0x8002a102
/* tried to malloc, but got NULL (no memory) */
#define SCE_NP_COMMUNITY_ERROR_OUT_OF_MEMORY						0x8002a103
/*J 指定した引数の値がNULL(必須の引数がNULLで指定された) */
#define SCE_NP_COMMUNITY_ERROR_INVALID_ARGUMENT						0x8002a104
/*J TitleIDが設定されていない. (URLの情報が足りない) */
#define SCE_NP_COMMUNITY_ERROR_NO_TITLE_SET							0x8002a105
/*J クライアントはlogin transactionを実行していない. */
#define SCE_NP_COMMUNITY_ERROR_NO_LOGIN								0x8002a106
/*J 作成されるオブジェクトが多すぎる. */
#define SCE_NP_COMMUNITY_ERROR_TOO_MANY_OBJECTS						0x8002a107
/*J トランザクションの最中に、クライアントまたはトランザクションを削除しようとした.(obsolete) */
#define SCE_NP_COMMUNITY_ERROR_TRANSACTION_STILL_REFERENCED			0x8002a108
/*J トランザクションはアボートされた */
#define SCE_NP_COMMUNITY_ERROR_ABORTED								0x8002a109
/*J 指定したリソースは一つも存在しない. */
#define SCE_NP_COMMUNITY_ERROR_NO_RESOURCE							0x8002a10a
/*J サーバからのレスポンスが不正 */
#define SCE_NP_COMMUNITY_ERROR_BAD_RESPONSE							0x8002a10b
/*J サーバからのレスポンスボディのサイズが大きすぎる. */
#define SCE_NP_COMMUNITY_ERROR_BODY_TOO_LARGE						0x8002a10c
/*J HTTPプロトコルレイヤでサーバと通信失敗. (403や404などが返ってきている) */
#define SCE_NP_COMMUNITY_ERROR_HTTP_SERVER							0x8002a10d
/*J サーバレスポンスの署名が不正 */
#define SCE_NP_COMMUNITY_ERROR_INVALID_SIGNATURE					0x8002a10e
/*J タイムアウトした(libhttpレイヤのタイムアウトも返ることに注意) */
#define SCE_NP_COMMUNITY_ERROR_TIMEOUT								0x8002a10f
/*J 指定したトランザクションを作成するための引数が足りない. */
#define SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_ARGUMENT				0x8002a1a1
/*J 指定したTypeは存在しない. */
#define SCE_NP_COMMUNITY_ERROR_UNKNOWN_TYPE							0x8002a1a2
/*J 指定したIDは存在しない. */
#define SCE_NP_COMMUNITY_ERROR_INVALID_ID							0x8002a1a3
/*J 指定したオンラインIDのクライアントは存在しない. */
#define SCE_NP_COMMUNITY_ERROR_INVALID_ONLINE_ID					0x8002a1a4
/*J 指定したチケットのサイズが0 */
#define SCE_NP_COMMUNITY_ERROR_INVALID_TICKET						0x8002a1a5
/*J 指定したオンラインIDで既にクライアントは作成されている. */
#define SCE_NP_COMMUNITY_ERROR_CLIENT_ALREADY_EXISTS				0x8002a1a6
#define SCE_NP_COMMUNITY_ERROR_CLIENT_HANDLE_ALREADY_EXISTS			0x8002a1a6
/*J 指定した引数のバッファのサイズが足りない. */
#define SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_BUFFER					0x8002a1a7
/*J 指定したトランザクションタイプが不正. */
#define SCE_NP_COMMUNITY_ERROR_INVALID_TYPE							0x8002a1a8
/*J 指定したトランザクションは既に完了している */
#define SCE_NP_COMMUNITY_ERROR_TRANSACTION_ALREADY_END				0x8002a1a9
/*J 指定したトランザクションは完了していない */
#define SCE_NP_COMMUNITY_ERROR_TRANSACTION_BEFORE_END				0x8002a1aa
/*J 別のトランザクションは行えない */
#define SCE_NP_COMMUNITY_ERROR_BUSY_BY_ANOTEHR_TRANSACTION			0x8002a1ab
/*J 構造体のサイズが不正 */
#define SCE_NP_COMMUNITY_ERROR_INVALID_ALIGNMENT					0x8002a1ac
/*J 指定されたNPIDの数が多すぎる */
#define SCE_NP_COMMUNITY_ERROR_TOO_MANY_NPID						0x8002a1ad
/*J 指定されたRANGEが長すぎる */
#define SCE_NP_COMMUNITY_ERROR_TOO_LARGE_RANGE						0x8002a1ae
/*J 指定されたuploaderの使用領域が不正 */
#define SCE_NP_COMMUNITY_ERROR_INVALID_PARTITION					0x8002a1af
/*J 指定されたSLOTIDの数が多すぎる */
#define SCE_NP_COMMUNITY_ERROR_TOO_MANY_SLOTID						0x8002a1b1
/* obsolete (replaced by SCE_NP_COMMUNITY_ERROR_INVALID_ONLINE_ID) */
#define SCE_NP_COMMUNITY_ERROR_INVALID_PSHANDLE						0x8002a1a4


/* NP Authentication Error (server returned errors) */
#define SCE_NP_AUTH_ERROR_SERVICE_END								0x8002a200
#define SCE_NP_AUTH_ERROR_SERVICE_DOWN								0x8002a201
#define SCE_NP_AUTH_ERROR_SERVICE_BUSY								0x8002a202
#define SCE_NP_AUTH_ERROR_SERVER_MAINTENANCE						0x8002a203
#define SCE_NP_AUTH_ERROR_INVALID_DATA_LENGTH						0x8002a210
#define SCE_NP_AUTH_ERROR_INVALID_USER_AGENT						0x8002a211
#define SCE_NP_AUTH_ERROR_INVALID_VERSION							0x8002a212
#define SCE_NP_AUTH_ERROR_INVALID_SERVICE_ID						0x8002a220
#define SCE_NP_AUTH_ERROR_INVALID_CREDENTIAL						0x8002a221
#define SCE_NP_AUTH_ERROR_INVALID_ENTITLEMENT_ID					0x8002a222
#define SCE_NP_AUTH_ERROR_INVALID_CONSUMED_COUNT					0x8002a223
#define SCE_NP_AUTH_ERROR_INVALID_CONSOLE_ID						0x8002a224
#define SCE_NP_AUTH_ERROR_CONSOLE_ID_SUSPENDED						0x8002a227
#define SCE_NP_AUTH_ERROR_ACCOUNT_CLOSED							0x8002a230
#define SCE_NP_AUTH_ERROR_ACCOUNT_SUSPENDED							0x8002a231
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_EULA						0x8002a232
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT1					0x8002a240
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT2					0x8002a241
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT3					0x8002a242
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT4					0x8002a243
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT5					0x8002a244
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT6					0x8002a245
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT7					0x8002a246
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT8					0x8002a247
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT9					0x8002a248
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT10					0x8002a249
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT11					0x8002a24a
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT12					0x8002a24b
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT13					0x8002a24c
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT14					0x8002a24d
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT15					0x8002a24e
#define SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT16					0x8002a24f
#define SCE_NP_AUTH_ERROR_SUB_ACCOUNT_RENEW_EULA					0x8002a24f
#define SCE_NP_AUTH_ERROR_UNKNOWN									0x8002a280

/* NP Core Server Error */
#define SCE_NP_CORE_SERVER_ERROR_CONFLICT							0x8002a303
#define SCE_NP_CORE_SERVER_ERROR_NOT_AUTHORIZED						0x8002a30d
#define SCE_NP_CORE_SERVER_ERROR_REMOTE_CONNECTION_FAILED			0x8002a30f
#define SCE_NP_CORE_SERVER_ERROR_RESOURCE_CONSTRAINT				0x8002a310
#define SCE_NP_CORE_SERVER_ERROR_SYSTEM_SHUTDOWN					0x8002a313
#define SCE_NP_CORE_SERVER_ERROR_UNSUPPORTED_CLIENT_VERSION			0x8002a319

/* community server error (0x8002a400 - 0x8002a4ff) */
#define SCE_NP_COMMUNITY_SERVER_ERROR_BAD_REQUEST					0x8002a401
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_TICKET				0x8002a402
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SIGNATURE				0x8002a403
#define SCE_NP_COMMUNITY_SERVER_ERROR_EXPIRED_TICKET				0x8002a404
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_NPID					0x8002a405
#define SCE_NP_COMMUNITY_SERVER_ERROR_FORBIDDEN						0x8002a406
#define SCE_NP_COMMUNITY_SERVER_ERROR_INTERNAL_SERVER_ERROR			0x8002a407
#define SCE_NP_COMMUNITY_SERVER_ERROR_VERSION_NOT_SUPPORTED			0x8002a408
#define SCE_NP_COMMUNITY_SERVER_ERROR_SERVICE_UNAVAILABLE			0x8002a409
#define SCE_NP_COMMUNITY_SERVER_ERROR_PLAYER_BANNED					0x8002a40a
#define SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED						0x8002a40b
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_RECORD_FORBIDDEN		0x8002a40c
#define SCE_NP_COMMUNITY_SERVER_ERROR_USER_PROFILE_NOT_FOUND		0x8002a40d
#define SCE_NP_COMMUNITY_SERVER_ERROR_UPLOADER_DATA_NOT_FOUND		0x8002a40e
#define SCE_NP_COMMUNITY_SERVER_ERROR_QUOTA_MASTER_NOT_FOUND		0x8002a40f
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_TITLE_NOT_FOUND		0x8002a410
#define SCE_NP_COMMUNITY_SERVER_ERROR_BLACKLISTED_USER_ID			0x8002a411
#define SCE_NP_COMMUNITY_SERVER_ERROR_GAME_RANKING_NOT_FOUND		0x8002a412
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_STORE_NOT_FOUND		0x8002a414
#define SCE_NP_COMMUNITY_SERVER_ERROR_NOT_BEST_SCORE				0x8002a415
#define SCE_NP_COMMUNITY_SERVER_ERROR_LATEST_UPDATE_NOT_FOUND		0x8002a416
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BOARD_MASTER_NOT_FOUND 0x8002a417
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_GAME_DATA_MASTER_NOT_FOUND 0x8002a418
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ANTICHEAT_DATA		0x8002a419
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_DATA				0x8002a41a
#define SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_USER_NPID				0x8002a41b
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ENVIRONMENT			0x8002a41d
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_CHARACTER	0x8002a41f
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_LENGTH	0x8002a420
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_CHARACTER	0x8002a421
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_LENGTH		0x8002a422
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SCORE					0x8002a423
#define SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_RANKING_LIMIT		0x8002a424
#define SCE_NP_COMMUNITY_SERVER_ERROR_FAIL_TO_CREATE_SIGNATURE		0x8002a426
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MASTER_INFO_NOT_FOUND	0x8002a427
#define SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_GAME_DATA_LIMIT		0x8002a428
#define SCE_NP_COMMUNITY_SERVER_ERROR_SELF_DATA_NOT_FOUND			0x8002a42a
#define SCE_NP_COMMUNITY_SERVER_ERROR_USER_NOT_ASSIGNED				0x8002a42b
#define SCE_NP_COMMUNITY_SERVER_ERROR_GAME_DATA_ALREADY_EXISTS		0x8002a42c
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MANY_RESULTS				0x8002a42d
#define SCE_NP_COMMUNITY_SERVER_ERROR_NOT_RECORDABLE_VERSION		0x8002a42e
#define SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_TITLE_MASTER_NOT_FOUND	0x8002a448
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_VIRTUAL_USER			0x8002a449
#define SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_DATA_NOT_FOUND	0x8002a44a
#define SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_AVATAR_PAP			0x8002a457
#define SCE_NP_COMMUNITY_SERVER_ERROR_NON_PLUS_MEMBER				0x8002a45d
#define SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_SEQUENCE				0x8002a45e
#define SCE_NP_COMMUNITY_SERVER_ERROR_SAVEDATA_NOT_FOUND			0x8002a45f
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MANY_SAVEDATA_FILES		0x8002a460
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MUCH_TOTAL_SAVEDATA_SIZE	0x8002a461
#define SCE_NP_COMMUNITY_SERVER_ERROR_NOT_YET_DOWNLOADABLE			0x8002a462
#define SCE_NP_COMMUNITY_SERVER_ERROR_BLACKLISTED_TITLE				0x8002a468
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_ICONDATA			0x8002a469
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_SAVEDATA			0x8002a46a
#define SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_SIGNATURE				0x8002a46b
#define SCE_NP_COMMUNITY_SERVER_ERROR_UNMATCH_MD5SUM				0x8002a46c
#define SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MUCH_SAVEDATA_SIZE		0x8002a46d
#define SCE_NP_COMMUNITY_SERVER_ERROR_CONDITIONS_NOT_SATISFIED		0x8002a473
#define SCE_NP_COMMUNITY_SERVER_ERROR_UNSUPPORTED_PLATFORM			0x8002a478
#define SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_BEFORE_SERVICE		0x8002a4a0
#define SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_END_OF_SERVICE		0x8002a4a1
#define SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_MAINTENANCE			0x8002a4a2
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BEFORE_SERVICE		0x8002a4a3
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_END_OF_SERVICE		0x8002a4a4
#define SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MAINTENANCE			0x8002a4a5
#define SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_TITLE					0x8002a4a6
#define SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_BEFORE_SERVICE	0x8002a4aa
#define SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_END_OF_SERVICE	0x8002a4ab
#define SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_MAINTENANCE	0x8002a4ac
#define SCE_NP_COMMUNITY_SERVER_ERROR_FSR_BEFORE_SERVICE			0x8002a4ad
#define SCE_NP_COMMUNITY_SERVER_ERROR_FSR_END_OF_SERVICE			0x8002a4ae
#define SCE_NP_COMMUNITY_SERVER_ERROR_FSR_MAINTENANCE				0x8002a4af
#define SCE_NP_COMMUNITY_SERVER_ERROR_UBS_BEFORE_SERVICE			0x8002a4b0
#define SCE_NP_COMMUNITY_SERVER_ERROR_UBS_END_OF_SERVICE			0x8002a4b1
#define SCE_NP_COMMUNITY_SERVER_ERROR_UBS_MAINTENANCE				0x8002a4b2
#define SCE_NP_COMMUNITY_SERVER_ERROR_BASIC_BLACKLISTED_USER_ID		0x8002a4b3


/* Unspecified Error */
#define SCE_NP_COMMUNITY_SERVER_ERROR_UNSPECIFIED					0x8002a4ff


/* NP Core Error */
#define SCE_NP_CORE_UTIL_ERROR_INVALID_ARGUMENT						0x8002a501
#define SCE_NP_CORE_UTIL_ERROR_OUT_OF_MEMORY						0x8002a502
#define SCE_NP_CORE_UTIL_ERROR_INSUFFICIENT							0x8002a503
#define SCE_NP_CORE_UTIL_ERROR_PARSER_FAILED						0x8002a504
#define SCE_NP_CORE_UTIL_ERROR_INVALID_PROTOCOL_ID					0x8002a505
#define SCE_NP_CORE_UTIL_ERROR_INVALID_EXTENSION					0x8002a506
#define SCE_NP_CORE_UTIL_ERROR_INVALID_TEXT							0x8002a507
#define SCE_NP_CORE_UTIL_ERROR_UNKNOWN_TYPE							0x8002a508
#define SCE_NP_CORE_UTIL_ERROR_UNKNOWN								0x8002a509

#define SCE_NP_CORE_PARSER_ERROR_NOT_INITIALIZED					0x8002a511
#define SCE_NP_CORE_PARSER_ERROR_ALREADY_INITIALIZED				0x8002a512
#define SCE_NP_CORE_PARSER_ERROR_OUT_OF_MEMORY						0x8002a513
#define SCE_NP_CORE_PARSER_ERROR_INSUFFICIENT						0x8002a514
#define SCE_NP_CORE_PARSER_ERROR_INVALID_FORMAT						0x8002a515
#define SCE_NP_CORE_PARSER_ERROR_INVALID_ARGUMENT					0x8002a516
#define SCE_NP_CORE_PARSER_ERROR_INVALID_HANDLE						0x8002a517
#define SCE_NP_CORE_PARSER_ERROR_INVALID_ICON						0x8002a518
#define SCE_NP_CORE_PARSER_ERROR_UNKNOWN							0x8002a519

#define SCE_NP_CORE_ERROR_ALREADY_INITIALIZED						0x8002a521
#define SCE_NP_CORE_ERROR_NOT_INITIALIZED							0x8002a522
#define SCE_NP_CORE_ERROR_INVALID_ARGUMENT							0x8002a523
#define SCE_NP_CORE_ERROR_OUT_OF_MEMORY								0x8002a524
#define SCE_NP_CORE_ERROR_ID_NOT_AVAILABLE							0x8002a525
#define SCE_NP_CORE_ERROR_USER_OFFLINE								0x8002a526
#define SCE_NP_CORE_ERROR_SESSION_RUNNING							0x8002a527
#define SCE_NP_CORE_ERROR_SESSION_NOT_ESTABLISHED					0x8002a528
#define SCE_NP_CORE_ERROR_SESSION_INVALID_STATE						0x8002a529
#define SCE_NP_CORE_ERROR_SESSION_ID_TOO_LONG						0x8002a52a
#define SCE_NP_CORE_ERROR_SESSION_INVALID_NAMESPACE					0x8002a52b
#define SCE_NP_CORE_ERROR_CONNECTION_TIMEOUT						0x8002a52c
#define SCE_NP_CORE_ERROR_GETSOCKOPT								0x8002a52d
#define SCE_NP_CORE_ERROR_SSL_NOT_INITIALIZED						0x8002a52e
#define SCE_NP_CORE_ERROR_SSL_ALREADY_INITIALIZED					0x8002a52f
#define SCE_NP_CORE_ERROR_SSL_NO_CERT								0x8002a530
#define SCE_NP_CORE_ERROR_SSL_NO_TRUSTWORTHY_CA						0x8002a531
#define SCE_NP_CORE_ERROR_SSL_INVALID_CERT							0x8002a532
#define SCE_NP_CORE_ERROR_SSL_CERT_VERIFY							0x8002a533
#define SCE_NP_CORE_ERROR_SSL_CN_CHECK								0x8002a534
#define SCE_NP_CORE_ERROR_SSL_HANDSHAKE_FAILED						0x8002a535
#define SCE_NP_CORE_ERROR_SSL_SEND									0x8002a536
#define SCE_NP_CORE_ERROR_SSL_RECV									0x8002a537
#define SCE_NP_CORE_ERROR_SSL_CREATE_CTX							0x8002a538
#define SCE_NP_CORE_ERROR_PARSE_PEM									0x8002a539
#define SCE_NP_CORE_ERROR_INVALID_INITIATE_STREAM					0x8002a53a
#define SCE_NP_CORE_ERROR_SASL_NOT_SUPPORTED						0x8002a53b
#define SCE_NP_CORE_ERROR_NAMESPACE_ALREADY_EXISTS					0x8002a53c
#define SCE_NP_CORE_ERROR_FROM_ALREADY_EXISTS						0x8002a53d
#define SCE_NP_CORE_ERROR_MODULE_NOT_REGISTERED						0x8002a53e
#define SCE_NP_CORE_ERROR_MODULE_FROM_NOT_FOUND						0x8002a53f
#define SCE_NP_CORE_ERROR_UNKNOWN_NAMESPACE							0x8002a540
#define SCE_NP_CORE_ERROR_INVALID_VERSION							0x8002a541
#define SCE_NP_CORE_ERROR_LOGIN_TIMEOUT								0x8002a542
#define SCE_NP_CORE_ERROR_TOO_MANY_SESSIONS							0x8002a543
#define SCE_NP_CORE_ERROR_SENDLIST_NOT_FOUND						0x8002a544
#define SCE_NP_CORE_ERROR_NO_ID										0x8002a545
#define SCE_NP_CORE_ERROR_LOAD_CERTS								0x8002a546
#define SCE_NP_CORE_ERROR_NET_SELECT								0x8002a547
#define SCE_NP_CORE_ERROR_DISCONNECTED								0x8002a548
#define SCE_NP_CORE_ERROR_TICKET_TOO_SMALL							0x8002a549
#define SCE_NP_CORE_ERROR_INVALID_TICKET							0x8002a54a
#define SCE_NP_CORE_ERROR_INVALID_ONLINEID							0x8002a54b
#define SCE_NP_CORE_ERROR_GETHOSTBYNAME								0x8002a54c
#define SCE_NP_CORE_ERROR_UNDEFINED_STREAM_ERROR					0x8002a54d
#define SCE_NP_CORE_ERROR_INTERNAL									0x8002a5ff

#define SCE_NP_CORE_NET_ERROR_EPERM									0x8002ad01
#define SCE_NP_CORE_NET_ERROR_ENOENT								0x8002ad02
#define SCE_NP_CORE_NET_ERROR_ESRCH									0x8002ad03
#define SCE_NP_CORE_NET_ERROR_EINTR									0x8002ad04
#define SCE_NP_CORE_NET_ERROR_EIO									0x8002ad05
#define SCE_NP_CORE_NET_ERROR_ENXIO									0x8002ad06
#define SCE_NP_CORE_NET_ERROR_E2BIG									0x8002ad07
#define SCE_NP_CORE_NET_ERROR_ENOEXC								0x8002ad08
#define SCE_NP_CORE_NET_ERROR_EBADF									0x8002ad09
#define SCE_NP_CORE_NET_ERROR_ECHILD								0x8002ad0a
#define SCE_NP_CORE_NET_ERROR_EDEADLK								0x8002ad0b
#define SCE_NP_CORE_NET_ERROR_ENOMEM								0x8002ad0c
#define SCE_NP_CORE_NET_ERROR_EACCES								0x8002ad0d
#define SCE_NP_CORE_NET_ERROR_EFAULT								0x8002ad0e
#define SCE_NP_CORE_NET_ERROR_ENOTBLK								0x8002ad0f
#define SCE_NP_CORE_NET_ERROR_EBUSY									0x8002ad10
#define SCE_NP_CORE_NET_ERROR_EEXIST								0x8002ad11
#define SCE_NP_CORE_NET_ERROR_EXDEV									0x8002ad12
#define SCE_NP_CORE_NET_ERROR_ENODEV								0x8002ad13
#define SCE_NP_CORE_NET_ERROR_ENOTDIR								0x8002ad14
#define SCE_NP_CORE_NET_ERROR_EISDIR								0x8002ad15
#define SCE_NP_CORE_NET_ERROR_EINVAL								0x8002ad16
#define SCE_NP_CORE_NET_ERROR_ENFILE								0x8002ad17
#define SCE_NP_CORE_NET_ERROR_EMFILE								0x8002ad18
#define SCE_NP_CORE_NET_ERROR_ENOTTY								0x8002ad19
#define SCE_NP_CORE_NET_ERROR_ETXTBSY								0x8002ad1a
#define SCE_NP_CORE_NET_ERROR_EFBIG									0x8002ad1b
#define SCE_NP_CORE_NET_ERROR_ENOSPC								0x8002ad1c
#define SCE_NP_CORE_NET_ERROR_ESPIPE								0x8002ad1d
#define SCE_NP_CORE_NET_ERROR_EROFS									0x8002ad1e
#define SCE_NP_CORE_NET_ERROR_EMLINK								0x8002ad1f
#define SCE_NP_CORE_NET_ERROR_EPIPE									0x8002ad20
#define SCE_NP_CORE_NET_ERROR_EDOM									0x8002ad21
#define SCE_NP_CORE_NET_ERROR_ERANGE								0x8002ad22
#define SCE_NP_CORE_NET_ERROR_EAGAIN								0x8002ad23
#define SCE_NP_CORE_NET_ERROR_EINPROGRESS							0x8002ad24
#define SCE_NP_CORE_NET_ERROR_EALREADY								0x8002ad25
#define SCE_NP_CORE_NET_ERROR_ENOTSOCK								0x8002ad26
#define SCE_NP_CORE_NET_ERROR_EDESTADDRREQ							0x8002ad27
#define SCE_NP_CORE_NET_ERROR_EMSGSIZE								0x8002ad28
#define SCE_NP_CORE_NET_ERROR_EPROTOTYPE							0x8002ad29
#define SCE_NP_CORE_NET_ERROR_ENOPROTOOPT							0x8002ad2a
#define SCE_NP_CORE_NET_ERROR_EPROTONOSUPPORT						0x8002ad2b
#define SCE_NP_CORE_NET_ERROR_ESOCKTNOSUPPORT						0x8002ad2c
#define SCE_NP_CORE_NET_ERROR_EOPNOTSUPP							0x8002ad2d
#define SCE_NP_CORE_NET_ERROR_EPFNOSUPPORT							0x8002ad2e
#define SCE_NP_CORE_NET_ERROR_EAFNOSUPPORT							0x8002ad2f
#define SCE_NP_CORE_NET_ERROR_EADDRINUSE							0x8002ad30
#define SCE_NP_CORE_NET_ERROR_EADDRNOTAVAIL							0x8002ad31
#define SCE_NP_CORE_NET_ERROR_ENETDOWN								0x8002ad32
#define SCE_NP_CORE_NET_ERROR_ENETUNREACH							0x8002ad33
#define SCE_NP_CORE_NET_ERROR_ENETRESET								0x8002ad34
#define SCE_NP_CORE_NET_ERROR_ECONNABORTED							0x8002ad35
#define SCE_NP_CORE_NET_ERROR_ECONNRESET							0x8002ad36
#define SCE_NP_CORE_NET_ERROR_ENOBUFS								0x8002ad37
#define SCE_NP_CORE_NET_ERROR_EISCONN								0x8002ad38
#define SCE_NP_CORE_NET_ERROR_ENOTCONN								0x8002ad39
#define SCE_NP_CORE_NET_ERROR_ESHUTDOWN								0x8002ad3a
#define SCE_NP_CORE_NET_ERROR_ETOOMANYREFS							0x8002ad3b
#define SCE_NP_CORE_NET_ERROR_ETIMEDOUT								0x8002ad3c
#define SCE_NP_CORE_NET_ERROR_ECONNREFUSED							0x8002ad3d
#define SCE_NP_CORE_NET_ERROR_ELOOP									0x8002ad3e
#define SCE_NP_CORE_NET_ERROR_ENAMETOOLONG							0x8002ad3f
#define SCE_NP_CORE_NET_ERROR_EHOSTDOWN								0x8002ad40
#define SCE_NP_CORE_NET_ERROR_EHOSTUNREACH							0x8002ad41
#define SCE_NP_CORE_NET_ERROR_ENOTEMPTY								0x8002ad42
#define SCE_NP_CORE_NET_ERROR_EPROCLIM								0x8002ad43
#define SCE_NP_CORE_NET_ERROR_EUSERS								0x8002ad44
#define SCE_NP_CORE_NET_ERROR_EDQUOT								0x8002ad45
#define SCE_NP_CORE_NET_ERROR_ESTALE								0x8002ad46
#define SCE_NP_CORE_NET_ERROR_EREMOTE								0x8002ad47
#define SCE_NP_CORE_NET_ERROR_EBADRPC								0x8002ad48
#define SCE_NP_CORE_NET_ERROR_ERPCMISMATCH							0x8002ad49
#define SCE_NP_CORE_NET_ERROR_EPROGUNAVAIL							0x8002ad4a
#define SCE_NP_CORE_NET_ERROR_EPROGMISMATCH							0x8002ad4b
#define SCE_NP_CORE_NET_ERROR_EPROCUNAVAIL							0x8002ad4c
#define SCE_NP_CORE_NET_ERROR_ENOLCK								0x8002ad4d
#define SCE_NP_CORE_NET_ERROR_ENOSYS								0x8002ad4e
#define SCE_NP_CORE_NET_ERROR_EFTYPE								0x8002ad4f
#define SCE_NP_CORE_NET_ERROR_EAUTH									0x8002ad50
#define SCE_NP_CORE_NET_ERROR_ENEEDAUTH								0x8002ad51
#define SCE_NP_CORE_NET_ERROR_EIDRM									0x8002ad52
#define SCE_NP_CORE_NET_ERROR_ENOMSG								0x8002ad53
#define SCE_NP_CORE_NET_ERROR_EOVERFLOW								0x8002ad54
#define SCE_NP_CORE_NET_ERROR_EILSEQ								0x8002ad55
#define SCE_NP_CORE_NET_ERROR_ENOTSUP								0x8002ad56
#define SCE_NP_CORE_NET_ERROR_ECANCELED								0x8002ad57
#define SCE_NP_CORE_NET_ERROR_EBADMSG								0x8002ad58
#define SCE_NP_CORE_NET_ERROR_ENODATA								0x8002ad59
#define SCE_NP_CORE_NET_ERROR_ENOSR									0x8002ad5a
#define SCE_NP_CORE_NET_ERROR_ENOSTR								0x8002ad5b
#define SCE_NP_CORE_NET_ERROR_ETIME									0x8002ad5c


/* NP Core DNS Error */
#define SCE_NP_CORE_ERROR_DNS_HOST_NOT_FOUND						0x8002af01
#define SCE_NP_CORE_ERROR_DNS_TRY_AGAIN								0x8002af02
#define SCE_NP_CORE_ERROR_DNS_NO_RECOVERY							0x8002af03
#define SCE_NP_CORE_ERROR_DNS_NO_DATA								0x8002af04
#define SCE_NP_CORE_ERROR_DNS_NO_ADDRESS							0x8002afff



/* NP Basic Error */
#define SCE_NP_BASIC_ERROR_ALREADY_INITIALIZED						0x8002a661
#define SCE_NP_BASIC_ERROR_NOT_INITIALIZED							0x8002a662
#define SCE_NP_BASIC_ERROR_NOT_SUPPORTED							0x8002a663
#define SCE_NP_BASIC_ERROR_OUT_OF_MEMORY							0x8002a664
#define SCE_NP_BASIC_ERROR_INVALID_ARGUMENT							0x8002a665
#define SCE_NP_BASIC_ERROR_BAD_ID									0x8002a666
#define SCE_NP_BASIC_ERROR_IDS_DIFFER								0x8002a667
#define SCE_NP_BASIC_ERROR_PARSER_FAILED							0x8002a668
#define SCE_NP_BASIC_ERROR_TIMEOUT									0x8002a669
#define SCE_NP_BASIC_ERROR_NO_EVENT									0x8002a66a
#define SCE_NP_BASIC_ERROR_EXCEEDS_MAX								0x8002a66b
#define SCE_NP_BASIC_ERROR_INSUFFICIENT								0x8002a66c
#define SCE_NP_BASIC_ERROR_NOT_REGISTERED							0x8002a66d
#define SCE_NP_BASIC_ERROR_DATA_LOST								0x8002a66e
#define SCE_NP_BASIC_ERROR_BUSY										0x8002a66f
#define SCE_NP_BASIC_ERROR_STATUS									0x8002a670
#define SCE_NP_BASIC_ERROR_CANCEL									0x8002a671
#define SCE_NP_BASIC_ERROR_INVALID_MEMORY_CONTAINER					0x8002a672
#define SCE_NP_BASIC_ERROR_INVALID_DATA_ID							0x8002a673
#define SCE_NP_BASIC_ERROR_BROKEN_DATA								0x8002a674
#define SCE_NP_BASIC_ERROR_BLOCKLIST_ADD_FAILED						0x8002a675
#define SCE_NP_BASIC_ERROR_BLOCKLIST_IS_FULL						0x8002a676
#define SCE_NP_BASIC_ERROR_SEND_FAILED								0x8002a677
#define SCE_NP_BASIC_ERROR_NOT_CONNECTED							0x8002a678
#define SCE_NP_BASIC_ERROR_INSUFFICIENT_DISK_SPACE					0x8002a679
#define SCE_NP_BASIC_ERROR_INTERNAL_FAILURE							0x8002a67a
#define SCE_NP_BASIC_ERROR_DOES_NOT_EXIST							0x8002a67b
#define SCE_NP_BASIC_ERROR_INVALID									0x8002a67c
#define SCE_NP_BASIC_ERROR_ABORT									0x8002a67d
#define SCE_NP_BASIC_ERROR_UNKNOWN									0x8002a6bf

#define SCE_NP_EXT_ERROR_CONTEXT_DOES_NOT_EXIST						0x8002a6a1
#define SCE_NP_EXT_ERROR_CONTEXT_ALREADY_EXISTS						0x8002a6a2
#define SCE_NP_EXT_ERROR_NO_CONTEXT									0x8002a6a3
#define SCE_NP_EXT_ERROR_NO_ORIGIN									0x8002a6a4

/* NP Matching Error */
#define SCE_NP_MATCHING_ERROR_NOT_INITIALIZED						0x8002a701
#define SCE_NP_MATCHING_ERROR_ALREADY_INITIALIZED					0x8002a702
#define SCE_NP_MATCHING_ERROR_INVALID_ARG							0x8002a703
#define SCE_NP_MATCHING_ERROR_TERMINATED							0x8002a704
#define SCE_NP_MATCHING_ERROR_TIMEOUT								0x8002a705
#define SCE_NP_MATCHING_ERROR_OUT_OF_MEMORY							0x8002a706
#define SCE_NP_MATCHING_ERROR_CTXID_NOT_AVAIL						0x8002a707
#define SCE_NP_MATCHING_ERROR_CTX_ALREADY_EXIST						0x8002a708
#define SCE_NP_MATCHING_ERROR_CTX_NOT_FOUND							0x8002a709
#define SCE_NP_MATCHING_ERROR_LOBBY_NOT_FOUND						0x8002a70a
#define SCE_NP_MATCHING_ERROR_ROOM_NOT_FOUND						0x8002a70b
#define SCE_NP_MATCHING_ERROR_MEMBER_NOT_FOUND						0x8002a70c
#define SCE_NP_MATCHING_ERROR_TOO_BIG_VALUE							0x8002a70d
#define SCE_NP_MATCHING_ERROR_INVALID_ATTR_TYPE						0x8002a70e
#define SCE_NP_MATCHING_ERROR_INVALID_ATTR_ID						0x8002a70f
#define SCE_NP_MATCHING_ERROR_ALREADY_REQUESTED						0x8002a710
#define SCE_NP_MATCHING_ERROR_LIMITTED_SEATING						0x8002a711
#define SCE_NP_MATCHING_ERROR_LOCKED								0x8002a712
#define SCE_NP_MATCHING_ERROR_CTX_STILL_RUNNING						0x8002a713
#define SCE_NP_MATCHING_ERROR_INSUFFICIENT_BUFFER					0x8002a714
#define SCE_NP_MATCHING_ERROR_REQUEST_NOT_ALLOWED					0x8002a715
#define SCE_NP_MATCHING_ERROR_CTX_MAX								0x8002a716
#define SCE_NP_MATCHING_ERROR_INVALID_REQ_ID						0x8002a717
#define SCE_NP_MATCHING_ERROR_RESULT_NOT_FOUND						0x8002a718
#define SCE_NP_MATCHING_ERROR_BUSY									0x8002a719
#define SCE_NP_MATCHING_ERROR_ALREADY_JOINED_ROOM					0x8002a71a
#define SCE_NP_MATCHING_ERROR_ROOM_MAX								0x8002a71b
#define SCE_NP_MATCHING_ERROR_QUICK_MATCH_PLAYER_NOT_FOUND			0x8002a71c
#define SCE_NP_MATCHING_ERROR_COND_MAX								0x8002a71d
#define SCE_NP_MATCHING_ERROR_INVALID_COND							0x8002a71e
#define SCE_NP_MATCHING_ERROR_INVALID_ATTR							0x8002a71f
#define SCE_NP_MATCHING_ERROR_COMP_OP_INEQUALITY_MAX				0x8002a720
#define SCE_NP_MATCHING_ERROR_RESULT_OVERFLOWED						0x8002a721
#define SCE_NP_MATCHING_ERROR_HTTPXML_TIMEOUT						0x8002a722
#define SCE_NP_MATCHING_ERROR_CANCELED								0x8002a723
#define SCE_NP_MATCHING_ERROR_SEARCH_JOIN_ROOM_NOT_FOUND			0x8002a724
#define SCE_NP_MATCHING_ERROR_INVALID_COMP_OP						0x8002a725
#define SCE_NP_MATCHING_ERROR_INVALID_COMP_TYPE						0x8002a726
#define SCE_NP_MATCHING_ERROR_REQUEST_NOT_FOUND						0x8002a727
#define SCE_NP_MATCHING_ERROR_INTERNAL_ERROR						0x8002a728
#define SCE_NP_MATCHING_ERROR_INVALID_PROTOCOL_ID					0x8002a729
#define SCE_NP_MATCHING_ERROR_ATTR_NOT_SPECIFIED					0x8002a72a
#define SCE_NP_MATCHING_ERROR_SYSUTIL_INVALID_RESULT				0x8002a72b
#define SCE_NP_MATCHING_ERROR_PLUGIN_LOAD_FAILURE					0x8002a72c
#define SCE_NP_MATCHING_ERROR_INVALID_ATTR_VALUE					0x8002a72d
#define SCE_NP_MATCHING_ERROR_DUPLICATE								0x8002a72e
#define SCE_NP_MATCHING_ERROR_INVALID_MEMORY_CONTAINER				0x8002a72f
#define SCE_NP_MATCHING_ERROR_SHUTDOWN								0x8002a730
#define SCE_NP_MATCHING_ERROR_SYSUTIL_SERVER_BUSY					0x8002a731
#define SCE_NP_MATCHING_ERROR_SEND_INVITATION_PARTIALLY_FAILED		0x8002a732
#define SCE_NP_MATCHING_ERROR_UTILITY_UNAVAILABLE					0x8002a733

#define SCE_NP_MATCHING_SERVER_ERROR_OUT_OF_SERVICE					0x8002a740
#define SCE_NP_MATCHING_SERVER_ERROR_MAINTENANCE					0x8002a741
#define SCE_NP_MATCHING_SERVER_ERROR_SERVER_BUSY					0x8002a742
#define SCE_NP_MATCHING_SERVER_ERROR_ACCESS_FORBIDDEN				0x8002a743
#define SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_SERVER					0x8002a744
#define SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_LOBBY					0x8002a745
#define SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_ROOM					0x8002a746
#define SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_USER					0x8002a747
#define SCE_NP_MATCHING_SERVER_ERROR_NOT_ALLOWED					0x8002a748
#define SCE_NP_MATCHING_SERVER_ERROR_UNKNOWN						0x8002a749
#define SCE_NP_MATCHING_SERVER_ERROR_BAD_REQUEST_STANZA				0x8002a74a
#define SCE_NP_MATCHING_SERVER_ERROR_REQUEST_FORBIDDEN				0x8002a74b
#define SCE_NP_MATCHING_SERVER_ERROR_INTERNAL_ERROR					0x8002a74c
#define SCE_NP_MATCHING_SERVER_ERROR_ROOM_OVER						0x8002a74d
#define SCE_NP_MATCHING_SERVER_ERROR_ROOM_CLOSED					0x8002a74e

/* NP Signaling Error */
#define SCE_NP_SIGNALING_ERROR_NOT_INITIALIZED						0x8002a801
#define SCE_NP_SIGNALING_ERROR_ALREADY_INITIALIZED					0x8002a802
#define SCE_NP_SIGNALING_ERROR_OUT_OF_MEMORY						0x8002a803
#define SCE_NP_SIGNALING_ERROR_CTXID_NOT_AVAILABLE					0x8002a804
#define SCE_NP_SIGNALING_ERROR_CTX_NOT_FOUND						0x8002a805
#define SCE_NP_SIGNALING_ERROR_REQID_NOT_AVAILABLE					0x8002a806
#define SCE_NP_SIGNALING_ERROR_REQ_NOT_FOUND						0x8002a807
#define SCE_NP_SIGNALING_ERROR_PARSER_CREATE_FAILED					0x8002a808
#define SCE_NP_SIGNALING_ERROR_PARSER_FAILED						0x8002a809
#define SCE_NP_SIGNALING_ERROR_INVALID_NAMESPACE					0x8002a80a
#define SCE_NP_SIGNALING_ERROR_NETINFO_NOT_AVAILABLE				0x8002a80b
#define SCE_NP_SIGNALING_ERROR_PEER_NOT_RESPONDING					0x8002a80c
#define SCE_NP_SIGNALING_ERROR_CONNID_NOT_AVAILABLE					0x8002a80d
#define SCE_NP_SIGNALING_ERROR_CONN_NOT_FOUND						0x8002a80e
#define SCE_NP_SIGNALING_ERROR_PEER_UNREACHABLE						0x8002a80f
#define SCE_NP_SIGNALING_ERROR_TERMINATED_BY_PEER					0x8002a810
#define SCE_NP_SIGNALING_ERROR_TIMEOUT								0x8002a811
#define SCE_NP_SIGNALING_ERROR_CTX_MAX								0x8002a812
#define SCE_NP_SIGNALING_ERROR_RESULT_NOT_FOUND						0x8002a813
#define SCE_NP_SIGNALING_ERROR_CONN_IN_PROGRESS						0x8002a814
#define SCE_NP_SIGNALING_ERROR_INVALID_ARGUMENT						0x8002a815
#define SCE_NP_SIGNALING_ERROR_OWN_NP_ID							0x8002a816
#define SCE_NP_SIGNALING_ERROR_TOO_MANY_CONN						0x8002a817
#define SCE_NP_SIGNALING_ERROR_TERMINATED_BY_MYSELF					0x8002a818
/* obsolete */
#define SCE_NP_SIGNALING_ERROR_CONN_NOT_ACTIVE						0x8002a814

/* NP Manager Error */
#define SCE_NP_ERROR_NOT_INITIALIZED								0x8002aa01
#define SCE_NP_ERROR_ALREADY_INITIALIZED							0x8002aa02
#define SCE_NP_ERROR_INVALID_ARGUMENT								0x8002aa03
#define SCE_NP_ERROR_OUT_OF_MEMORY									0x8002aa04
#define SCE_NP_ERROR_ID_NO_SPACE									0x8002aa05
#define SCE_NP_ERROR_ID_NOT_FOUND									0x8002aa06
#define SCE_NP_ERROR_SESSION_RUNNING								0x8002aa07
#define SCE_NP_ERROR_LOGINID_ALREADY_EXISTS							0x8002aa08
#define SCE_NP_ERROR_INVALID_TICKET_SIZE							0x8002aa09
#define SCE_NP_ERROR_INVALID_STATE									0x8002aa0a
#define SCE_NP_ERROR_ABORTED										0x8002aa0b
#define SCE_NP_ERROR_OFFLINE										0x8002aa0c
#define SCE_NP_ERROR_VARIANT_ACCOUNT_ID								0x8002aa0d
#define SCE_NP_ERROR_GET_CLOCK										0x8002aa0e
#define SCE_NP_ERROR_INSUFFICIENT_BUFFER							0x8002aa0f
#define SCE_NP_ERROR_EXPIRED_TICKET									0x8002aa10
#define SCE_NP_ERROR_TICKET_PARAM_NOT_FOUND							0x8002aa11
#define SCE_NP_ERROR_UNSUPPORTED_TICKET_VERSION						0x8002aa12
#define SCE_NP_ERROR_TICKET_STATUS_CODE_INVALID						0x8002aa13
#define SCE_NP_ERROR_INVALID_TICKET_VERSION							0x8002aa14
#define SCE_NP_ERROR_ALREADY_USED									0x8002aa15
#define SCE_NP_ERROR_DIFFERENT_USER									0x8002aa16
#define SCE_NP_ERROR_ALREADY_DONE									0x8002aa17
#define SCE_NP_ERROR_INTERNAL										0x8002aaff

/* NP Utility Error */
#define SCE_NP_UTIL_ERROR_INVALID_ARGUMENT							0x8002ab01
#define SCE_NP_UTIL_ERROR_OUT_OF_MEMORY								0x8002ab02
#define SCE_NP_UTIL_ERROR_INSUFFICIENT								0x8002ab03
#define SCE_NP_UTIL_ERROR_PARSER_FAILED								0x8002ab04
#define SCE_NP_UTIL_ERROR_INVALID_PROTOCOL_ID						0x8002ab05
#define SCE_NP_UTIL_ERROR_INVALID_NP_ID								0x8002ab06
#define SCE_NP_UTIL_ERROR_INVALID_NP_LOBBY_ID						0x8002ab07
#define SCE_NP_UTIL_ERROR_INVALID_NP_ROOM_ID						0x8002ab08
#define SCE_NP_UTIL_ERROR_INVALID_NP_ENV							0x8002ab09
#define SCE_NP_UTIL_ERROR_INVALID_TITLEID							0x8002ab0a
#define SCE_NP_UTIL_ERROR_INVALID_CHARACTER							0x8002ab0b
#define SCE_NP_UTIL_ERROR_INVALID_ESCAPE_STRING						0x8002ab0c
#define SCE_NP_UTIL_ERROR_UNKNOWN_TYPE								0x8002ab0d
#define SCE_NP_UTIL_ERROR_UNKNOWN									0x8002ab0e
#define SCE_NP_UTIL_ERROR_NOT_MATCH									0x8002ab0f
#define SCE_NP_UTIL_ERROR_UNKNOWN_PLATFORM_TYPE						0x8002ab10

/* NP Friendlist Error */
#define SCE_NP_FRIENDLIST_ERROR_ALREADY_INITIALIZED					0x8002ab20
#define SCE_NP_FRIENDLIST_ERROR_NOT_INITIALIZED						0x8002ab21
#define SCE_NP_FRIENDLIST_ERROR_OUT_OF_MEMORY						0x8002ab22
#define SCE_NP_FRIENDLIST_ERROR_INVALID_MEMORY_CONTAINER			0x8002ab23
#define SCE_NP_FRIENDLIST_ERROR_INSUFFICIENT						0x8002ab24
#define SCE_NP_FRIENDLIST_ERROR_CANCEL								0x8002ab25
#define SCE_NP_FRIENDLIST_ERROR_STATUS								0x8002ab26
#define SCE_NP_FRIENDLIST_ERROR_BUSY								0x8002ab27
#define SCE_NP_FRIENDLIST_ERROR_INVALID_ARGUMENT					0x8002ab28
#define SCE_NP_FRIENDLIST_ERROR_ABORT								0x8002ab29

/* NP Profile Error */
#define SCE_NP_PROFILE_ERROR_ALREADY_INITIALIZED					0x8002ab40
#define SCE_NP_PROFILE_ERROR_NOT_INITIALIZED						0x8002ab41
#define SCE_NP_PROFILE_ERROR_OUT_OF_MEMORY							0x8002ab42
#define SCE_NP_PROFILE_ERROR_NOT_SUPPORTED							0x8002ab43
#define SCE_NP_PROFILE_ERROR_INSUFFICIENT							0x8002ab44
#define SCE_NP_PROFILE_ERROR_CANCEL									0x8002ab45
#define SCE_NP_PROFILE_ERROR_STATUS									0x8002ab46
#define SCE_NP_PROFILE_ERROR_BUSY									0x8002ab47
#define SCE_NP_PROFILE_ERROR_INVALID_ARGUMENT						0x8002ab48
#define SCE_NP_PROFILE_ERROR_ABORT									0x8002ab49

/* NP Commerce Error */
#define SCE_NP_COMMERCE_ERROR_NOT_INITIALIZED						0x80029401
#define SCE_NP_COMMERCE_ERROR_ALREADY_INITIALIZED					0x80029402
#define SCE_NP_COMMERCE_ERROR_OUT_OF_MEMORY							0x80029403
#define SCE_NP_COMMERCE_ERROR_UNSUPPORTED_VERSION					0x80029404
#define SCE_NP_COMMERCE_ERROR_CTX_MAX								0x80029405
#define SCE_NP_COMMERCE_ERROR_CTX_NOT_FOUND							0x80029406
#define SCE_NP_COMMERCE_ERROR_CTXID_NOT_AVAILABLE					0x80029407
#define SCE_NP_COMMERCE_ERROR_REQ_MAX								0x80029408
#define SCE_NP_COMMERCE_ERROR_REQ_NOT_FOUND							0x80029409
#define SCE_NP_COMMERCE_ERROR_REQID_NOT_AVAILABLE					0x8002940a
#define SCE_NP_COMMERCE_ERROR_INVALID_CATEGORY_ID					0x8002940b
#define SCE_NP_COMMERCE_ERROR_INVALID_LANG_CODE						0x8002940c
#define SCE_NP_COMMERCE_ERROR_REQ_BUSY								0x8002940d
#define SCE_NP_COMMERCE_ERROR_INSUFFICIENT_BUFFER					0x8002940e
#define SCE_NP_COMMERCE_ERROR_INVALID_REQ_STATE						0x8002940f
#define SCE_NP_COMMERCE_ERROR_INVALID_CTX_STATE						0x80029410
#define SCE_NP_COMMERCE_ERROR_UNKNOWN								0x80029411
#define SCE_NP_COMMERCE_ERROR_INVALID_REQ_TYPE						0x80029412
#define SCE_NP_COMMERCE_ERROR_INVALID_MEMORY_CONTAINER				0x80029413
#define SCE_NP_COMMERCE_ERROR_INSUFFICIENT_MEMORY_CONTAINER			0x80029414
#define SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_TYPE				0x80029415
#define SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_STATE				0x80029416
#define SCE_NP_COMMERCE_ERROR_DATA_FLAG_NUM_NOT_FOUND				0x80029417
#define SCE_NP_COMMERCE_ERROR_DATA_FLAG_INFO_NOT_FOUND				0x80029418
#define SCE_NP_COMMERCE_ERROR_INVALID_PROVIDER_ID					0x80029419
#define SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_NUM					0x8002941a
#define SCE_NP_COMMERCE_ERROR_INVALID_SKU_ID						0x8002941b
#define SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_ID					0x8002941c
#define SCE_NP_COMMERCE_ERROR_GPC_SEND_REQUEST						0x8002941d
#define SCE_NP_COMMERCE_ERROR_GDF_SEND_REQUEST						0x8002941e
#define SCE_NP_COMMERCE_ERROR_SDF_SEND_REQUEST						0x8002941f

#define SCE_NP_COMMERCE_ERROR_PARSE_PRODUCT_CATEGORY				0x80029421
#define SCE_NP_COMMERCE_ERROR_CURRENCY_INFO_NOT_FOUND				0x80029422
#define SCE_NP_COMMERCE_ERROR_CATEGORY_INFO_NOT_FOUND				0x80029423
#define SCE_NP_COMMERCE_ERROR_CHILD_CATEGORY_COUNT_NOT_FOUND		0x80029424
#define SCE_NP_COMMERCE_ERROR_CHILD_CATEGORY_INFO_NOT_FOUND			0x80029425
#define SCE_NP_COMMERCE_ERROR_SKU_COUNT_NOT_FOUND					0x80029426
#define SCE_NP_COMMERCE_ERROR_SKU_INFO_NOT_FOUND					0x80029427
#define SCE_NP_COMMERCE_ERROR_PLUGIN_LOAD_FAILURE					0x80029428
#define SCE_NP_COMMERCE_ERROR_INVALID_SKU_NUM						0x80029429
#define SCE_NP_COMMERCE_ERROR_INVALID_GPC_PROTOCOL_VERSION			0x8002942a

#define SCE_NP_COMMERCE_ERROR_CHECKOUT_UNEXPECTED					0x80029430
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_OUT_OF_SERVICE				0x80029431
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_INVALID_SKU					0x80029432
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_SERVER_BUSY					0x80029433
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_MAINTENANCE					0x80029434
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_ACCOUNT_SUSPENDED			0x80029435
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_OVER_SPENDING_LIMIT			0x80029436
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_NOT_ENOUGH_MONEY				0x80029437
#define SCE_NP_COMMERCE_ERROR_CHECKOUT_UNKNOWN						0x80029438

#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_UNKNOWN					0x80029600
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INVALID_CREDENTIALS		0x80029601
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INVALID_CATEGORY_ID		0x80029602
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_END				0x80029603
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_STOP			0x80029604
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_BUSY			0x80029605
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_UNSUPPORTED_VERSION		0x80029606
#define SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INTERNAL_SERVER			0x80029680

#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_UNKNOWN					0x80029d00
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_INVALID_CREDENTIALS		0x80029d01
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_INVALID_FLAGLIST			0x80029d02
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_END				0x80029d03
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_STOP				0x80029d04
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_BUSY				0x80029d05
#define SCE_NP_COMMERCE_GDF_SERVER_ERROR_UNSUPPORTED_VERSION		0x80029d06

#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_UNKNOWN					0x80029e00
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_INVALID_CREDENTIALS		0x80029e01
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_INVALID_FLAGLIST			0x80029e02
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_END				0x80029e03
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_STOP				0x80029e04
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_BUSY				0x80029e05
#define SCE_NP_COMMERCE_SDF_SERVER_ERROR_UNSUPPORTED_VERSION		0x80029e06

/* NP DRM error */
#define SCE_NP_DRM_ERROR_OUT_OF_MEMORY								0x80029501
#define SCE_NP_DRM_ERROR_INVALID_PARAM								0x80029502
#define SCE_NP_DRM_ERROR_SERVER_RESPONSE							0x80029509
#define SCE_NP_DRM_ERROR_NO_ENTITLEMENT								0x80029513
#define SCE_NP_DRM_ERROR_BAD_ACT									0x80029514
#define SCE_NP_DRM_ERROR_BAD_FORMAT									0x80029515
#define SCE_NP_DRM_ERROR_NO_LOGIN									0x80029516
#define SCE_NP_DRM_ERROR_INTERNAL									0x80029517
#define SCE_NP_DRM_ERROR_BAD_PERM									0x80029519
#define SCE_NP_DRM_ERROR_UNKNOWN_VERSION							0x8002951a
#define SCE_NP_DRM_ERROR_TIME_LIMIT									0x8002951b
#define SCE_NP_DRM_ERROR_DIFFERENT_ACCOUNT_ID						0x8002951c
#define SCE_NP_DRM_ERROR_DIFFERENT_DRM_TYPE							0x8002951d
#define SCE_NP_DRM_ERROR_SERVICE_NOT_STARTED						0x8002951e
#define SCE_NP_DRM_ERROR_BUSY										0x80029520
#define SCE_NP_DRM_ERROR_LICENSE_NOT_FOUND							0x80029521
#define SCE_NP_DRM_ERROR_IO											0x80029525
#define SCE_NP_DRM_ERROR_FORMAT										0x80029530
#define SCE_NP_DRM_ERROR_FILENAME									0x80029533
#define SCE_NP_DRM_ERROR_K_LICENSEE									0x80029534

#define SCE_NP_DRM_SERVER_ERROR_SERVICE_IS_END						0x80029700
#define SCE_NP_DRM_SERVER_ERROR_SERVICE_STOPS_TEMPORARILY			0x80029701
#define SCE_NP_DRM_SERVER_ERROR_SERVICE_IS_BUSY						0x80029702
#define SCE_NP_DRM_SERVER_ERROR_INVALID_USER_CREDENTIAL				0x80029721
#define SCE_NP_DRM_SERVER_ERROR_INVALID_PRODUCT_ID					0x80029722
#define SCE_NP_DRM_SERVER_ERROR_ACCOUNT_IS_CLOSED					0x80029730
#define SCE_NP_DRM_SERVER_ERROR_ACCOUNT_IS_SUSPENDED				0x80029731
#define SCE_NP_DRM_SERVER_ERROR_ACTIVATED_CONSOLE_IS_FULL			0x80029750
#define SCE_NP_DRM_SERVER_ERROR_CONSOLE_NOT_ACTIVATED				0x80029751
#define SCE_NP_DRM_SERVER_ERROR_PRIMARY_CONSOLE_CANNOT_CHANGED		0x80029752
#define SCE_NP_DRM_SERVER_ERROR_UNKNOWN								0x80029780

/* NP Matching2 error */
#define SCE_NP_MATCHING2_ERROR_OUT_OF_MEMORY						0x80022301
#define SCE_NP_MATCHING2_ERROR_ALREADY_INITIALIZED					0x80022302
#define SCE_NP_MATCHING2_ERROR_NOT_INITIALIZED						0x80022303
#define SCE_NP_MATCHING2_ERROR_CONTEXT_MAX							0x80022304
#define SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_EXISTS				0x80022305
#define SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_FOUND					0x80022306
#define SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_STARTED				0x80022307
#define SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_STARTED					0x80022308
#define SCE_NP_MATCHING2_ERROR_SERVER_NOT_FOUND						0x80022309
#define SCE_NP_MATCHING2_ERROR_INVALID_ARGUMENT						0x8002230a
#define SCE_NP_MATCHING2_ERROR_INVALID_CONTEXT_ID					0x8002230b
#define SCE_NP_MATCHING2_ERROR_INVALID_SERVER_ID					0x8002230c
#define SCE_NP_MATCHING2_ERROR_INVALID_WORLD_ID						0x8002230d
#define SCE_NP_MATCHING2_ERROR_INVALID_LOBBY_ID						0x8002230e
#define SCE_NP_MATCHING2_ERROR_INVALID_ROOM_ID						0x8002230f
#define SCE_NP_MATCHING2_ERROR_INVALID_MEMBER_ID					0x80022310
#define SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_ID					0x80022311
#define SCE_NP_MATCHING2_ERROR_INVALID_CASTTYPE						0x80022312
#define SCE_NP_MATCHING2_ERROR_INVALID_SORT_METHOD					0x80022313
#define SCE_NP_MATCHING2_ERROR_INVALID_MAX_SLOT						0x80022314
#define SCE_NP_MATCHING2_ERROR_INVALID_OPT_SIZE						0x80022315
#define SCE_NP_MATCHING2_ERROR_INVALID_MATCHING_SPACE				0x80022316
#define SCE_NP_MATCHING2_ERROR_INVALID_PUSH_INDICATION				0x80022317
#define SCE_NP_MATCHING2_ERROR_INVALID_BLOCK_KICK_FLAG				0x80022318
#define SCE_NP_MATCHING2_ERROR_INVALID_MESSAGE_TARGET				0x80022319
#define SCE_NP_MATCHING2_ERROR_RANGE_FILTER_MAX						0x8002231a
#define SCE_NP_MATCHING2_ERROR_INSUFFICIENT_BUFFER					0x8002231b
#define SCE_NP_MATCHING2_ERROR_DESTINATION_DISAPPEARED				0x8002231c
#define SCE_NP_MATCHING2_ERROR_REQUEST_TIMEOUT						0x8002231d
#define SCE_NP_MATCHING2_ERROR_INVALID_ALIGNMENT					0x8002231e
#define SCE_NP_MATCHING2_ERROR_REQUEST_CB_QUEUE_OVERFLOW			0x8002231f
#define SCE_NP_MATCHING2_ERROR_EVENT_CB_QUEUE_OVERFLOW				0x80022320
#define SCE_NP_MATCHING2_ERROR_MSG_CB_QUEUE_OVERFLOW				0x80022321
#define SCE_NP_MATCHING2_ERROR_CONNECTION_CLOSED_BY_SERVER			0x80022322
#define SCE_NP_MATCHING2_ERROR_SSL_VERIFY_FAILED					0x80022323
#define SCE_NP_MATCHING2_ERROR_SSL_HANDSHAKE						0x80022324
#define SCE_NP_MATCHING2_ERROR_SSL_SEND								0x80022325
#define SCE_NP_MATCHING2_ERROR_SSL_RECV								0x80022326
#define SCE_NP_MATCHING2_ERROR_JOINED_SESSION_MAX					0x80022327
#define SCE_NP_MATCHING2_ERROR_ALREADY_JOINED						0x80022328
#define SCE_NP_MATCHING2_ERROR_INVALID_SESSION_TYPE					0x80022329
#define SCE_NP_MATCHING2_ERROR_CLAN_LOBBY_NOT_EXIST					0x8002232a
#define SCE_NP_MATCHING2_ERROR_NP_SIGNED_OUT						0x8002232b
#define SCE_NP_MATCHING2_ERROR_CONTEXT_UNAVAILABLE					0x8002232c
#define SCE_NP_MATCHING2_ERROR_SERVER_NOT_AVAILABLE					0x8002232d
#define SCE_NP_MATCHING2_ERROR_NOT_ALLOWED							0x8002232e
#define SCE_NP_MATCHING2_ERROR_ABORTED								0x8002232f
#define SCE_NP_MATCHING2_ERROR_REQUEST_NOT_FOUND					0x80022330
#define SCE_NP_MATCHING2_ERROR_SESSION_DESTROYED					0x80022331
#define SCE_NP_MATCHING2_ERROR_CONTEXT_STOPPED						0x80022332
#define SCE_NP_MATCHING2_ERROR_INVALID_REQUEST_PARAMETER			0x80022333
#define SCE_NP_MATCHING2_ERROR_NOT_NP_SIGN_IN						0x80022334
#define SCE_NP_MATCHING2_ERROR_ROOM_NOT_FOUND						0x80022335
#define SCE_NP_MATCHING2_ERROR_ROOM_MEMBER_NOT_FOUND				0x80022336
#define SCE_NP_MATCHING2_ERROR_LOBBY_NOT_FOUND						0x80022337
#define SCE_NP_MATCHING2_ERROR_LOBBY_MEMBER_NOT_FOUND				0x80022338
#define SCE_NP_MATCHING2_ERROR_EVENT_DATA_NOT_FOUND					0x80022339
#define SCE_NP_MATCHING2_ERROR_KEEPALIVE_TIMEOUT					0x8002233a
#define SCE_NP_MATCHING2_ERROR_TIMEOUT_TOO_SHORT					0x8002233b
#define SCE_NP_MATCHING2_ERROR_TIMEDOUT								0x8002233c
#define SCE_NP_MATCHING2_ERROR_CREATE_HEAP							0x8002233d
#define SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_SIZE				0x8002233e
#define SCE_NP_MATCHING2_ERROR_CANNOT_ABORT							0x8002233f

/* Matching2 Resolver errors */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_NO_DNS_SERVER       0x800223a2	/* DNS server is not set */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_INVALID_PACKET      0x800223ad	/* received DNS response was invalid. */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_TIMEOUT             0x800223b0	/* timeout */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_NO_RECORD           0x800223b1	/* no record for this query */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_RES_PACKET_FORMAT   0x800223b2	/* server could not recognize DNS query packet */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_RES_SERVER_FAILURE  0x800223b3	/* Server failure. */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_NO_HOST             0x800223b4	/* there is no entry for this hostname */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_RES_NOT_IMPLEMENTED 0x800223b5	/* Kind of query is not supported. */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_RES_SERVER_REFUSED  0x800223b6	/* Refused by server. */
#define SCE_NP_MATCHING2_RESOLVER_ERROR_RESP_TRUNCATED      0x800223bc  /* the response was truncated */

/* NP Matching2 Server error */
#define SCE_NP_MATCHING2_SERVER_ERROR_BAD_REQUEST					0x80022b01
#define SCE_NP_MATCHING2_SERVER_ERROR_SERVICE_UNAVAILABLE			0x80022b02
#define SCE_NP_MATCHING2_SERVER_ERROR_BUSY							0x80022b03
#define SCE_NP_MATCHING2_SERVER_ERROR_END_OF_SERVICE				0x80022b04
#define SCE_NP_MATCHING2_SERVER_ERROR_INTERNAL_SERVER_ERROR			0x80022b05
#define SCE_NP_MATCHING2_SERVER_ERROR_PLAYER_BANNED					0x80022b06
#define SCE_NP_MATCHING2_SERVER_ERROR_FORBIDDEN						0x80022b07
#define SCE_NP_MATCHING2_SERVER_ERROR_BLOCKED						0x80022b08
#define SCE_NP_MATCHING2_SERVER_ERROR_UNSUPPORTED_NP_ENV			0x80022b09
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_TICKET				0x80022b0a
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNATURE				0x80022b0b
#define SCE_NP_MATCHING2_SERVER_ERROR_EXPIRED_TICKET				0x80022b0c
#define SCE_NP_MATCHING2_SERVER_ERROR_ENTITLEMENT_REQUIRED			0x80022b0d
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_CONTEXT				0x80022b0e
#define SCE_NP_MATCHING2_SERVER_ERROR_CLOSED						0x80022b0f
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_TITLE					0x80022b10
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_WORLD					0x80022b11
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY					0x80022b12
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM					0x80022b13
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY_INSTANCE		0x80022b14
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM_INSTANCE			0x80022b15
#define SCE_NP_MATCHING2_SERVER_ERROR_PASSWORD_MISMATCH				0x80022b17
#define SCE_NP_MATCHING2_SERVER_ERROR_LOBBY_FULL					0x80022b18
#define SCE_NP_MATCHING2_SERVER_ERROR_ROOM_FULL						0x80022b19
#define SCE_NP_MATCHING2_SERVER_ERROR_GROUP_FULL					0x80022b1b
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_USER					0x80022b1c
#define SCE_NP_MATCHING2_SERVER_ERROR_TITLE_PASSPHRASE_MISMATCH		0x80022b1e
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_USER_INFO		0x80022b1f
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_USER_INFO_SIGNATURE		0x80022b20
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_INSTANCE_INFO				0x80022b21
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_INSTANCE_INFO_SIGNATURE	0x80022b22
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_INSTANCE_CONFIGURATION		0x80022b23
#define SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNED_INSTANCE_CONFIGURATION_SIGNATURE	0x80022b24
#define SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_LOBBY				0x80022b25
#define SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_ROOM				0x80022b26
#define SCE_NP_MATCHING2_SERVER_ERROR_BANNED_CONSOLE				0x80022b28
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_JOIN_GROUP_LABEL			0x80022b29
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_GROUP					0x80022b2a
#define SCE_NP_MATCHING2_SERVER_ERROR_NO_PASSWORD					0x80022b2b
#define SCE_NP_MATCHING2_SERVER_ERROR_MAX_OVER_SLOT_GROUP			0x80022b2c
#define SCE_NP_MATCHING2_SERVER_ERROR_MAX_OVER_PASSWORD_MASK		0x80022b2d
#define SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_GROUP_LABEL			0x80022b2e
#define SCE_NP_MATCHING2_SERVER_ERROR_REQUEST_OVERFLOW				0x80022b2f
#define SCE_NP_MATCHING2_SERVER_ERROR_ALREADY_JOINED				0x80022b30
#define SCE_NP_MATCHING2_SERVER_ERROR_NAT_TYPE_MISMATCH				0x80022b31
#define SCE_NP_MATCHING2_SERVER_ERROR_ROOM_INCONSISTENCY			0x80022b32
#define SCE_NP_MATCHING2_SERVER_ERROR_BLOCKED_USER_IN_ROOM			0x80022b33

/* Np Clans Error */
#define SCE_NP_CLANS_ERROR_ALREADY_INITIALIZED						0x80022701
#define SCE_NP_CLANS_ERROR_NOT_INITIALIZED							0x80022702
#define SCE_NP_CLANS_ERROR_NOT_SUPPORTED							0x80022703
#define SCE_NP_CLANS_ERROR_OUT_OF_MEMORY							0x80022704
#define SCE_NP_CLANS_ERROR_INVALID_ARGUMENT							0x80022705
#define SCE_NP_CLANS_ERROR_EXCEEDS_MAX								0x80022706
#define SCE_NP_CLANS_ERROR_BAD_RESPONSE								0x80022707
#define SCE_NP_CLANS_ERROR_BAD_DATA									0x80022708
#define SCE_NP_CLANS_ERROR_BAD_REQUEST								0x80022709
#define SCE_NP_CLANS_ERROR_INVALID_SIGNATURE						0x8002270a
#define SCE_NP_CLANS_ERROR_INSUFFICIENT								0x8002270b
#define SCE_NP_CLANS_ERROR_INTERNAL_BUFFER							0x8002270c
#define SCE_NP_CLANS_ERROR_SERVER_MAINTENANCE						0x8002270d
#define SCE_NP_CLANS_ERROR_SERVER_END_OF_SERVICE					0x8002270e
#define SCE_NP_CLANS_ERROR_SERVER_BEFORE_START_OF_SERVICE			0x8002270f
#define SCE_NP_CLANS_ERROR_ABORTED									0x80022710
#define SCE_NP_CLANS_ERROR_SERVICE_UNAVAILABLE						0x80022711

/* Np Clans Server Error */
#define SCE_NP_CLANS_SERVER_ERROR_BAD_REQUEST						0x80022801
#define SCE_NP_CLANS_SERVER_ERROR_INVALID_TICKET					0x80022802
#define SCE_NP_CLANS_SERVER_ERROR_INVALID_SIGNATURE					0x80022803
#define SCE_NP_CLANS_SERVER_ERROR_TICKET_EXPIRED					0x80022804
#define SCE_NP_CLANS_SERVER_ERROR_INVALID_NPID						0x80022805
#define SCE_NP_CLANS_SERVER_ERROR_FORBIDDEN							0x80022806
#define SCE_NP_CLANS_SERVER_ERROR_INTERNAL_SERVER_ERROR				0x80022807
#define SCE_NP_CLANS_SERVER_ERROR_BANNED							0x8002280a
#define SCE_NP_CLANS_SERVER_ERROR_BLACKLISTED						0x80022811
#define SCE_NP_CLANS_SERVER_ERROR_INVALID_ENVIRONMENT				0x8002281d
#define SCE_NP_CLANS_SERVER_ERROR_NO_SUCH_CLAN_SERVICE				0x8002282f
#define SCE_NP_CLANS_SERVER_ERROR_NO_SUCH_CLAN						0x80022830
#define SCE_NP_CLANS_SERVER_ERROR_NO_SUCH_CLAN_MEMBER				0x80022831
#define SCE_NP_CLANS_SERVER_ERROR_BEFORE_HOURS						0x80022832
#define SCE_NP_CLANS_SERVER_ERROR_CLOSED_SERVICE					0x80022833
#define SCE_NP_CLANS_SERVER_ERROR_PERMISSION_DENIED					0x80022834
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_LIMIT_REACHED				0x80022835
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_LEADER_LIMIT_REACHED			0x80022836
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_MEMBER_LIMIT_REACHED			0x80022837
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_JOINED_LIMIT_REACHED			0x80022838
#define SCE_NP_CLANS_SERVER_ERROR_MEMBER_STATUS_INVALID				0x80022839
#define SCE_NP_CLANS_SERVER_ERROR_DUPLICATED_CLAN_NAME				0x8002283a
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_LEADER_CANNOT_LEAVE			0x8002283b
#define SCE_NP_CLANS_SERVER_ERROR_ANNOUNCEMENT_LIMIT_REACHED		0x8002283d
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_CONFIG_MASTER_NOT_FOUND		0x8002283e
#define SCE_NP_CLANS_SERVER_ERROR_DUPLICATED_CLAN_TAG				0x8002283f
#define SCE_NP_CLANS_SERVER_ERROR_EXCEEDS_CREATE_CLAN_FREQUENCY		0x80022840
#define SCE_NP_CLANS_SERVER_ERROR_CLAN_PASSPHRASE_INCORRECT			0x80022841
#define SCE_NP_CLANS_SERVER_ERROR_CANNOT_RECORD_BLACKLIST_ENTRY		0x80022842
#define SCE_NP_CLANS_SERVER_ERROR_NO_SUCH_CLAN_ANNOUNCEMENT			0x80022843
#define SCE_NP_CLANS_SERVER_ERROR_VULGAR_WORDS_POSTED				0x80022844
#define SCE_NP_CLANS_SERVER_ERROR_BLACKLIST_LIMIT_REACHED			0x80022845
#define SCE_NP_CLANS_SERVER_ERROR_NO_SUCH_BLACKLIST_ENTRY			0x80022846
#define SCE_NP_CLANS_SERVER_ERROR_INVALID_NP_MESSAGE_FORMAT			0x8002284b
#define SCE_NP_CLANS_SERVER_ERROR_FAILED_TO_SEND_NP_MESSAGE			0x8002284c

/* NP Commerce2 system utility error (0x80024000 - 0x800240ff) */
#define SCE_NP_COMMERCE2_SYSTEM_UTIL_ERROR_INVALID_VOUCHER          0x80024002

/* NP Commerce2 error (0x80023000 - 0x800230ff) */
#define SCE_NP_COMMERCE2_ERROR_NOT_INITIALIZED                      0x80023001
#define SCE_NP_COMMERCE2_ERROR_ALREADY_INITIALIZED                  0x80023002
#define SCE_NP_COMMERCE2_ERROR_INVALID_ARGUMENT                     0x80023003
#define SCE_NP_COMMERCE2_ERROR_UNSUPPORTED_VERSION                  0x80023004
#define SCE_NP_COMMERCE2_ERROR_CTX_MAX                              0x80023005
#define SCE_NP_COMMERCE2_ERROR_INVALID_INDEX                        0x80023006
#define SCE_NP_COMMERCE2_ERROR_INVALID_SKUID                        0x80023007
#define SCE_NP_COMMERCE2_ERROR_INVALID_SKU_NUM                      0x80023008
#define SCE_NP_COMMERCE2_ERROR_INVALID_MEMORY_CONTAINER             0x80023009
#define SCE_NP_COMMERCE2_ERROR_INSUFFICIENT_MEMORY_CONTAINER        0x8002300a
#define SCE_NP_COMMERCE2_ERROR_OUT_OF_MEMORY                        0x8002300b
#define SCE_NP_COMMERCE2_ERROR_CTX_NOT_FOUND                        0x8002300c
#define SCE_NP_COMMERCE2_ERROR_CTXID_NOT_AVAILABLE                  0x8002300d
#define SCE_NP_COMMERCE2_ERROR_REQ_NOT_FOUND                        0x8002300e
#define SCE_NP_COMMERCE2_ERROR_REQID_NOT_AVAILABLE                  0x8002300f
#define SCE_NP_COMMERCE2_ERROR_ABORTED                              0x80023010
#define SCE_NP_COMMERCE2_ERROR_REQUEST_BUF_TOO_SMALL                0x80023011
#define SCE_NP_COMMERCE2_ERROR_RESPONSE_BUF_TOO_SMALL               0x80023012
#define SCE_NP_COMMERCE2_ERROR_COULD_NOT_RECV_WHOLE_RESPONSE_DATA   0x80023013
#define SCE_NP_COMMERCE2_ERROR_INVALID_RESULT_DATA                  0x80023014
#define SCE_NP_COMMERCE2_ERROR_UNKNOWN                              0x80023015
#define SCE_NP_COMMERCE2_ERROR_SERVER_MAINTENANCE                   0x80023016
#define SCE_NP_COMMERCE2_ERROR_SERVER_UNKNOWN                       0x80023017
#define SCE_NP_COMMERCE2_ERROR_INSUFFICIENT_BUF_SIZE                0x80023018
#define SCE_NP_COMMERCE2_ERROR_REQ_MAX                              0x80023019
#define SCE_NP_COMMERCE2_ERROR_INVALID_TARGET_TYPE                  0x8002301a
#define SCE_NP_COMMERCE2_ERROR_INVALID_TARGET_ID                    0x8002301b
#define SCE_NP_COMMERCE2_ERROR_INVALID_SIZE                         0x8002301c
#define SCE_NP_COMMERCE2_ERROR_DATA_NOT_FOUND                       0x80023087

#define SCE_NP_COMMERCE2_SC_ERROR_INVALID_RESPONSE                  0x800230e1

/* NP Commerce2 server error (0x80023100 - 0x800231ff) */
#define SCE_NP_COMMERCE2_SERVER_ERROR_BAD_REQUEST                   0x80023101
#define SCE_NP_COMMERCE2_SERVER_ERROR_UNKNOWN_ERROR                 0x80023102
#define SCE_NP_COMMERCE2_SERVER_ERROR_SESSION_EXPIRED               0x80023105
#define SCE_NP_COMMERCE2_SERVER_ERROR_ACCESS_PERMISSION_DENIED      0x80023107
#define SCE_NP_COMMERCE2_SERVER_ERROR_NO_SUCH_CATEGORY              0x80023110
#define SCE_NP_COMMERCE2_SERVER_ERROR_NO_SUCH_PRODUCT               0x80023111
#define SCE_NP_COMMERCE2_SERVER_ERROR_NOT_ELIGIBILITY               0x80023113
#define SCE_NP_COMMERCE2_SERVER_ERROR_INVALID_SKU                   0x8002311a
#define SCE_NP_COMMERCE2_SERVER_ERROR_ACCOUNT_SUSPENDED1            0x8002311b
#define SCE_NP_COMMERCE2_SERVER_ERROR_ACCOUNT_SUSPENDED2            0x8002311c
#define SCE_NP_COMMERCE2_SERVER_ERROR_OVER_SPENDING_LIMIT           0x80023120
#define SCE_NP_COMMERCE2_SERVER_ERROR_INVALID_VOUCHER               0x8002312f
#define SCE_NP_COMMERCE2_SERVER_ERROR_VOUCHER_ALREADY_CONSUMED      0x80023130
#define SCE_NP_COMMERCE2_SERVER_ERROR_EXCEEDS_AGE_LIMIT_IN_BROWSING 0x80023139

/* Np Trophy Errors */
#define SCE_NP_TROPHY_ERROR_ALREADY_INITIALIZED						0x80022901
#define SCE_NP_TROPHY_ERROR_NOT_INITIALIZED							0x80022902
#define SCE_NP_TROPHY_ERROR_NOT_SUPPORTED							0x80022903
#define SCE_NP_TROPHY_ERROR_CONTEXT_NOT_REGISTERED					0x80022904
#define SCE_NP_TROPHY_ERROR_OUT_OF_MEMORY							0x80022905
#define SCE_NP_TROPHY_ERROR_INVALID_ARGUMENT						0x80022906
#define SCE_NP_TROPHY_ERROR_EXCEEDS_MAX								0x80022907
#define SCE_NP_TROPHY_ERROR_INVALID_MEMORY_CONTAINER				0x80022908
#define SCE_NP_TROPHY_ERROR_INSUFFICIENT							0x80022909
#define SCE_NP_TROPHY_ERROR_UNKNOWN_CONTEXT							0x8002290a
#define SCE_NP_TROPHY_ERROR_INVALID_FORMAT							0x8002290b
#define SCE_NP_TROPHY_ERROR_BAD_RESPONSE							0x8002290c
#define SCE_NP_TROPHY_ERROR_INVALID_GRADE							0x8002290d
#define SCE_NP_TROPHY_ERROR_INVALID_CONTEXT							0x8002290e
#define SCE_NP_TROPHY_ERROR_PROCESSING_ABORTED						0x8002290f
#define SCE_NP_TROPHY_ERROR_ABORT									0x80022910
#define SCE_NP_TROPHY_ERROR_UNKNOWN_HANDLE							0x80022911
#define SCE_NP_TROPHY_ERROR_LOCKED									0x80022912
#define SCE_NP_TROPHY_ERROR_HIDDEN									0x80022913
#define SCE_NP_TROPHY_ERROR_CANNOT_UNLOCK_PLATINUM					0x80022914
#define SCE_NP_TROPHY_ERROR_ALREADY_UNLOCKED						0x80022915
#define SCE_NP_TROPHY_ERROR_INVALID_TYPE							0x80022916
#define SCE_NP_TROPHY_ERROR_INVALID_HANDLE							0x80022917
#define SCE_NP_TROPHY_ERROR_INVALID_NP_COMM_ID						0x80022918
#define SCE_NP_TROPHY_ERROR_UNKNOWN_NP_COMM_ID						0x80022919
#define SCE_NP_TROPHY_ERROR_DISC_IO									0x8002291a
#define SCE_NP_TROPHY_ERROR_CONF_DOES_NOT_EXIST						0x8002291b
#define SCE_NP_TROPHY_ERROR_UNSUPPORTED_FORMAT						0x8002291c
#define SCE_NP_TROPHY_ERROR_ALREADY_INSTALLED						0x8002291d
#define SCE_NP_TROPHY_ERROR_BROKEN_DATA								0x8002291e
#define SCE_NP_TROPHY_ERROR_VERIFICATION_FAILURE					0x8002291f
#define SCE_NP_TROPHY_ERROR_INVALID_TROPHY_ID						0x80022920
#define SCE_NP_TROPHY_ERROR_UNKNOWN_TROPHY_ID						0x80022921
#define SCE_NP_TROPHY_ERROR_UNKNOWN_TITLE							0x80022922
#define SCE_NP_TROPHY_ERROR_UNKNOWN_FILE							0x80022923
#define SCE_NP_TROPHY_ERROR_DISC_NOT_MOUNTED						0x80022924
#define SCE_NP_TROPHY_ERROR_SHUTDOWN								0x80022925
#define SCE_NP_TROPHY_ERROR_TITLE_ICON_NOT_FOUND					0x80022926
#define SCE_NP_TROPHY_ERROR_TROPHY_ICON_NOT_FOUND					0x80022927
#define SCE_NP_TROPHY_ERROR_INSUFFICIENT_DISK_SPACE					0x80022928
#define SCE_NP_TROPHY_ERROR_INVALID_SIGNATURE						0x80022929
#define SCE_NP_TROPHY_ERROR_ILLEGAL_UPDATE							0x8002292a
#define SCE_NP_TROPHY_ERROR_SAVEDATA_USER_DOES_NOT_MATCH			0x8002292b
#define SCE_NP_TROPHY_ERROR_TROPHY_ID_DOES_NOT_EXIST				0x8002292c
#define SCE_NP_TROPHY_ERROR_SERVICE_UNAVAILABLE						0x8002292d
#define SCE_NP_TROPHY_ERROR_INVALID_PLATFORM						0x8002292e
#define SCE_NP_TROPHY_ERROR_UNKNOWN									0x800229ff

/* NP Custom Menu Error */
#define SCE_NP_CUSTOM_MENU_ERROR_ALREADY_INITIALIZED				0x80023b01
#define SCE_NP_CUSTOM_MENU_ERROR_NOT_INITIALIZED					0x80023b02
#define SCE_NP_CUSTOM_MENU_ERROR_OUT_OF_MEMORY						0x80023b03
#define SCE_NP_CUSTOM_MENU_ERROR_NOT_SUPPORTED						0x80023b04
#define SCE_NP_CUSTOM_MENU_ERROR_INSUFFICIENT						0x80023b05
#define SCE_NP_CUSTOM_MENU_ERROR_CANCEL								0x80023b06
#define SCE_NP_CUSTOM_MENU_ERROR_STATUS								0x80023b07
#define SCE_NP_CUSTOM_MENU_ERROR_BUSY								0x80023b08
#define SCE_NP_CUSTOM_MENU_ERROR_INVALID_ARGUMENT					0x80023b09
#define SCE_NP_CUSTOM_MENU_ERROR_ABORT								0x80023b0a
#define SCE_NP_CUSTOM_MENU_ERROR_NOT_REGISTERED						0x80023b0b
#define SCE_NP_CUSTOM_MENU_ERROR_EXCEEDS_MAX						0x80023b0c
#define SCE_NP_CUSTOM_MENU_ERROR_INVALID_CHARACTER					0x80023b0d

/*J NP SNS エラー(一般的なエラー) */
/*J 不明なエラー */
#define SCE_NP_SNS_ERROR_UNKNOWN                                   0x80024501
/*J NPサインインしていない(sceNpSnsFbStreamPublish()はNPサインイン必要) */
#define SCE_NP_SNS_ERROR_NOT_SIGN_IN                               0x80024502
/*J 不正な引数 (意図しないnullポインタなどを渡された) */
#define SCE_NP_SNS_ERROR_INVALID_ARGUMENT                          0x80024503
/*J メモリ不足 */
#define SCE_NP_SNS_ERROR_OUT_OF_MEMORY                             0x80024504
/*J ゲームが終了中 */
#define SCE_NP_SNS_ERROR_SHUTDOWN                                  0x80024505
#define SCE_NP_SNS_ERROR_BUSY                                      0x80024506
/*J NP SNS FB エラー(sceNpSnsFb関数の使い方やFacebookの設定状態に関わるエラー) */
/*J 初期済みである (sceNpSnsFbInit()から返ることがある) */
#define SCE_NP_SNS_FB_ERROR_ALREADY_INITIALIZED                    0x80024511
/*J 初期化されてない (sceNpSnsFbTerm()から帰ることがある) */
#define SCE_NP_SNS_FB_ERROR_NOT_INITIALIZED                        0x80024512
/*J ハンドルを使用しすぎている */
#define SCE_NP_SNS_FB_ERROR_EXCEEDS_MAX                            0x80024513
/*J 不明なハンドル */
#define SCE_NP_SNS_FB_ERROR_UNKNOWN_HANDLE                         0x80024514
/*J アボートされた */
#define SCE_NP_SNS_FB_ERROR_ABORTED                                0x80024515
/*J アボート済みの操作を再アボートした */
#define SCE_NP_SNS_FB_ERROR_ALREADY_ABORTED                        0x80024516
/*J 設定が無効になっている */
#define SCE_NP_SNS_FB_ERROR_CONFIG_DISABLED                        0x80024517
/*J Facebookサーバがエラーを返した */
#define SCE_NP_SNS_FB_ERROR_FBSERVER_ERROR_RESPONSE                0x80024518
/*J スロットルが閉じられている */
#define SCE_NP_SNS_FB_ERROR_THROTTLE_CLOSED                        0x80024519
/*J 操作間隔違反 */
#define SCE_NP_SNS_FB_ERROR_OPERATION_INTERVAL_VIOLATION           0x8002451a
/*J スロットルが未ロード */
#define SCE_NP_SNS_FB_ERROR_UNLOADED_THROTTLE                      0x8002451b
#define SCE_NP_SNS_FB_ERROR_ACCESS_NOT_ALLOWED                     0x8002451c


/* NP Auth OAuth error */
#define SCE_NP_OAUTH_ERROR_UNKNOWN									0x80025f01
#define SCE_NP_OAUTH_ERROR_ALREADY_INITIALIZED						0x80025f02
#define SCE_NP_OAUTH_ERROR_NOT_INITIALIZED							0x80025f03
#define SCE_NP_OAUTH_ERROR_INVALID_ARGUMENT							0x80025f04
#define SCE_NP_OAUTH_ERROR_OUT_OF_MEMORY							0x80025f05
#define SCE_NP_OAUTH_ERROR_OUT_OF_BUFFER							0x80025f06
#define SCE_NP_OAUTH_ERROR_BAD_RESPONSE								0x80025f07
#define SCE_NP_OAUTH_ERROR_ABORTED									0x80025f08
#define SCE_NP_OAUTH_ERROR_SIGNED_OUT								0x80025f09
#define SCE_NP_OAUTH_ERROR_REQUEST_NOT_FOUND						0x80025f0a
#define SCE_NP_OAUTH_ERROR_SSL_ERR_CN_CHECK							0x80025f0b
#define SCE_NP_OAUTH_ERROR_SSL_ERR_UNKNOWN_CA						0x80025f0c
#define SCE_NP_OAUTH_ERROR_SSL_ERR_NOT_AFTER_CHECK					0x80025f0d
#define SCE_NP_OAUTH_ERROR_SSL_ERR_NOT_BEFORE_CHECK					0x80025f0e
#define SCE_NP_OAUTH_ERROR_SSL_ERR_INVALID_CERT						0x80025f0f
#define SCE_NP_OAUTH_ERROR_SSL_ERR_INTERNAL							0x80025f10
#define SCE_NP_OAUTH_ERROR_REQUEST_MAX								0x80025f11

#define SCE_NP_OAUTH_SERVER_ERROR_BANNED_CONSOLE					0x80025d14

#define SCE_NP_OAUTH_SERVER_ERROR_INVALID_LOGIN						0x82e00014
#define SCE_NP_OAUTH_SERVER_ERROR_INACTIVE_ACCOUNT					0x82e0001b
#define SCE_NP_OAUTH_SERVER_ERROR_SUSPENDED_ACCOUNT					0x82e0001c
#define SCE_NP_OAUTH_SERVER_ERROR_SUSPENDED_DEVICE					0x82e0001d
#define SCE_NP_OAUTH_SERVER_ERROR_PASSWORD_EXPIRED					0x82e00064
#define SCE_NP_OAUTH_SERVER_ERROR_TOSUA_MUST_BE_RE_ACCEPTED			0x82e00067
#define SCE_NP_OAUTH_SERVER_ERROR_TOSUA_MUST_BE_RE_ACCEPTED_FOR_SUBACCOUNT	0x82e01042
#define SCE_NP_OAUTH_SERVER_ERROR_BANNED_ACCOUNT					0x82e01050
#define SCE_NP_OAUTH_SERVER_ERROR_SERVICE_END						0x82e1019a
#define SCE_NP_OAUTH_SERVER_ERROR_SERVICE_UNAVAILABLE				0x82e101f7

#define SCE_NP_LS_ERROR_INVALID_VERSION								0x80028c0d

/* for compatibility */
#define SCE_NP_CORE_ERROR_INVALID_PSHANDLE							SCE_NP_CORE_ERROR_INVALID_ONLINEID

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SCE_NP_VSH_ERROR_H */
