/* SCE CONFIDENTIAL
 PlayStation(R)3 Programmer Tool Runtime Library 475.001
 *
 *      Copyright (C) 2014 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 */
#ifndef _SCE_NP_AUTH_OAUTH_H_
#define _SCE_NP_AUTH_OAUTH_H_

#include <stdio.h>

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif  /* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */


/* NP Client ID */
#define SCE_NP_CLIENT_ID_MAX_LEN 128
typedef struct SceNpClientId {
	char id[SCE_NP_CLIENT_ID_MAX_LEN + 1];
	uint8_t padding[7];
} SceNpClientId;

/* NP Authorization Code */
#define SCE_NP_AUTHORIZATION_CODE_MAX_LEN 128
typedef struct SceNpAuthorizationCode {
	char code[SCE_NP_AUTHORIZATION_CODE_MAX_LEN + 1];
	uint8_t padding[7];
} SceNpAuthorizationCode;


typedef struct SceNpAuthGetAuthorizationCodeParameter {
	size_t size;
	const SceNpClientId *pClientId;
	const char *pScope;
} SceNpAuthGetAuthorizationCodeParameter;

typedef int SceNpAuthOAuthRequestId;

#define SCE_NP_AUTH_OAUTH_REQUEST_ID_MAX	4



int sceNpAuthOAuthInit(void);
int sceNpAuthOAuthTerm(void);

SceNpAuthOAuthRequestId
sceNpAuthCreateOAuthRequest(
    void
	);

int
sceNpAuthDeleteOAuthRequest(
    SceNpAuthOAuthRequestId reqId
	);

int
sceNpAuthAbortOAuthRequest(
    SceNpAuthOAuthRequestId reqId
    );

int
sceNpAuthGetAuthorizationCode(
    SceNpAuthOAuthRequestId reqId,
	const SceNpAuthGetAuthorizationCodeParameter *param,
	SceNpAuthorizationCode *authCode,
	int *issuerId
    );

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif  /* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /* NP_AUTH_OAUTH_H_ */
