/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 470.001
 * Copyright (C) 2010 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_FLASH_VARIANT_HELPER_H__
#define __CELL_FLASH_VARIANT_HELPER_H__

#ifdef __cplusplus
/* C++ interfaces */

#include <flash/flash9.h>
#include <string.h>

namespace cell
{
namespace Flash
{
namespace Variant
{
	inline CellFlashVariant genUndef()
	{
		CellFlashVariant v;
		v.type = CELL_FLASH_VARIANT_TYPE_VOID;
		v.value.objectValue = NULL;
		return v;
	}

	inline CellFlashVariant genNull()
	{
		CellFlashVariant v;
		v.type = CELL_FLASH_VARIANT_TYPE_NULL;
		v.value.objectValue = NULL;
		return v;
	}

	inline CellFlashVariant genBool(bool v)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_BOOL;
		t.value.boolValue = (CellFlashBool)v;
		return t;
	}

	inline CellFlashVariant genInt(int32_t v)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_INT32;
		t.value.intValue = v;
		return t;
	}

	inline CellFlashVariant genDouble(double v)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_DOUBLE;
		t.value.doubleValue = v;
		return t;
	}

	inline CellFlashVariant genObject(CellFlashObject* v)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_OBJECT;
		t.value.objectValue = v;
		return t;
	}

	inline CellFlashVariant genAtom(CellFlashAtom p)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_ATOM;
		t.value.atomValue = p;
		return t;
	}

	inline CellFlashVariant genString(const char* v)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_STRING;
		t.value.stringValue.utf8characters = v;
		t.value.stringValue.utf8length = strlen(v);
		return t;
	}

	inline CellFlashVariant genString(const char* v, size_t len)
	{
		CellFlashVariant t;
		t.type = CELL_FLASH_VARIANT_TYPE_STRING;
		t.value.stringValue.utf8characters = v;
		t.value.stringValue.utf8length = len;
		return t;
	}

	inline bool isUndef(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_VOID;}
	inline bool isNull(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_NULL; }
	inline bool isBool(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_BOOL; }
	inline bool isInt(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_INT32; }
	inline bool isDouble(const CellFlashVariant& v) {	return v.type == CELL_FLASH_VARIANT_TYPE_DOUBLE; }
	inline bool isObject(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_OBJECT; }
	inline bool isAtom(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_ATOM; }
	inline bool isString(const CellFlashVariant& v) { return v.type == CELL_FLASH_VARIANT_TYPE_STRING; }

	inline bool isPrimitive(const CellFlashVariant& v) { return isInt(v) || isDouble(v) || isBool(v); }
	inline bool isNullOrUndef(const CellFlashVariant& v) { return isNull(v) || isUndef(v); }

	inline bool getBool(const CellFlashVariant& v) { return (bool)v.value.boolValue; }
	inline int getInt(const CellFlashVariant& v) { return v.value.intValue; }
	inline double getDouble(const CellFlashVariant& v) {	return v.value.doubleValue; }

	inline const CellFlashObject* getObject(const CellFlashVariant& v) { return v.value.objectValue; }
	inline CellFlashObject* getObject(CellFlashVariant& v) { return v.value.objectValue; }

	inline CellFlashAtom getAtom(const CellFlashVariant& v) { return v.value.atomValue; }
	inline CellFlashString getString(const CellFlashVariant& v) { return v.value.stringValue; }
	inline const char* getCString(const CellFlashVariant& v) { return v.value.stringValue.utf8characters; }
}
}
}
#endif
#endif
