/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef __SYSMODULE_H__
#define __SYSMODULE_H__

#include <stdint.h>
#include <cell/error.h>
#include <sys/memory.h>

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif

/* module ID definitions */
#define CELL_SYSMODULE_INVALID		0xffff
#define CELL_SYSMODULE_NET			0x0000
#define CELL_SYSMODULE_HTTP			0x0001
#define CELL_SYSMODULE_HTTP_UTIL	0x0002
#define CELL_SYSMODULE_SSL			0x0003
#define CELL_SYSMODULE_HTTPS		0x0004
#define CELL_SYSMODULE_VDEC			0x0005
#define CELL_SYSMODULE_ADEC			0x0006
#define CELL_SYSMODULE_DMUX			0x0007
#define CELL_SYSMODULE_VPOST		0x0008
#define CELL_SYSMODULE_RTC			0x0009
#define CELL_SYSMODULE_SPURS		0x000a
#define CELL_SYSMODULE_OVIS			0x000b
#define CELL_SYSMODULE_SHEAP		0x000c
#define CELL_SYSMODULE_SYNC			0x000d
#define CELL_SYSMODULE_FS			0x000e
#define CELL_SYSMODULE_JPGDEC		0x000f
#define CELL_SYSMODULE_GCM_SYS		0x0010
#define CELL_SYSMODULE_GCM			0x0010
#define CELL_SYSMODULE_AUDIO		0x0011
#define CELL_SYSMODULE_PAMF			0x0012
#define CELL_SYSMODULE_ATRAC3PLUS	0x0013
#define CELL_SYSMODULE_NETCTL		0x0014
#define CELL_SYSMODULE_SYSUTIL		0x0015
#define CELL_SYSMODULE_SYSUTIL_NP	0x0016
#define CELL_SYSMODULE_IO			0x0017
#define CELL_SYSMODULE_PNGDEC		0x0018
#define CELL_SYSMODULE_FONT			0x0019
#define CELL_SYSMODULE_FONTFT		0x001a
#define CELL_SYSMODULE_FREETYPE		0x001b
#define CELL_SYSMODULE_USBD			0x001c
#define CELL_SYSMODULE_SAIL			0x001d
#define CELL_SYSMODULE_L10N			0x001e
#define CELL_SYSMODULE_RESC			0x001f
#define CELL_SYSMODULE_DAISY		0x0020
#define CELL_SYSMODULE_KEY2CHAR		0x0021
#define CELL_SYSMODULE_MIC          0x0022
#define CELL_SYSMODULE_CAMERA       0x0023
#define CELL_SYSMODULE_VDEC_MPEG2	0x0024
#define CELL_SYSMODULE_VDEC_AVC		0x0025
#define CELL_SYSMODULE_ADEC_LPCM	0x0026
#define CELL_SYSMODULE_ADEC_AC3		0x0027
#define CELL_SYSMODULE_ADEC_ATX		0x0028
#define CELL_SYSMODULE_ADEC_AT3		0x0029
#define CELL_SYSMODULE_DMUX_PAMF	0x002a
#define CELL_SYSMODULE_VDEC_AL		0x002b
#define CELL_SYSMODULE_ADEC_AL		0x002c
#define CELL_SYSMODULE_DMUX_AL		0x002d
#define CELL_SYSMODULE_LV2DBG		0x002e
#define CELL_SYSMODULE_USBPSPCM		0x0030
#define CELL_SYSMODULE_AVCONF_EXT	0x0031
#define CELL_SYSMODULE_SYSUTIL_USERINFO	0x0032
#define CELL_SYSMODULE_SYSUTIL_SAVEDATA	0x0033
#define CELL_SYSMODULE_SUBDISPLAY	0x0034
#define CELL_SYSMODULE_SYSUTIL_REC	0x0035
#define CELL_SYSMODULE_VIDEO_EXPORT	0x0036
#define CELL_SYSMODULE_SYSUTIL_GAME_EXEC	0x0037
#define CELL_SYSMODULE_SYSUTIL_NP2	0x0038
#define CELL_SYSMODULE_SYSUTIL_AP	0x0039
#define CELL_SYSMODULE_SYSUTIL_NP_CLANS	0x003a
#define CELL_SYSMODULE_SYSUTIL_OSK_EXT	0x003b
#define CELL_SYSMODULE_VDEC_DIVX	0x003c
#define CELL_SYSMODULE_JPGENC		0x003d
#define CELL_SYSMODULE_SYSUTIL_GAME	0x003e
#define CELL_SYSMODULE_BGDL			0x003f
#define CELL_SYSMODULE_FREETYPE_TT	0x0040
#define CELL_SYSMODULE_SYSUTIL_VIDEO_UPLOAD	0x0041
#define CELL_SYSMODULE_SYSUTIL_SYSCONF_EXT	0x0042
#define CELL_SYSMODULE_FIBER		0x0043
#define CELL_SYSMODULE_SYSUTIL_NP_COMMERCE2	0x0044
#define CELL_SYSMODULE_SYSUTIL_NP_TUS	0x0045
#define CELL_SYSMODULE_VOICE		0x0046
#define CELL_SYSMODULE_ADEC_CELP8	0x0047
#define CELL_SYSMODULE_CELP8ENC		0x0048
#define CELL_SYSMODULE_SYSUTIL_LICENSEAREA	0x0049
#define CELL_SYSMODULE_SYSUTIL_MUSIC2	0x004a
#define CELL_SYSMODULE_SYSUTIL_SCREENSHOT	0x004e
#define CELL_SYSMODULE_SYSUTIL_MUSIC_DECODE	0x004f
#define CELL_SYSMODULE_SPURS_JQ		0x0050
#define CELL_SYSMODULE_PNGENC		0x0052
#define CELL_SYSMODULE_SYSUTIL_MUSIC_DECODE2	0x0053
#define CELL_SYSMODULE_SYNC2		0x0055
#define CELL_SYSMODULE_SYSUTIL_NP_UTIL	0x0056
#define CELL_SYSMODULE_RUDP			0x0057
#define CELL_SYSMODULE_SYSUTIL_NP_SNS	0x0059
#define CELL_SYSMODULE_GEM			0x005a
#define CELL_SYSMODULE_SYSUTIL_CROSS_CONTROLLER	0x005c
#define CELL_SYSMODULE_CELPENC		0xf00a
#define CELL_SYSMODULE_GIFDEC		0xf010
#define CELL_SYSMODULE_ADEC_CELP	0xf019
#define CELL_SYSMODULE_ADEC_M2BC	0xf01b
#define CELL_SYSMODULE_ADEC_M4AAC	0xf01d
#define CELL_SYSMODULE_ADEC_MP3		0xf01e
#define CELL_SYSMODULE_IMEJP		0xf023
#define CELL_SYSMODULE_SYSUTIL_MUSIC	0xf028
#define CELL_SYSMODULE_PHOTO_EXPORT	0xf029
#define CELL_SYSMODULE_PRINT		0xf02a
#define CELL_SYSMODULE_PHOTO_IMPORT		0xf02b
#define CELL_SYSMODULE_MUSIC_EXPORT		0xf02c
#define CELL_SYSMODULE_PHOTO_DECODE		0xf02e
#define CELL_SYSMODULE_SYSUTIL_SEARCH	0xf02f
#define CELL_SYSMODULE_SYSUTIL_AVCHAT2	0xf030
#define CELL_SYSMODULE_SAIL_REC			0xf034
#define CELL_SYSMODULE_SYSUTIL_NP_TROPHY 0xf035
#define CELL_SYSMODULE_LIBATRAC3MULTI	0xf054

/* module */

typedef struct {
	int32_t prx_id;
	int32_t prx_depend_id;
} CellSysmoduleInfo;

/* return value (error codes) */
#define CELL_SYSMODULE_ERROR_DUPLICATED		CELL_ERROR_CAST(0x80012001)
#define CELL_SYSMODULE_ERROR_UNKNOWN		CELL_ERROR_CAST(0x80012002)
#define CELL_SYSMODULE_ERROR_UNLOADED		CELL_ERROR_CAST(0x80012003)
#define CELL_SYSMODULE_ERROR_INVALID_MEMCONTAINER	CELL_ERROR_CAST(0x80012004)
#define CELL_SYSMODULE_ERROR_FATAL			CELL_ERROR_CAST(0x800120ff)

#define CELL_SYSMODULE_LOADED				CELL_OK

/* function prototypes */
int cellSysmoduleLoadModule(uint16_t id);
int cellSysmoduleUnloadModule(uint16_t id);

int cellSysmoduleInitialize(void);
int cellSysmoduleFinalize(void);

int cellSysmoduleIsLoaded(uint16_t id);

int cellSysmoduleSetMemcontainer(sys_memory_container_t ct);

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif

#endif /* __SUSMODULE_H__ */
