/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef __CELL_SYNC_RETURN_CODE_H__
#define __CELL_SYNC_RETURN_CODE_H__ 1

#include <cellstatus.h>
#include <cell/error.h>


#define CELL_SYNC_LFQUEUE_TERMINATED 2 // tentative!!
#define CELL_ERROR_MINOR_FACILITY_SYNC          0x1
#define CELL_ERROR_MAKE_SYNC_ERROR(id) \
	(CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, (CELL_ERROR_MINOR_FACILITY_SYNC << 8) | (id)))



#define CELL_SYNC_ERROR_AGAIN        CELL_ERROR_CAST(0x80410101) 
#define CELL_SYNC_ERROR_INVAL        CELL_ERROR_CAST(0x80410102) 
#define CELL_SYNC_ERROR_NOSYS        CELL_ERROR_CAST(0x80410103) 
#define CELL_SYNC_ERROR_NOMEM        CELL_ERROR_CAST(0x80410104) 
#define CELL_SYNC_ERROR_SRCH         CELL_ERROR_CAST(0x80410105) 
#define CELL_SYNC_ERROR_NOENT        CELL_ERROR_CAST(0x80410106) 
#define CELL_SYNC_ERROR_NOEXEC       CELL_ERROR_CAST(0x80410107) 
#define CELL_SYNC_ERROR_DEADLK       CELL_ERROR_CAST(0x80410108) 
#define CELL_SYNC_ERROR_PERM         CELL_ERROR_CAST(0x80410109) 
#define CELL_SYNC_ERROR_BUSY         CELL_ERROR_CAST(0x8041010A) 
#define CELL_SYNC_ERROR_ABORT        CELL_ERROR_CAST(0x8041010C) 
#define CELL_SYNC_ERROR_FAULT        CELL_ERROR_CAST(0x8041010D) 
#define CELL_SYNC_ERROR_CHILD        CELL_ERROR_CAST(0x8041010E) 
#define CELL_SYNC_ERROR_STAT         CELL_ERROR_CAST(0x8041010F) 
#define CELL_SYNC_ERROR_ALIGN        CELL_ERROR_CAST(0x80410110) 
#define CELL_SYNC_ERROR_NULL_POINTER CELL_ERROR_CAST(0x80410111) 
#define CELL_SYNC_ERROR_SHOTAGE      CELL_ERROR_CAST(0x80410112) 
#define CELL_SYNC_ERROR_UNKNOWNKEY   CELL_ERROR_CAST(0x80410113) 

#endif /* __CELL_SYNC_RETURN_CODE_H__ */
