/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __CELL_SSC_H__
#define __CELL_SSC_H__


/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       header files                                                         */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/

#include <stdint.h>
#include <stdio.h>
#include <stddef.h>
#include <stdbool.h>

#include <cell/spurs.h>
#include <cell/error.h>
#include <cell/gcm.h>

/********|*********|*********|*********|*********|*********|*********|*********/


/* for C++ */
#ifdef __cplusplus
extern "C" {
#endif


/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       status information for stereo-image converter                        */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
#define CELL_ERROR_FACILITY_THIS                 0x078
#define CELL_SSC_ERROR_CATEGORY_SPU              0x00

#define CELL_SSC_ERROR_CREATER(_category,_code) CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_THIS, ((_category)<<16)|(_code))
#define CELL_SSC_ERROR_CREATER_SPU(_code)       CELL_SSC_ERROR_CREATER(CELL_SSC_ERROR_CATEGORY_SPU, (_code))

/*****  for cellSscQueryAttr()  *****/
#define CELL_SSC_ERROR_Q_ARG_CFG_NULL            CELL_SSC_ERROR_CREATER_SPU( 0x10 )
#define CELL_SSC_ERROR_Q_ARG_CFG_INVALID         CELL_SSC_ERROR_CREATER_SPU( 0x11 )
#define CELL_SSC_ERROR_Q_ARG_ATTR_NULL           CELL_SSC_ERROR_CREATER_SPU( 0x14 )

/*****  for cellSscOpen()  *****/
#define CELL_SSC_ERROR_O_ARG_CFG_NULL            CELL_SSC_ERROR_CREATER_SPU( 0x20 )
#define CELL_SSC_ERROR_O_ARG_CFG_INVALID         CELL_SSC_ERROR_CREATER_SPU( 0x21 )
#define CELL_SSC_ERROR_O_ARG_RSRC_NULL           CELL_SSC_ERROR_CREATER_SPU( 0x22 )
#define CELL_SSC_ERROR_O_ARG_RSRC_INVALID        CELL_SSC_ERROR_CREATER_SPU( 0x23 )
#define CELL_SSC_ERROR_O_ARG_RSRCMEM_INVALID     CELL_SSC_ERROR_CREATER_SPU( 0x24 )
#define CELL_SSC_ERROR_O_ARG_RSRCSPU_INVALID     CELL_SSC_ERROR_CREATER_SPU( 0x25 )
#define CELL_SSC_ERROR_O_ARG_HDL_NULL            CELL_SSC_ERROR_CREATER_SPU( 0x26 )

#define CELL_SSC_ERROR_O_FATAL_CMUTEX            CELL_SSC_ERROR_CREATER_SPU( 0x27 )
#define CELL_SSC_ERROR_O_FATAL_CASYNCTHR         CELL_SSC_ERROR_CREATER_SPU( 0x28 )
#define CELL_SSC_ERROR_O_FATAL_CTASKSET          CELL_SSC_ERROR_CREATER_SPU( 0x29 )

/*****  for cellSscClose()  *****/
#define CELL_SSC_ERROR_C_ARG_HDL_NULL            CELL_SSC_ERROR_CREATER_SPU( 0x30 )
#define CELL_SSC_ERROR_C_ARG_HDL_INVALID         CELL_SSC_ERROR_CREATER_SPU( 0x31 )

#define CELL_SSC_ERROR_C_STAT_BUSY               CELL_SSC_ERROR_CREATER_SPU( 0x32 )

#define CELL_SSC_ERROR_C_FATAL_DTHR              CELL_SSC_ERROR_CREATER_SPU( 0x33 )
#define CELL_SSC_ERROR_C_FATAL_DMUTEX            CELL_SSC_ERROR_CREATER_SPU( 0x34 )
#define CELL_SSC_ERROR_C_FATAL_DTASKSET          CELL_SSC_ERROR_CREATER_SPU( 0x35 )

/*****  for cellSscExec/ExecAsync()  *****/
#define CELL_SSC_ERROR_E_ARG_HDL_NULL            CELL_SSC_ERROR_CREATER_SPU( 0x40 )
#define CELL_SSC_ERROR_E_ARG_HDL_INVALID         CELL_SSC_ERROR_CREATER_SPU( 0x41 )

#define CELL_SSC_ERROR_E_ARG_INPICBUF_INVALID    CELL_SSC_ERROR_CREATER_SPU( 0x42 )

#define CELL_SSC_ERROR_E_ARG_INPICINFO_NULL      CELL_SSC_ERROR_CREATER_SPU( 0x43 )
#define CELL_SSC_ERROR_E_ARG_INPICINFO_INVALID   CELL_SSC_ERROR_CREATER_SPU( 0x44 )

#define CELL_SSC_ERROR_E_ARG_TASKNUM_INVALID     CELL_SSC_ERROR_CREATER_SPU( 0x45 )
    
#define CELL_SSC_ERROR_E_ARG_CB_NULL             CELL_SSC_ERROR_CREATER_SPU( 0x46 )
#define CELL_SSC_ERROR_E_ARG_CB_INVALID          CELL_SSC_ERROR_CREATER_SPU( 0x47 )
    
#define CELL_SSC_ERROR_E_ARG_CTRL_NULL           CELL_SSC_ERROR_CREATER_SPU( 0x48 )
#define CELL_SSC_ERROR_E_ARG_CTRL_INVALID        CELL_SSC_ERROR_CREATER_SPU( 0x49 )
    
#define CELL_SSC_ERROR_E_ARG_LEFTPICBUF_INVALID  CELL_SSC_ERROR_CREATER_SPU( 0x4a )
#define CELL_SSC_ERROR_E_ARG_RIGHTPICBUF_INVALID CELL_SSC_ERROR_CREATER_SPU( 0x4b )

#define CELL_SSC_ERROR_E_ARG_SSCPICINFO_NULL     CELL_SSC_ERROR_CREATER_SPU( 0x4c )
#define CELL_SSC_ERROR_E_ARG_SSCPICINFO_INVALID  CELL_SSC_ERROR_CREATER_SPU( 0x4d )

#define CELL_SSC_ERROR_E_STAT_BUSY               CELL_SSC_ERROR_CREATER_SPU( 0x50 )

#define CELL_SSC_ERROR_E_FATAL_TASK              CELL_SSC_ERROR_CREATER_SPU( 0x51 )
#define CELL_SSC_ERROR_E_FATAL_ASYNCTHR          CELL_SSC_ERROR_CREATER_SPU( 0x52 )
#define CELL_SSC_ERROR_E_FATAL_MUTEX             CELL_SSC_ERROR_CREATER_SPU( 0x53 )

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       status information for stereo-image converter                        */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
#define CELL_ERROR_FACILITY_THIS                 0x078
#define CELL_SSC_ERROR_CATEGORY_GPU              0x01

#define CELL_SSC_ERROR_CREATER(_category,_code) CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_THIS, ((_category)<<16)|(_code))
#define CELL_SSC_ERROR_CREATER_GPU(_code)       CELL_SSC_ERROR_CREATER(CELL_SSC_ERROR_CATEGORY_GPU, (_code))

/*****  for cellSscGpuQueryAttr()  *****/
#define CELL_SSC_GPU_ERROR_Q_ARG_ATTR_NULL            CELL_SSC_ERROR_CREATER_GPU( 0x10 )

/*****  for cellSscGpuOpen()  *****/
#define CELL_SSC_GPU_ERROR_O_ARG_RSRC_NULL            CELL_SSC_ERROR_CREATER_GPU( 0x20 )
#define CELL_SSC_GPU_ERROR_O_ARG_RSRC_INVALID         CELL_SSC_ERROR_CREATER_GPU( 0x21 )
#define CELL_SSC_GPU_ERROR_O_ARG_HDL_NULL             CELL_SSC_ERROR_CREATER_GPU( 0x22 )
#define CELL_SSC_GPU_ERROR_O_ARG_RSRCMEM_INVALID      CELL_SSC_ERROR_CREATER_GPU( 0x23 )

/*****  for cellSscGpuClose()  *****/
#define CELL_SSC_GPU_ERROR_C_ARG_HDL_NULL             CELL_SSC_ERROR_CREATER_GPU( 0x30 )
#define CELL_SSC_GPU_ERROR_C_ARG_HDL_INVALID          CELL_SSC_ERROR_CREATER_GPU( 0x31 )
#define CELL_SSC_GPU_ERROR_C_SEQ                      CELL_SSC_ERROR_CREATER_GPU( 0x32 )
    
/*****  for cellSscExec()  *****/
#define CELL_SSC_GPU_ERROR_E_ARG_CONTEXT_NULL         CELL_SSC_ERROR_CREATER_GPU( 0x40 )
#define CELL_SSC_GPU_ERROR_E_ARG_HDL_NULL             CELL_SSC_ERROR_CREATER_GPU( 0x41 )
#define CELL_SSC_GPU_ERROR_E_ARG_HDL_INVALID          CELL_SSC_ERROR_CREATER_GPU( 0x42 )
#define CELL_SSC_GPU_ERROR_E_ARG_INPICINFO_NULL       CELL_SSC_ERROR_CREATER_GPU( 0x43 )
#define CELL_SSC_GPU_ERROR_E_ARG_INPICINFO_INVALID    CELL_SSC_ERROR_CREATER_GPU( 0x44 )
#define CELL_SSC_GPU_ERROR_E_ARG_CTRL_NULL            CELL_SSC_ERROR_CREATER_GPU( 0x45 )
#define CELL_SSC_GPU_ERROR_E_ARG_CTRL_INVALID         CELL_SSC_ERROR_CREATER_GPU( 0x46 )
#define CELL_SSC_GPU_ERROR_E_ARG_SURFACEINFO_NULL     CELL_SSC_ERROR_CREATER_GPU( 0x47 )
#define CELL_SSC_GPU_ERROR_E_ARG_SURFACEINFO_INVALID  CELL_SSC_ERROR_CREATER_GPU( 0x48 )
#define CELL_SSC_GPU_ERROR_E_ARG_OUTPICINFO_NULL      CELL_SSC_ERROR_CREATER_GPU( 0x49 )
#define CELL_SSC_GPU_ERROR_E_ARG_LEFTPICINFO_INVALID  CELL_SSC_ERROR_CREATER_GPU( 0x4a )
#define CELL_SSC_GPU_ERROR_E_ARG_RIGHTPICINFO_INVALID CELL_SSC_ERROR_CREATER_GPU( 0x4b )
#define CELL_SSC_GPU_ERROR_E_SEQ                      CELL_SSC_ERROR_CREATER_GPU( 0x4c )

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       spu/gpu common parameter                                             */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/

typedef enum {

    CELL_SSC_DEPTH_TYPE_UNDEF = 0,
    CELL_SSC_DEPTH_TYPE_WEAK,
    CELL_SSC_DEPTH_TYPE_MEDIUM,
    CELL_SSC_DEPTH_TYPE_STRONG,
    CELL_SSC_DEPTH_TYPE_VERY_STRONG,
    CELL_SSC_DEPTH_TYPE_USER_CONTROL = 255,
    
} CellSscDepthType;

typedef struct {
    
    CellSscDepthType        depthType;
    float                   screenSize;
    float                   globalDepth1;
    float                   globalDepth2;
    float                   localDepth1;
    float                   localDepth2;
    float                   shift;
    int32_t                 sidepanel;

} CellSscCtrlParam;

    
/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       handle                                                               */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef void* CellSscHandle;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       callback                                                             */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef enum {
    CELL_SSC_MSG_DONE,
    CELL_SSC_MSG_FATAL_ERR,

} CellSscMsgType;

typedef void
( * CellSscCbMessage ) (
    const CellSscHandle  handle,
    const CellSscMsgType msg,
          void           *cbArg   );

typedef struct {
    CellSscCbMessage cbFunc;
    void *cbArg;
    
} CellSscCb;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       configuration                                                        */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef enum {
    CELL_SSC_TYPE_UNDEF   = 0,
    CELL_SSC_TYPE_1,
    
} CellSscType;

typedef struct {
    uint32_t maxWidth;            /* maximum width  */
    uint32_t maxHeight;           /* maximum height */
    CellSscType type;             /* algorithm type */
    
} CellSscCfgParam;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       attribute                                                            */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef struct {
    size_t   memSize;

} CellSscAttr;
    
/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       resource                                                             */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef struct {
    sys_addr_t  memAddr;          /* start address of allocated memory */
    size_t      memSize;          /* size of allocated memory          */
    CellSpurs   *spurs;           /* pointer to SPURS instance         */
    uint32_t    thrPriority;      /* async thread priority             */
    uint32_t    thrStackSize;     /* async thread stack size           */
    uint8_t     spuPriority[ 8 ]; /* spu priority                      */
    uint32_t    maxContention;    /* max usable spu num                */
    
} CellSscResource;

    
/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       picture information                                                  */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef enum {
    CELL_SSC_PICTURE_FORMAT_UNDEF  = 0,
    CELL_SSC_PICTURE_FORMAT_YUV420 = 1,
    CELL_SSC_PICTURE_FORMAT_ARGB   = 11,
    CELL_SSC_PICTURE_FORMAT_RGBA,
    
} CellSscPictureFormat;
    
typedef struct {
    uint32_t width;
    uint32_t height;
    uint32_t pitch;
    CellSscPictureFormat format;
    
} CellSscPictureInfo;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       API                                                                  */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
int32_t cellSscQueryAttr (
    const CellSscCfgParam    *pCfg,
          CellSscAttr        *pAttr
);

int32_t cellSscOpen (
    const CellSscCfgParam    *pCfg,
    const CellSscResource    *pRsrc,
          CellSscHandle      *pHandle
);

int32_t cellSscClose ( 
    const CellSscHandle       handle
);


int32_t cellSscExec (
    const CellSscHandle       handle,
    const CellSscPictureInfo *pInPicInfo,
    const uint64_t            pInPicBuff,
    const uint32_t            taskNum,
    const CellSscCtrlParam   *pCtrl,
    const CellSscPictureInfo *pOutPicInfo,
    const uint64_t            pLeftPicBuff,
    const uint64_t            pRightPicBuff
);

int32_t cellSscExecAsync (
    const CellSscHandle       handle,
    const CellSscPictureInfo *pInPicInfo,
    const uint64_t            pInPicBuff,
    const uint32_t            taskNum,
    const CellSscCb          *pCb,
    const CellSscCtrlParam   *pCtrl,
    const CellSscPictureInfo *pOutPicInfo,
    const uint64_t            pLeftPicBuff,
    const uint64_t            pRightPicBuff
);


/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       handle                                                               */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef void* CellSscGpuHandle;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       attribute                                                            */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef struct {
    size_t   mainMemSize;
    size_t   localMemSize;

} CellSscGpuAttr;
    
/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       resource                                                             */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef struct {
    sys_addr_t  mainMemAddr;      /* start address of allocated memory */
    size_t      mainMemSize;      /* size of allocated memory          */
    sys_addr_t  localMemAddr;     /* start address of allocated memory */
    size_t      localMemSize;     /* size of allocated memory          */
} CellSscGpuResource;

/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       picture information                                                  */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
typedef struct {
    uint8_t  format;
    uint32_t remap;
    uint16_t width;
    uint16_t height;
    uint8_t  location;
    uint32_t pitch;
    uint32_t offset;

} CellSscGpuInputPictureInfo;

typedef struct {
    uint8_t  type;
    uint8_t  colorFormat;
    uint8_t  colorLocation;
    uint32_t colorOffset;
    uint32_t colorPitch;
    uint16_t width;
    uint16_t height;
    uint16_t x;
    uint16_t y;

} CellSscGpuOutputSurface;

typedef struct {
    uint16_t x;
    uint16_t y;
    uint16_t width;
    uint16_t height;

} CellSscGpuOutputInfo;


/********|*********|*********|*********|*********|*********|*********|*********/
/*                                                                            */
/*       API                                                                  */
/*                                                                            */
/********|*********|*********|*********|*********|*********|*********|*********/
int32_t cellSscGpuQueryAttr (
          CellSscGpuAttr        *pAttr
);

int32_t cellSscGpuOpen (
    const CellSscGpuResource *pRsrc,
          CellSscGpuHandle   *pHandle
);

int32_t cellSscGpuClose ( 
          CellSscGpuHandle    handle
);
    
int32_t cellSscGpuExec (
          CellGcmContextData          *thisContext,
          CellSscGpuHandle             handle,
    const CellSscGpuInputPictureInfo  *pInPicInfo,
    const CellSscCtrlParam            *pCtrl,
    const CellSscGpuOutputSurface     *pOutSurface,
    const CellSscGpuOutputInfo        *pOutInfoL,
    const CellSscGpuOutputInfo        *pOutInfoR
);

int32_t cellSscGpuExecUnsafe (
          CellGcmContextData          *thisContext,
          CellSscGpuHandle             handle,
    const CellSscGpuInputPictureInfo  *pInPicInfo,
    const CellSscCtrlParam            *pCtrl,
    const CellSscGpuOutputSurface     *pOutSurface,
    const CellSscGpuOutputInfo        *pOutInfoL,
    const CellSscGpuOutputInfo        *pOutInfoR
);

int32_t cellSscGpuExecMeasure (
          CellGcmContextData          *thisContext,
          CellSscGpuHandle             handle,
    const CellSscGpuInputPictureInfo  *pInPicInfo,
    const CellSscCtrlParam            *pCtrl,
    const CellSscGpuOutputSurface     *pOutSurface,
    const CellSscGpuOutputInfo        *pOutInfoL,
    const CellSscGpuOutputInfo        *pOutInfoR
);

int32_t cellSscGpuExecMeasureSize (
    const int32_t                      size,
          CellSscGpuHandle             handle,
    const CellSscGpuInputPictureInfo  *pInPicInfo,
    const CellSscCtrlParam            *pCtrl,
    const CellSscGpuOutputSurface     *pOutSurface,
    const CellSscGpuOutputInfo        *pOutInfoL,
    const CellSscGpuOutputInfo        *pOutInfoR
);

    
/********|*********|*********|*********|*********|*********|*********|*********/


/* for C++ */
#ifdef __cplusplus
}
#endif


/********|*********|*********|*********|*********|*********|*********|*********/


#endif  /* __CELL_SSC_H__ */
