/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2010 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_JOBQUEUE_PORT2_H__
#define __CELL_SPURS_JOBQUEUE_PORT2_H__

/* standard C++ header */
#include <stdint.h>
#include <stdbool.h>
#include <stddef.h> /* size_t */

/* spurs */
#include <cell/spurs/job_descriptor.h>

/* job queue */
#include <cell/spurs/job_queue.h>
#include <cell/spurs/job_queue_port2_types.h>

#ifdef __cplusplus
extern "C" {
#endif
	/* APIs for CellSpursJobQueuePort2 */
	/* get information */
	CellSpursJobQueue*	cellSpursJobQueuePort2GetJobQueue(const CellSpursJobQueuePort2 *pPort2);

	int cellSpursJobQueuePort2Create(CellSpursJobQueuePort2 *eaPort2, CellSpursJobQueue *eaJobQueue);
	int cellSpursJobQueuePort2Destroy(CellSpursJobQueuePort2 *eaPort2);

	int _cellSpursJobQueuePort2PushJobBody(CellSpursJobQueuePort2 *eaPort2, CellSpursJobHeader *eaJob, size_t sizeDesc, unsigned tag, unsigned flag);
	int _cellSpursJobQueuePort2CopyPushJobBody(CellSpursJobQueuePort2 *eaPort2, const CellSpursJobHeader *pJob, size_t sizeDesc, size_t sizeDescFromPool, unsigned tag, unsigned flag);
	int _cellSpursJobQueuePort2PushJobListBody(CellSpursJobQueuePort2 *eaPort2, CellSpursJobList *eaJobList, unsigned tag, unsigned flag);
	int _cellSpursJobQueuePort2PushAndReleaseJobBody(CellSpursJobQueuePort2 *eaPort2, CellSpursJobHeader *eaJob, size_t sizeDesc, unsigned tag, unsigned flag);

	static inline int cellSpursJobQueuePort2PushJob(CellSpursJobQueuePort2 *eaPort2, CellSpursJobHeader *eaJob, size_t sizeDesc, unsigned tag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)eaJob, sizeDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePort2GetJobQueue(eaPort2))));
#endif
		if (eaPort2 == NULL) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if ((uintptr_t)eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueuePort2PushJobBody(eaPort2, eaJob, sizeDesc, tag, flag);
	}

	static inline int cellSpursJobQueuePort2CopyPushJob(CellSpursJobQueuePort2 *eaPort2, const CellSpursJobHeader *eaJob, size_t sizeDesc, size_t sizeDescFromPool, unsigned tag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)eaJob, sizeDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePort2GetJobQueue(eaPort2))));
#endif
		if (eaPort2 == NULL) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if ((uintptr_t)eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueuePort2CopyPushJobBody(eaPort2, eaJob, sizeDesc, sizeDescFromPool, tag, flag);
	}

	static inline int cellSpursJobQueuePort2PushJobList(CellSpursJobQueuePort2 *eaPort2, CellSpursJobList *eaJobList, unsigned tag, unsigned flag){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		for(unsigned index = 0; index < eaJobList->numJobs; index++) {
			CellSpursJob256*	eaJob = (CellSpursJob256*)(uintptr_t)(eaJobList->eaJobList + eaJobList->sizeOfJob * index);
			__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)eaJob, eaJobList->sizeOfJob, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePort2GetJobQueue(eaPort2))));
		}
#endif
		if (eaPort2 == NULL) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if ((uintptr_t)eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueuePort2PushJobListBody(eaPort2, eaJobList, tag, flag);
	}

	static inline int cellSpursJobQueuePort2PushAndReleaseJob(CellSpursJobQueuePort2 *eaPort2, CellSpursJobHeader *eaJob, size_t sizeDesc, unsigned tag, unsigned flag) {
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)eaJob, sizeDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePort2GetJobQueue(eaPort2))));
#endif
		if (eaPort2 == NULL) {
			return CELL_SPURS_JOB_ERROR_NULL_POINTER;
		}
		if ((uintptr_t)eaPort2 % CELL_SPURS_JOBQUEUE_PORT2_ALIGN) {
			return CELL_SPURS_JOB_ERROR_ALIGN;
		}
		return _cellSpursJobQueuePort2PushAndReleaseJobBody(eaPort2, eaJob, sizeDesc, tag, flag);
	}

	int cellSpursJobQueuePort2AllocateJobDescriptor(CellSpursJobQueuePort2 *eaPort2, size_t sizeDesc, unsigned flag, CellSpursJobHeader **eaAllocatedJobDesc);
	int cellSpursJobQueuePort2Sync(CellSpursJobQueuePort2 *eaPort2, unsigned flag);
	int cellSpursJobQueuePort2PushFlush(CellSpursJobQueuePort2 *eaPort2, unsigned flag);
	int cellSpursJobQueuePort2PushSync(CellSpursJobQueuePort2 *eaPort2, unsigned tagMask, unsigned flag);
	
#ifdef __cplusplus
}
#endif

#include <cell/spurs/job_queue_port2_cpp_types.h>

#endif /* __CELL_SPURS_JOBQUEUE_PORT2_H__ */
