/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2009 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_JOBQUEUE_PORT_H__
#define __CELL_SPURS_JOBQUEUE_PORT_H__

/* standard C++ header */
#include <stdint.h>
#include <stdbool.h>
#include <stddef.h> /* size_t */

/* spurs */
#include <cell/spurs/job_descriptor.h>

/* job queue */
#include <cell/spurs/job_queue.h>
#include <cell/spurs/job_queue_port_types.h>

#ifdef __cplusplus
extern "C" {
#endif
	/* APIs for CellSpursJobQueuePort */
	/* get information */
	CellSpursJobQueue*	cellSpursJobQueuePortGetJobQueue(const CellSpursJobQueuePort *pPort);

	int	cellSpursJobQueuePortInitialize(CellSpursJobQueuePort *pPort, CellSpursJobQueue *pJobQueue, bool isMTSafe);
	int	cellSpursJobQueuePortInitializeWithDescriptorBuffer(CellSpursJobQueuePort *pPort, CellSpursJobQueue *pJobQueue, CellSpursJobHeader* buffer, size_t sizeDescriptor, unsigned numEntries, bool isMTSafe);
	int cellSpursJobQueuePortFinalize(CellSpursJobQueuePort *pPort);

	int _cellSpursJobQueuePortPushBody(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync, bool isBlocking);
	int _cellSpursJobQueuePortCopyPushBody(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync, bool isBlocking);

	int _cellSpursJobQueuePortPushJobBody(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync, bool isBlocking);
	int _cellSpursJobQueuePortPushJobBody2(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync, bool isExclusive, bool isBlocking);
	int _cellSpursJobQueuePortCopyPushJobBody(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync, bool isBlocking);
	int _cellSpursJobQueuePortCopyPushJobBody2(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync, bool isExclusive, bool isBlocking);

	int _cellSpursJobQueuePortPushJobListBody(CellSpursJobQueuePort *pPort, CellSpursJobList *pJobList, unsigned tag, bool isSync, bool isBlocking);




	/* external push interfaces */

	static inline int cellSpursJobQueuePortPush(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushBody(pPort, pJob, sizeJobDesc, isSync, 1);
	}

	static inline int cellSpursJobQueuePortTryPush(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushBody(pPort, pJob, sizeJobDesc, isSync, 0);
	}

	static inline int cellSpursJobQueuePortCopyPush(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushBody(pPort, pJob, sizeJobDesc, isSync, 1);
	}

	static inline int cellSpursJobQueuePortTryCopyPush(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushBody(pPort, pJob, sizeJobDesc, isSync, 0);
	}

	static inline int cellSpursJobQueuePortPushJob(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, false, 1);
	}

	static inline int cellSpursJobQueuePortPushExclusiveJob(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, true, 1);
	}

	static inline int cellSpursJobQueuePortTryPushJob(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, false, 0);
	}

	static inline int cellSpursJobQueuePortTryPushExclusiveJob(CellSpursJobQueuePort *pPort, CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, true, 0);
	}

	static inline int cellSpursJobQueuePortCopyPushJob(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, false, 1);
	}

	static inline int cellSpursJobQueuePortCopyPushExclusiveJob(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, true, 1);
	}

	static inline int cellSpursJobQueuePortTryCopyPushJob(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, false, 0);
	}

	static inline int cellSpursJobQueuePortTryCopyPushExclusiveJob(CellSpursJobQueuePort *pPort, const CellSpursJobHeader *pJob, size_t sizeJobDesc, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)(uintptr_t)pJob, sizeJobDesc, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
#endif
		return _cellSpursJobQueuePortCopyPushJobBody2(pPort, pJob, sizeJobDesc, tag, isSync, true, 0);
	}

	static inline int cellSpursJobQueuePortPushJobList(CellSpursJobQueuePort *pPort, CellSpursJobList *pJobList, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		for(unsigned index = 0; index < pJobList->numJobs; index++) {
			CellSpursJob256*	pJob = (CellSpursJob256*)(uintptr_t)(pJobList->eaJobList + pJobList->sizeOfJob * index);
			__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)pJob, pJobList->sizeOfJob, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
		}
#endif
		return _cellSpursJobQueuePortPushJobListBody(pPort, pJobList, tag, isSync, 1);
	}

	static inline int cellSpursJobQueuePortTryPushJobList(CellSpursJobQueuePort *pPort, CellSpursJobList *pJobList, unsigned tag, bool isSync){
#ifdef CELL_SPURS_JOBDESCRIPTOR_ERROR_CHECK
		for(unsigned index = 0; index < pJobList->numJobs; index++) {
			CellSpursJob256*	pJob = (CellSpursJob256*)(uintptr_t)pJobList->eaJobList + pJobList->sizeOfJob * index;
			__CELL_SPURS_RETURN_IF(cellSpursJobQueueCheckJob((const CellSpursJob256 *)pJob, pJobList->sizeOfJob, cellSpursJobQueueGetMaxSizeJobDescriptor(cellSpursJobQueuePortGetJobQueue(pPort))));
		}
#endif
		return _cellSpursJobQueuePortPushJobListBody(pPort, pJobList, tag, isSync, 0);
	}

	int cellSpursJobQueuePortSync(CellSpursJobQueuePort *pPort);
	int cellSpursJobQueuePortTrySync(CellSpursJobQueuePort *pPort);

	int _cellSpursJobQueuePortPushFlush(CellSpursJobQueuePort *pPort, bool isBlocking);
	static inline int cellSpursJobQueuePortPushFlush(CellSpursJobQueuePort *pPort) {
		return _cellSpursJobQueuePortPushFlush(pPort, true);
	}
	static inline int cellSpursJobQueuePortTryPushFlush(CellSpursJobQueuePort *pPort) {
		return _cellSpursJobQueuePortPushFlush(pPort, false);
	}
	
	int _cellSpursJobQueuePortPushSync(CellSpursJobQueuePort *pPort, unsigned tagMask, bool isBlocking);
	static inline int cellSpursJobQueuePortPushSync(CellSpursJobQueuePort *pPort, unsigned tagMask) {
		return _cellSpursJobQueuePortPushSync(pPort, tagMask, true);
	}
	static inline int cellSpursJobQueuePortTryPushSync(CellSpursJobQueuePort *pPort, unsigned tag) {
		return _cellSpursJobQueuePortPushSync(pPort, tag, false);
	}
	
#ifdef __cplusplus
}
#endif

#include <cell/spurs/job_queue_port_cpp_types.h>

#endif /* __CELL_SPURS_JOBQUEUE_PORT_H__ */
