/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001 
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _MULTISTREAM_MP3_PPULIB_H_
#define _MULTISTREAM_MP3_PPULIB_H_


#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif


typedef struct CellMSMP3Context
{
	float decodeBuff[544];
	float oldBlock[576];
	char  oldFrame[512];
} CellMSMP3Context;


////////////////////////////////////////////////////////////////////////////////////////////////////
// cellMSMP3IntegratedDecoderGetRequiredSize
////////////////////////////////////////////////////////////////////////////////////////////////////
// Calculates the required size of RAM needed for an integrated MP3 decoder
//
// Requires:
//	int *pnSize		Pointer to an int, which will contain the size (in bytes) of a buffer for initialization
//
// Returns:
//	 0 = OK
//	-1 = Failed
////////////////////////////////////////////////////////////////////////////////////////////////////
int cellMSMP3IntegratedDecoderGetRequiredSize( int* pnSize );

////////////////////////////////////////////////////////////////////////////////////////////////////
// cellMSMP3IntegratedDecoderInit
////////////////////////////////////////////////////////////////////////////////////////////////////
// Initializes the integrated MP3 decoder
//
// Requires:
// void * pDecoderMem		Pointer to a decoder work buffer (user must allocate this). Must be 128 bytes aligned
// int nDecoderMemSize		Size of decoder work buffer (calculated by cellMSMP3IntegratedDecoderGetRequiredSize)
// 
// Returns:
//   0 = OK
//  <0 = Failed
//  -1 = pDecoderMem = NULL or invalid size
//  -2 = pDecoderMem is not 128 bytes aligned
//  -3 = Error initializing MP3 codec.
////////////////////////////////////////////////////////////////////////////////////////////////////
int cellMSMP3IntegratedDecoderInit( void* pDecoderMem, const int nDecoderMemSize );




#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif

#endif //_MULTISTREAM_MP3_PPULIB_H_

