/*  SCE CONFIDENTIAL                                      */
/*  PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*  Copyright (C) 2006 Sony Computer Entertainment Inc.   */
/*  All Rights Reserved.                                  */
#ifndef __CELL_HTTP_NET_ERROR_H__
#define __CELL_HTTP_NET_ERROR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*E For these Network related errors, the last two digits
 *  will further describe the network error, which comes from the
 *  network socket API's errno or h_errno, in the case of the resolver.
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0100) */
/*
 * #define CELL_HTTP_ERROR_NET_RESOLVER             CELL_ERROR_CAST(0x80710100)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_NETDB_INTERNAL) */
#define CELL_HTTP_ERROR_NET_RESOLVER_NETDB_INTERNAL CELL_ERROR_CAST(0x807101ff)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_HOST_NOT_FOUND) */
#define CELL_HTTP_ERROR_NET_RESOLVER_HOST_NOT_FOUND CELL_ERROR_CAST(0x80710101)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_TRY_AGAIN) */
#define CELL_HTTP_ERROR_NET_RESOLVER_TRY_AGAIN      CELL_ERROR_CAST(0x80710102)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_NO_RECOVERY) */
#define CELL_HTTP_ERROR_NET_RESOLVER_NO_RECOVERY    CELL_ERROR_CAST(0x80710103)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_NO_DATA) */
#define CELL_HTTP_ERROR_NET_RESOLVER_NO_DATA        CELL_ERROR_CAST(0x80710104)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RESOLVER, SYS_NET_NO_ADDRESS) */
#define CELL_HTTP_ERROR_NET_RESOLVER_NO_ADDRESS     CELL_ERROR_CAST(0x80710104)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0200) */
/*
 * #define CELL_HTTP_ERROR_NET_ABORT                CELL_ERROR_CAST(0x80710200)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_ABORT_EPERM             CELL_ERROR_CAST(0x80710201)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOENT            CELL_ERROR_CAST(0x80710202)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_ABORT_ESRCH             CELL_ERROR_CAST(0x80710203)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_ABORT_EINTR             CELL_ERROR_CAST(0x80710204)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_ABORT_EIO               CELL_ERROR_CAST(0x80710205)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_ABORT_ENXIO             CELL_ERROR_CAST(0x80710206)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_ABORT_E2BIG             CELL_ERROR_CAST(0x80710207)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOEXC            CELL_ERROR_CAST(0x80710208)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_ABORT_EBADF             CELL_ERROR_CAST(0x80710209)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_ABORT_ECHILD            CELL_ERROR_CAST(0x8071020a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_ABORT_EDEADLK           CELL_ERROR_CAST(0x8071020b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOMEM            CELL_ERROR_CAST(0x8071020c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_ABORT_EACCES            CELL_ERROR_CAST(0x8071020d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_ABORT_EFAULT            CELL_ERROR_CAST(0x8071020e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTBLK           CELL_ERROR_CAST(0x8071020f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_ABORT_EBUSY             CELL_ERROR_CAST(0x80710210)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_ABORT_EEXIST            CELL_ERROR_CAST(0x80710211)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_ABORT_EXDEV             CELL_ERROR_CAST(0x80710212)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_ABORT_ENODEV            CELL_ERROR_CAST(0x80710213)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTDIR           CELL_ERROR_CAST(0x80710214)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_ABORT_EISDIR            CELL_ERROR_CAST(0x80710215)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_ABORT_EINVAL            CELL_ERROR_CAST(0x80710216)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_ABORT_ENFILE            CELL_ERROR_CAST(0x80710217)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_ABORT_EMFILE            CELL_ERROR_CAST(0x80710218)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTTY            CELL_ERROR_CAST(0x80710219)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_ABORT_ETXTBSY           CELL_ERROR_CAST(0x8071021a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_ABORT_EFBIG             CELL_ERROR_CAST(0x8071021b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOSPC            CELL_ERROR_CAST(0x8071021c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_ABORT_ESPIPE            CELL_ERROR_CAST(0x8071021d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_ABORT_EROFS             CELL_ERROR_CAST(0x8071021e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_ABORT_EMLINK            CELL_ERROR_CAST(0x8071021f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_ABORT_EPIPE             CELL_ERROR_CAST(0x80710220)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_ABORT_EDOM              CELL_ERROR_CAST(0x80710221)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_ABORT_ERANGE            CELL_ERROR_CAST(0x80710222)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_ABORT_EAGAIN            CELL_ERROR_CAST(0x80710223)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_ABORT_EWOULDBLOCK       CELL_ERROR_CAST(0x80710223)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_ABORT_EINPROGRESS       CELL_ERROR_CAST(0x80710224)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_ABORT_EALREADY          CELL_ERROR_CAST(0x80710225)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTSOCK          CELL_ERROR_CAST(0x80710226)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_ABORT_EDESTADDRREQ      CELL_ERROR_CAST(0x80710227)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_ABORT_EMSGSIZE          CELL_ERROR_CAST(0x80710228)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROTOTYPE        CELL_ERROR_CAST(0x80710229)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOPROTOOPT       CELL_ERROR_CAST(0x8071022a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROTONOSUPPORT   CELL_ERROR_CAST(0x8071022b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_ABORT_ESOCKTNOSUPPORT   CELL_ERROR_CAST(0x8071022c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_ABORT_EOPNOTSUPP        CELL_ERROR_CAST(0x8071022d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_ABORT_EPFNOSUPPORT      CELL_ERROR_CAST(0x8071022e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_ABORT_EAFNOSUPPORT      CELL_ERROR_CAST(0x8071022f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_ABORT_EADDRINUSE        CELL_ERROR_CAST(0x80710230)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_ABORT_EADDRNOTAVAIL     CELL_ERROR_CAST(0x80710231)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_ABORT_ENETDOWN          CELL_ERROR_CAST(0x80710232)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_ABORT_ENETUNREACH       CELL_ERROR_CAST(0x80710233)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_ABORT_ENETRESET         CELL_ERROR_CAST(0x80710234)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_ABORT_ECONNABORTED      CELL_ERROR_CAST(0x80710235)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_ABORT_ECONNRESET        CELL_ERROR_CAST(0x80710236)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOBUFS           CELL_ERROR_CAST(0x80710237)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_ABORT_EISCONN           CELL_ERROR_CAST(0x80710238)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTCONN          CELL_ERROR_CAST(0x80710239)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_ABORT_ESHUTDOWN         CELL_ERROR_CAST(0x8071023a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_ABORT_ETOOMANYREFS      CELL_ERROR_CAST(0x8071023b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_ABORT_ETIMEDOUT         CELL_ERROR_CAST(0x8071023c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_ABORT_ECONNREFUSED      CELL_ERROR_CAST(0x8071023d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_ABORT_ELOOP             CELL_ERROR_CAST(0x8071023e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_ABORT_ENAMETOOLONG      CELL_ERROR_CAST(0x8071023f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_ABORT_EHOSTDOWN         CELL_ERROR_CAST(0x80710240)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_ABORT_EHOSTUNREACH      CELL_ERROR_CAST(0x80710241)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTEMPTY         CELL_ERROR_CAST(0x80710242)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROCLIM          CELL_ERROR_CAST(0x80710243)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_ABORT_EUSERS            CELL_ERROR_CAST(0x80710244)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_ABORT_EDQUOT            CELL_ERROR_CAST(0x80710245)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_ABORT_ESTALE            CELL_ERROR_CAST(0x80710246)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_ABORT_EREMOTE           CELL_ERROR_CAST(0x80710247)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_ABORT_EBADRPC           CELL_ERROR_CAST(0x80710248)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_ABORT_ERPCMISMATCH      CELL_ERROR_CAST(0x80710249)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROGUNAVAIL      CELL_ERROR_CAST(0x8071024a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROGMISMATCH     CELL_ERROR_CAST(0x8071024b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_ABORT_EPROCUNAVAIL      CELL_ERROR_CAST(0x8071024c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOLCK            CELL_ERROR_CAST(0x8071024d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOSYS            CELL_ERROR_CAST(0x8071024e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_ABORT_EFTYPE            CELL_ERROR_CAST(0x8071024f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_ABORT_EAUTH             CELL_ERROR_CAST(0x80710250)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_ABORT_ENEEDAUTH         CELL_ERROR_CAST(0x80710251)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_ABORT_EIDRM             CELL_ERROR_CAST(0x80710252)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOMSG            CELL_ERROR_CAST(0x80710253)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_ABORT_EOVERFLOW         CELL_ERROR_CAST(0x80710254)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_ABORT_EILSEQ            CELL_ERROR_CAST(0x80710255)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOTSUP           CELL_ERROR_CAST(0x80710256)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_ABORT_ECANCELED         CELL_ERROR_CAST(0x80710257)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_ABORT_EBADMSG           CELL_ERROR_CAST(0x80710258)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_ABORT_ENODATA           CELL_ERROR_CAST(0x80710259)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOSR             CELL_ERROR_CAST(0x8071025a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_ABORT_ENOSTR            CELL_ERROR_CAST(0x8071025b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_ABORT_ETIME             CELL_ERROR_CAST(0x8071025c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0300) */
/*
 * #define CELL_HTTP_ERROR_NET_OPTION               CELL_ERROR_CAST(0x80710300)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_OPTION_EPERM            CELL_ERROR_CAST(0x80710301)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOENT           CELL_ERROR_CAST(0x80710302)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_OPTION_ESRCH            CELL_ERROR_CAST(0x80710303)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_OPTION_EINTR            CELL_ERROR_CAST(0x80710304)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_OPTION_EIO              CELL_ERROR_CAST(0x80710305)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_OPTION_ENXIO            CELL_ERROR_CAST(0x80710306)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_OPTION_E2BIG            CELL_ERROR_CAST(0x80710307)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOEXC           CELL_ERROR_CAST(0x80710308)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_OPTION_EBADF            CELL_ERROR_CAST(0x80710309)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_OPTION_ECHILD           CELL_ERROR_CAST(0x8071030a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_OPTION_EDEADLK          CELL_ERROR_CAST(0x8071030b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOMEM           CELL_ERROR_CAST(0x8071030c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_OPTION_EACCES           CELL_ERROR_CAST(0x8071030d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_OPTION_EFAULT           CELL_ERROR_CAST(0x8071030e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTBLK          CELL_ERROR_CAST(0x8071030f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_OPTION_EBUSY            CELL_ERROR_CAST(0x80710310)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_OPTION_EEXIST           CELL_ERROR_CAST(0x80710311)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_OPTION_EXDEV            CELL_ERROR_CAST(0x80710312)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_OPTION_ENODEV           CELL_ERROR_CAST(0x80710313)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTDIR          CELL_ERROR_CAST(0x80710314)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_OPTION_EISDIR           CELL_ERROR_CAST(0x80710315)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_OPTION_EINVAL           CELL_ERROR_CAST(0x80710316)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_OPTION_ENFILE           CELL_ERROR_CAST(0x80710317)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_OPTION_EMFILE           CELL_ERROR_CAST(0x80710318)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTTY           CELL_ERROR_CAST(0x80710319)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_OPTION_ETXTBSY          CELL_ERROR_CAST(0x8071031a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_OPTION_EFBIG            CELL_ERROR_CAST(0x8071031b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOSPC           CELL_ERROR_CAST(0x8071031c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_OPTION_ESPIPE           CELL_ERROR_CAST(0x8071031d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_OPTION_EROFS            CELL_ERROR_CAST(0x8071031e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_OPTION_EMLINK           CELL_ERROR_CAST(0x8071031f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_OPTION_EPIPE            CELL_ERROR_CAST(0x80710320)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_OPTION_EDOM             CELL_ERROR_CAST(0x80710321)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_OPTION_ERANGE           CELL_ERROR_CAST(0x80710322)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_OPTION_EAGAIN           CELL_ERROR_CAST(0x80710323)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_OPTION_EWOULDBLOCK      CELL_ERROR_CAST(0x80710323)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_OPTION_EINPROGRESS      CELL_ERROR_CAST(0x80710324)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_OPTION_EALREADY         CELL_ERROR_CAST(0x80710325)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTSOCK         CELL_ERROR_CAST(0x80710326)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_OPTION_EDESTADDRREQ     CELL_ERROR_CAST(0x80710327)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_OPTION_EMSGSIZE         CELL_ERROR_CAST(0x80710328)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROTOTYPE       CELL_ERROR_CAST(0x80710329)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOPROTOOPT      CELL_ERROR_CAST(0x8071032a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROTONOSUPPORT  CELL_ERROR_CAST(0x8071032b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_OPTION_ESOCKTNOSUPPORT  CELL_ERROR_CAST(0x8071032c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_OPTION_EOPNOTSUPP       CELL_ERROR_CAST(0x8071032d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_OPTION_EPFNOSUPPORT     CELL_ERROR_CAST(0x8071032e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_OPTION_EAFNOSUPPORT     CELL_ERROR_CAST(0x8071032f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_OPTION_EADDRINUSE       CELL_ERROR_CAST(0x80710330)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_OPTION_EADDRNOTAVAIL    CELL_ERROR_CAST(0x80710331)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_OPTION_ENETDOWN         CELL_ERROR_CAST(0x80710332)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_OPTION_ENETUNREACH      CELL_ERROR_CAST(0x80710333)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_OPTION_ENETRESET        CELL_ERROR_CAST(0x80710334)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_OPTION_ECONNABORTED     CELL_ERROR_CAST(0x80710335)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_OPTION_ECONNRESET       CELL_ERROR_CAST(0x80710336)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOBUFS          CELL_ERROR_CAST(0x80710337)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_OPTION_EISCONN          CELL_ERROR_CAST(0x80710338)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTCONN         CELL_ERROR_CAST(0x80710339)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_OPTION_ESHUTDOWN        CELL_ERROR_CAST(0x8071033a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_OPTION_ETOOMANYREFS     CELL_ERROR_CAST(0x8071033b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_OPTION_ETIMEDOUT        CELL_ERROR_CAST(0x8071033c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_OPTION_ECONNREFUSED     CELL_ERROR_CAST(0x8071033d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_OPTION_ELOOP            CELL_ERROR_CAST(0x8071033e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_OPTION_ENAMETOOLONG     CELL_ERROR_CAST(0x8071033f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_OPTION_EHOSTDOWN        CELL_ERROR_CAST(0x80710340)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_OPTION_EHOSTUNREACH     CELL_ERROR_CAST(0x80710341)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTEMPTY        CELL_ERROR_CAST(0x80710342)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROCLIM         CELL_ERROR_CAST(0x80710343)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_OPTION_EUSERS           CELL_ERROR_CAST(0x80710344)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_OPTION_EDQUOT           CELL_ERROR_CAST(0x80710345)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_OPTION_ESTALE           CELL_ERROR_CAST(0x80710346)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_OPTION_EREMOTE          CELL_ERROR_CAST(0x80710347)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_OPTION_EBADRPC          CELL_ERROR_CAST(0x80710348)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_OPTION_ERPCMISMATCH     CELL_ERROR_CAST(0x80710349)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROGUNAVAIL     CELL_ERROR_CAST(0x8071034a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROGMISMATCH    CELL_ERROR_CAST(0x8071034b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_OPTION_EPROCUNAVAIL     CELL_ERROR_CAST(0x8071034c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOLCK           CELL_ERROR_CAST(0x8071034d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOSYS           CELL_ERROR_CAST(0x8071034e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_OPTION_EFTYPE           CELL_ERROR_CAST(0x8071034f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_OPTION_EAUTH            CELL_ERROR_CAST(0x80710350)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_OPTION_ENEEDAUTH        CELL_ERROR_CAST(0x80710351)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_OPTION_EIDRM            CELL_ERROR_CAST(0x80710352)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOMSG           CELL_ERROR_CAST(0x80710353)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_OPTION_EOVERFLOW        CELL_ERROR_CAST(0x80710354)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_OPTION_EILSEQ           CELL_ERROR_CAST(0x80710355)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOTSUP          CELL_ERROR_CAST(0x80710356)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_OPTION_ECANCELED        CELL_ERROR_CAST(0x80710357)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_OPTION_EBADMSG          CELL_ERROR_CAST(0x80710358)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_OPTION_ENODATA          CELL_ERROR_CAST(0x80710359)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOSR            CELL_ERROR_CAST(0x8071035a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_OPTION_ENOSTR           CELL_ERROR_CAST(0x8071035b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_OPTION, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_OPTION_ETIME            CELL_ERROR_CAST(0x8071035c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0400) */
/*
 * #define CELL_HTTP_ERROR_NET_SOCKET               CELL_ERROR_CAST(0x80710400)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPERM            CELL_ERROR_CAST(0x80710401)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOENT           CELL_ERROR_CAST(0x80710402)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SOCKET_ESRCH            CELL_ERROR_CAST(0x80710403)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SOCKET_EINTR            CELL_ERROR_CAST(0x80710404)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SOCKET_EIO              CELL_ERROR_CAST(0x80710405)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENXIO            CELL_ERROR_CAST(0x80710406)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SOCKET_E2BIG            CELL_ERROR_CAST(0x80710407)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOEXC           CELL_ERROR_CAST(0x80710408)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SOCKET_EBADF            CELL_ERROR_CAST(0x80710409)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SOCKET_ECHILD           CELL_ERROR_CAST(0x8071040a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SOCKET_EDEADLK          CELL_ERROR_CAST(0x8071040b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOMEM           CELL_ERROR_CAST(0x8071040c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SOCKET_EACCES           CELL_ERROR_CAST(0x8071040d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SOCKET_EFAULT           CELL_ERROR_CAST(0x8071040e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTBLK          CELL_ERROR_CAST(0x8071040f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SOCKET_EBUSY            CELL_ERROR_CAST(0x80710410)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SOCKET_EEXIST           CELL_ERROR_CAST(0x80710411)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SOCKET_EXDEV            CELL_ERROR_CAST(0x80710412)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENODEV           CELL_ERROR_CAST(0x80710413)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTDIR          CELL_ERROR_CAST(0x80710414)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SOCKET_EISDIR           CELL_ERROR_CAST(0x80710415)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SOCKET_EINVAL           CELL_ERROR_CAST(0x80710416)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENFILE           CELL_ERROR_CAST(0x80710417)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EMFILE           CELL_ERROR_CAST(0x80710418)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTTY           CELL_ERROR_CAST(0x80710419)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SOCKET_ETXTBSY          CELL_ERROR_CAST(0x8071041a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SOCKET_EFBIG            CELL_ERROR_CAST(0x8071041b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOSPC           CELL_ERROR_CAST(0x8071041c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SOCKET_ESPIPE           CELL_ERROR_CAST(0x8071041d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SOCKET_EROFS            CELL_ERROR_CAST(0x8071041e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SOCKET_EMLINK           CELL_ERROR_CAST(0x8071041f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPIPE            CELL_ERROR_CAST(0x80710420)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SOCKET_EDOM             CELL_ERROR_CAST(0x80710421)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SOCKET_ERANGE           CELL_ERROR_CAST(0x80710422)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SOCKET_EAGAIN           CELL_ERROR_CAST(0x80710423)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SOCKET_EWOULDBLOCK      CELL_ERROR_CAST(0x80710423)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SOCKET_EINPROGRESS      CELL_ERROR_CAST(0x80710424)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SOCKET_EALREADY         CELL_ERROR_CAST(0x80710425)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTSOCK         CELL_ERROR_CAST(0x80710426)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SOCKET_EDESTADDRREQ     CELL_ERROR_CAST(0x80710427)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EMSGSIZE         CELL_ERROR_CAST(0x80710428)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROTOTYPE       CELL_ERROR_CAST(0x80710429)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOPROTOOPT      CELL_ERROR_CAST(0x8071042a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROTONOSUPPORT  CELL_ERROR_CAST(0x8071042b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SOCKET_ESOCKTNOSUPPORT  CELL_ERROR_CAST(0x8071042c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SOCKET_EOPNOTSUPP       CELL_ERROR_CAST(0x8071042d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPFNOSUPPORT     CELL_ERROR_CAST(0x8071042e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SOCKET_EAFNOSUPPORT     CELL_ERROR_CAST(0x8071042f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EADDRINUSE       CELL_ERROR_CAST(0x80710430)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SOCKET_EADDRNOTAVAIL    CELL_ERROR_CAST(0x80710431)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENETDOWN         CELL_ERROR_CAST(0x80710432)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENETUNREACH      CELL_ERROR_CAST(0x80710433)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENETRESET        CELL_ERROR_CAST(0x80710434)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SOCKET_ECONNABORTED     CELL_ERROR_CAST(0x80710435)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SOCKET_ECONNRESET       CELL_ERROR_CAST(0x80710436)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOBUFS          CELL_ERROR_CAST(0x80710437)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SOCKET_EISCONN          CELL_ERROR_CAST(0x80710438)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTCONN         CELL_ERROR_CAST(0x80710439)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SOCKET_ESHUTDOWN        CELL_ERROR_CAST(0x8071043a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SOCKET_ETOOMANYREFS     CELL_ERROR_CAST(0x8071043b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SOCKET_ETIMEDOUT        CELL_ERROR_CAST(0x8071043c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SOCKET_ECONNREFUSED     CELL_ERROR_CAST(0x8071043d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SOCKET_ELOOP            CELL_ERROR_CAST(0x8071043e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENAMETOOLONG     CELL_ERROR_CAST(0x8071043f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SOCKET_EHOSTDOWN        CELL_ERROR_CAST(0x80710440)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SOCKET_EHOSTUNREACH     CELL_ERROR_CAST(0x80710441)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTEMPTY        CELL_ERROR_CAST(0x80710442)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROCLIM         CELL_ERROR_CAST(0x80710443)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SOCKET_EUSERS           CELL_ERROR_CAST(0x80710444)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SOCKET_EDQUOT           CELL_ERROR_CAST(0x80710445)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SOCKET_ESTALE           CELL_ERROR_CAST(0x80710446)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EREMOTE          CELL_ERROR_CAST(0x80710447)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SOCKET_EBADRPC          CELL_ERROR_CAST(0x80710448)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SOCKET_ERPCMISMATCH     CELL_ERROR_CAST(0x80710449)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROGUNAVAIL     CELL_ERROR_CAST(0x8071044a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROGMISMATCH    CELL_ERROR_CAST(0x8071044b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SOCKET_EPROCUNAVAIL     CELL_ERROR_CAST(0x8071044c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOLCK           CELL_ERROR_CAST(0x8071044d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOSYS           CELL_ERROR_CAST(0x8071044e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SOCKET_EFTYPE           CELL_ERROR_CAST(0x8071044f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SOCKET_EAUTH            CELL_ERROR_CAST(0x80710450)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENEEDAUTH        CELL_ERROR_CAST(0x80710451)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SOCKET_EIDRM            CELL_ERROR_CAST(0x80710452)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOMSG           CELL_ERROR_CAST(0x80710453)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SOCKET_EOVERFLOW        CELL_ERROR_CAST(0x80710454)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SOCKET_EILSEQ           CELL_ERROR_CAST(0x80710455)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOTSUP          CELL_ERROR_CAST(0x80710456)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SOCKET_ECANCELED        CELL_ERROR_CAST(0x80710457)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SOCKET_EBADMSG          CELL_ERROR_CAST(0x80710458)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENODATA          CELL_ERROR_CAST(0x80710459)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOSR            CELL_ERROR_CAST(0x8071045a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SOCKET_ENOSTR           CELL_ERROR_CAST(0x8071045b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SOCKET, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SOCKET_ETIME            CELL_ERROR_CAST(0x8071045c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0500) */
/*
 * #define CELL_HTTP_ERROR_NET_CONNECT              CELL_ERROR_CAST(0x80710500)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_ABORT, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPERM           CELL_ERROR_CAST(0x80710501)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOENT          CELL_ERROR_CAST(0x80710502)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_CONNECT_ESRCH           CELL_ERROR_CAST(0x80710503)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_CONNECT_EINTR           CELL_ERROR_CAST(0x80710504)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_CONNECT_EIO             CELL_ERROR_CAST(0x80710505)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENXIO           CELL_ERROR_CAST(0x80710506)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_CONNECT_E2BIG           CELL_ERROR_CAST(0x80710507)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOEXC          CELL_ERROR_CAST(0x80710508)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_CONNECT_EBADF           CELL_ERROR_CAST(0x80710509)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_CONNECT_ECHILD          CELL_ERROR_CAST(0x8071050a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_CONNECT_EDEADLK         CELL_ERROR_CAST(0x8071050b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOMEM          CELL_ERROR_CAST(0x8071050c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_CONNECT_EACCES          CELL_ERROR_CAST(0x8071050d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_CONNECT_EFAULT          CELL_ERROR_CAST(0x8071050e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTBLK         CELL_ERROR_CAST(0x8071050f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_CONNECT_EBUSY           CELL_ERROR_CAST(0x80710510)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_CONNECT_EEXIST          CELL_ERROR_CAST(0x80710511)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_CONNECT_EXDEV           CELL_ERROR_CAST(0x80710512)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENODEV          CELL_ERROR_CAST(0x80710513)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTDIR         CELL_ERROR_CAST(0x80710514)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_CONNECT_EISDIR          CELL_ERROR_CAST(0x80710515)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_CONNECT_EINVAL          CELL_ERROR_CAST(0x80710516)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENFILE          CELL_ERROR_CAST(0x80710517)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EMFILE          CELL_ERROR_CAST(0x80710518)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTTY          CELL_ERROR_CAST(0x80710519)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_CONNECT_ETXTBSY         CELL_ERROR_CAST(0x8071051a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_CONNECT_EFBIG           CELL_ERROR_CAST(0x8071051b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOSPC          CELL_ERROR_CAST(0x8071051c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_CONNECT_ESPIPE          CELL_ERROR_CAST(0x8071051d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_CONNECT_EROFS           CELL_ERROR_CAST(0x8071051e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_CONNECT_EMLINK          CELL_ERROR_CAST(0x8071051f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPIPE           CELL_ERROR_CAST(0x80710520)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_CONNECT_EDOM            CELL_ERROR_CAST(0x80710521)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_CONNECT_ERANGE          CELL_ERROR_CAST(0x80710522)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_CONNECT_EAGAIN          CELL_ERROR_CAST(0x80710523)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_CONNECT_EWOULDBLOCK     CELL_ERROR_CAST(0x80710523)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_CONNECT_EINPROGRESS     CELL_ERROR_CAST(0x80710524)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_CONNECT_EALREADY        CELL_ERROR_CAST(0x80710525)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTSOCK        CELL_ERROR_CAST(0x80710526)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_CONNECT_EDESTADDRREQ    CELL_ERROR_CAST(0x80710527)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EMSGSIZE        CELL_ERROR_CAST(0x80710528)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROTOTYPE      CELL_ERROR_CAST(0x80710529)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOPROTOOPT     CELL_ERROR_CAST(0x8071052a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROTONOSUPPORT CELL_ERROR_CAST(0x8071052b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_CONNECT_ESOCKTNOSUPPORT CELL_ERROR_CAST(0x8071052c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_CONNECT_EOPNOTSUPP      CELL_ERROR_CAST(0x8071052d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPFNOSUPPORT    CELL_ERROR_CAST(0x8071052e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_CONNECT_EAFNOSUPPORT    CELL_ERROR_CAST(0x8071052f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EADDRINUSE      CELL_ERROR_CAST(0x80710530)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_CONNECT_EADDRNOTAVAIL   CELL_ERROR_CAST(0x80710531)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENETDOWN        CELL_ERROR_CAST(0x80710532)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENETUNREACH     CELL_ERROR_CAST(0x80710533)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENETRESET       CELL_ERROR_CAST(0x80710534)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_CONNECT_ECONNABORTED    CELL_ERROR_CAST(0x80710535)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_CONNECT_ECONNRESET      CELL_ERROR_CAST(0x80710536)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOBUFS         CELL_ERROR_CAST(0x80710537)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_CONNECT_EISCONN         CELL_ERROR_CAST(0x80710538)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTCONN        CELL_ERROR_CAST(0x80710539)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_CONNECT_ESHUTDOWN       CELL_ERROR_CAST(0x8071053a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_CONNECT_ETOOMANYREFS    CELL_ERROR_CAST(0x8071053b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_CONNECT_ETIMEDOUT       CELL_ERROR_CAST(0x8071053c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_CONNECT_ECONNREFUSED    CELL_ERROR_CAST(0x8071053d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_CONNECT_ELOOP           CELL_ERROR_CAST(0x8071053e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENAMETOOLONG    CELL_ERROR_CAST(0x8071053f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_CONNECT_EHOSTDOWN       CELL_ERROR_CAST(0x80710540)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_CONNECT_EHOSTUNREACH    CELL_ERROR_CAST(0x80710541)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTEMPTY       CELL_ERROR_CAST(0x80710542)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROCLIM        CELL_ERROR_CAST(0x80710543)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_CONNECT_EUSERS          CELL_ERROR_CAST(0x80710544)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_CONNECT_EDQUOT          CELL_ERROR_CAST(0x80710545)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_CONNECT_ESTALE          CELL_ERROR_CAST(0x80710546)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EREMOTE         CELL_ERROR_CAST(0x80710547)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_CONNECT_EBADRPC         CELL_ERROR_CAST(0x80710548)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_CONNECT_ERPCMISMATCH    CELL_ERROR_CAST(0x80710549)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROGUNAVAIL    CELL_ERROR_CAST(0x8071054a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROGMISMATCH   CELL_ERROR_CAST(0x8071054b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_CONNECT_EPROCUNAVAIL    CELL_ERROR_CAST(0x8071054c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOLCK          CELL_ERROR_CAST(0x8071054d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOSYS          CELL_ERROR_CAST(0x8071054e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_CONNECT_EFTYPE          CELL_ERROR_CAST(0x8071054f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_CONNECT_EAUTH           CELL_ERROR_CAST(0x80710550)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENEEDAUTH       CELL_ERROR_CAST(0x80710551)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_CONNECT_EIDRM           CELL_ERROR_CAST(0x80710552)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOMSG          CELL_ERROR_CAST(0x80710553)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_CONNECT_EOVERFLOW       CELL_ERROR_CAST(0x80710554)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_CONNECT_EILSEQ          CELL_ERROR_CAST(0x80710555)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOTSUP         CELL_ERROR_CAST(0x80710556)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_CONNECT_ECANCELED       CELL_ERROR_CAST(0x80710557)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_CONNECT_EBADMSG         CELL_ERROR_CAST(0x80710558)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENODATA         CELL_ERROR_CAST(0x80710559)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOSR           CELL_ERROR_CAST(0x8071055a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_CONNECT_ENOSTR          CELL_ERROR_CAST(0x8071055b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_CONNECT, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_CONNECT_ETIME           CELL_ERROR_CAST(0x8071055c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0600) */
/*
 * #define CELL_HTTP_ERROR_NET_SEND                    CELL_ERROR_CAST(0x80710600)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SEND_EPERM              CELL_ERROR_CAST(0x80710601)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SEND_ENOENT             CELL_ERROR_CAST(0x80710602)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SEND_ESRCH              CELL_ERROR_CAST(0x80710603)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SEND_EINTR              CELL_ERROR_CAST(0x80710604)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SEND_EIO                CELL_ERROR_CAST(0x80710605)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SEND_ENXIO              CELL_ERROR_CAST(0x80710606)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SEND_E2BIG              CELL_ERROR_CAST(0x80710607)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SEND_ENOEXC             CELL_ERROR_CAST(0x80710608)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SEND_EBADF              CELL_ERROR_CAST(0x80710609)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SEND_ECHILD             CELL_ERROR_CAST(0x8071060a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SEND_EDEADLK            CELL_ERROR_CAST(0x8071060b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SEND_ENOMEM             CELL_ERROR_CAST(0x8071060c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SEND_EACCES             CELL_ERROR_CAST(0x8071060d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SEND_EFAULT             CELL_ERROR_CAST(0x8071060e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTBLK            CELL_ERROR_CAST(0x8071060f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SEND_EBUSY              CELL_ERROR_CAST(0x80710610)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SEND_EEXIST             CELL_ERROR_CAST(0x80710611)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SEND_EXDEV              CELL_ERROR_CAST(0x80710612)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SEND_ENODEV             CELL_ERROR_CAST(0x80710613)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTDIR            CELL_ERROR_CAST(0x80710614)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SEND_EISDIR             CELL_ERROR_CAST(0x80710615)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SEND_EINVAL             CELL_ERROR_CAST(0x80710616)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SEND_ENFILE             CELL_ERROR_CAST(0x80710617)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SEND_EMFILE             CELL_ERROR_CAST(0x80710618)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTTY             CELL_ERROR_CAST(0x80710619)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SEND_ETXTBSY            CELL_ERROR_CAST(0x8071061a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SEND_EFBIG              CELL_ERROR_CAST(0x8071061b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SEND_ENOSPC             CELL_ERROR_CAST(0x8071061c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SEND_ESPIPE             CELL_ERROR_CAST(0x8071061d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SEND_EROFS              CELL_ERROR_CAST(0x8071061e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SEND_EMLINK             CELL_ERROR_CAST(0x8071061f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SEND_EPIPE              CELL_ERROR_CAST(0x80710620)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SEND_EDOM               CELL_ERROR_CAST(0x80710621)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SEND_ERANGE             CELL_ERROR_CAST(0x80710622)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SEND_EAGAIN             CELL_ERROR_CAST(0x80710623)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SEND_EWOULDBLOCK        CELL_ERROR_CAST(0x80710623)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SEND_EINPROGRESS        CELL_ERROR_CAST(0x80710624)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SEND_EALREADY           CELL_ERROR_CAST(0x80710625)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTSOCK           CELL_ERROR_CAST(0x80710626)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SEND_EDESTADDRREQ       CELL_ERROR_CAST(0x80710627)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SEND_EMSGSIZE           CELL_ERROR_CAST(0x80710628)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SEND_EPROTOTYPE         CELL_ERROR_CAST(0x80710629)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SEND_ENOPROTOOPT        CELL_ERROR_CAST(0x8071062a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SEND_EPROTONOSUPPORT    CELL_ERROR_CAST(0x8071062b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SEND_ESOCKTNOSUPPORT    CELL_ERROR_CAST(0x8071062c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SEND_EOPNOTSUPP         CELL_ERROR_CAST(0x8071062d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SEND_EPFNOSUPPORT       CELL_ERROR_CAST(0x8071062e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SEND_EAFNOSUPPORT       CELL_ERROR_CAST(0x8071062f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SEND_EADDRINUSE         CELL_ERROR_CAST(0x80710630)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SEND_EADDRNOTAVAIL      CELL_ERROR_CAST(0x80710631)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SEND_ENETDOWN           CELL_ERROR_CAST(0x80710632)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SEND_ENETUNREACH        CELL_ERROR_CAST(0x80710633)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SEND_ENETRESET          CELL_ERROR_CAST(0x80710634)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SEND_ECONNABORTED       CELL_ERROR_CAST(0x80710635)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SEND_ECONNRESET         CELL_ERROR_CAST(0x80710636)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SEND_ENOBUFS            CELL_ERROR_CAST(0x80710637)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SEND_EISCONN            CELL_ERROR_CAST(0x80710638)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTCONN           CELL_ERROR_CAST(0x80710639)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SEND_ESHUTDOWN          CELL_ERROR_CAST(0x8071063a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SEND_ETOOMANYREFS       CELL_ERROR_CAST(0x8071063b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SEND_ETIMEDOUT          CELL_ERROR_CAST(0x8071063c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SEND_ECONNREFUSED       CELL_ERROR_CAST(0x8071063d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SEND_ELOOP              CELL_ERROR_CAST(0x8071063e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SEND_ENAMETOOLONG       CELL_ERROR_CAST(0x8071063f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SEND_EHOSTDOWN          CELL_ERROR_CAST(0x80710640)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SEND_EHOSTUNREACH       CELL_ERROR_CAST(0x80710641)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTEMPTY          CELL_ERROR_CAST(0x80710642)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SEND_EPROCLIM           CELL_ERROR_CAST(0x80710643)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SEND_EUSERS             CELL_ERROR_CAST(0x80710644)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SEND_EDQUOT             CELL_ERROR_CAST(0x80710645)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SEND_ESTALE             CELL_ERROR_CAST(0x80710646)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SEND_EREMOTE            CELL_ERROR_CAST(0x80710647)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SEND_EBADRPC            CELL_ERROR_CAST(0x80710648)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SEND_ERPCMISMATCH       CELL_ERROR_CAST(0x80710649)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SEND_EPROGUNAVAIL       CELL_ERROR_CAST(0x8071064a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SEND_EPROGMISMATCH      CELL_ERROR_CAST(0x8071064b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SEND_EPROCUNAVAIL       CELL_ERROR_CAST(0x8071064c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SEND_ENOLCK             CELL_ERROR_CAST(0x8071064d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SEND_ENOSYS             CELL_ERROR_CAST(0x8071064e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SEND_EFTYPE             CELL_ERROR_CAST(0x8071064f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SEND_EAUTH              CELL_ERROR_CAST(0x80710650)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SEND_ENEEDAUTH          CELL_ERROR_CAST(0x80710651)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SEND_EIDRM              CELL_ERROR_CAST(0x80710652)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SEND_ENOMSG             CELL_ERROR_CAST(0x80710653)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SEND_EOVERFLOW          CELL_ERROR_CAST(0x80710654)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SEND_EILSEQ             CELL_ERROR_CAST(0x80710655)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SEND_ENOTSUP            CELL_ERROR_CAST(0x80710656)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SEND_ECANCELED          CELL_ERROR_CAST(0x80710657)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SEND_EBADMSG            CELL_ERROR_CAST(0x80710658)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SEND_ENODATA            CELL_ERROR_CAST(0x80710659)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SEND_ENOSR              CELL_ERROR_CAST(0x8071065a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SEND_ENOSTR             CELL_ERROR_CAST(0x8071065b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SEND, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SEND_ETIME              CELL_ERROR_CAST(0x8071065c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0700) */
/*
 * #define CELL_HTTP_ERROR_NET_RECV                 CELL_ERROR_CAST(0x80710700)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_RECV_EPERM              CELL_ERROR_CAST(0x80710701)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_RECV_ENOENT             CELL_ERROR_CAST(0x80710702)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_RECV_ESRCH              CELL_ERROR_CAST(0x80710703)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_RECV_EINTR              CELL_ERROR_CAST(0x80710704)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_RECV_EIO                CELL_ERROR_CAST(0x80710705)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_RECV_ENXIO              CELL_ERROR_CAST(0x80710706)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_RECV_E2BIG              CELL_ERROR_CAST(0x80710707)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_RECV_ENOEXC             CELL_ERROR_CAST(0x80710708)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_RECV_EBADF              CELL_ERROR_CAST(0x80710709)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_RECV_ECHILD             CELL_ERROR_CAST(0x8071070a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_RECV_EDEADLK            CELL_ERROR_CAST(0x8071070b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_RECV_ENOMEM             CELL_ERROR_CAST(0x8071070c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_RECV_EACCES             CELL_ERROR_CAST(0x8071070d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_RECV_EFAULT             CELL_ERROR_CAST(0x8071070e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTBLK            CELL_ERROR_CAST(0x8071070f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_RECV_EBUSY              CELL_ERROR_CAST(0x80710710)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_RECV_EEXIST             CELL_ERROR_CAST(0x80710711)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_RECV_EXDEV              CELL_ERROR_CAST(0x80710712)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_RECV_ENODEV             CELL_ERROR_CAST(0x80710713)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTDIR            CELL_ERROR_CAST(0x80710714)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_RECV_EISDIR             CELL_ERROR_CAST(0x80710715)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_RECV_EINVAL             CELL_ERROR_CAST(0x80710716)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_RECV_ENFILE             CELL_ERROR_CAST(0x80710717)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_RECV_EMFILE             CELL_ERROR_CAST(0x80710718)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTTY             CELL_ERROR_CAST(0x80710719)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_RECV_ETXTBSY            CELL_ERROR_CAST(0x8071071a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_RECV_EFBIG              CELL_ERROR_CAST(0x8071071b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_RECV_ENOSPC             CELL_ERROR_CAST(0x8071071c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_RECV_ESPIPE             CELL_ERROR_CAST(0x8071071d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_RECV_EROFS              CELL_ERROR_CAST(0x8071071e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_RECV_EMLINK             CELL_ERROR_CAST(0x8071071f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_RECV_EPIPE              CELL_ERROR_CAST(0x80710720)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_RECV_EDOM               CELL_ERROR_CAST(0x80710721)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_RECV_ERANGE             CELL_ERROR_CAST(0x80710722)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_RECV_EAGAIN             CELL_ERROR_CAST(0x80710723)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_RECV_EWOULDBLOCK        CELL_ERROR_CAST(0x80710723)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_RECV_EINPROGRESS        CELL_ERROR_CAST(0x80710724)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_RECV_EALREADY           CELL_ERROR_CAST(0x80710725)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTSOCK           CELL_ERROR_CAST(0x80710726)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_RECV_EDESTADDRREQ       CELL_ERROR_CAST(0x80710727)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_RECV_EMSGSIZE           CELL_ERROR_CAST(0x80710728)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_RECV_EPROTOTYPE         CELL_ERROR_CAST(0x80710729)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_RECV_ENOPROTOOPT        CELL_ERROR_CAST(0x8071072a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_RECV_EPROTONOSUPPORT    CELL_ERROR_CAST(0x8071072b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_RECV_ESOCKTNOSUPPORT    CELL_ERROR_CAST(0x8071072c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_RECV_EOPNOTSUPP         CELL_ERROR_CAST(0x8071072d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_RECV_EPFNOSUPPORT       CELL_ERROR_CAST(0x8071072e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_RECV_EAFNOSUPPORT       CELL_ERROR_CAST(0x8071072f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_RECV_EADDRINUSE         CELL_ERROR_CAST(0x80710730)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_RECV_EADDRNOTAVAIL      CELL_ERROR_CAST(0x80710731)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_RECV_ENETDOWN           CELL_ERROR_CAST(0x80710732)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_RECV_ENETUNREACH        CELL_ERROR_CAST(0x80710733)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_RECV_ENETRESET          CELL_ERROR_CAST(0x80710734)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_RECV_ECONNABORTED       CELL_ERROR_CAST(0x80710735)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_RECV_ECONNRESET         CELL_ERROR_CAST(0x80710736)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_RECV_ENOBUFS            CELL_ERROR_CAST(0x80710737)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_RECV_EISCONN            CELL_ERROR_CAST(0x80710738)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTCONN           CELL_ERROR_CAST(0x80710739)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_RECV_ESHUTDOWN          CELL_ERROR_CAST(0x8071073a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_RECV_ETOOMANYREFS       CELL_ERROR_CAST(0x8071073b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_RECV_ETIMEDOUT          CELL_ERROR_CAST(0x8071073c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_RECV_ECONNREFUSED       CELL_ERROR_CAST(0x8071073d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_RECV_ELOOP              CELL_ERROR_CAST(0x8071073e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_RECV_ENAMETOOLONG       CELL_ERROR_CAST(0x8071073f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_RECV_EHOSTDOWN          CELL_ERROR_CAST(0x80710740)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_RECV_EHOSTUNREACH       CELL_ERROR_CAST(0x80710741)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTEMPTY          CELL_ERROR_CAST(0x80710742)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_RECV_EPROCLIM           CELL_ERROR_CAST(0x80710743)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_RECV_EUSERS             CELL_ERROR_CAST(0x80710744)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_RECV_EDQUOT             CELL_ERROR_CAST(0x80710745)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_RECV_ESTALE             CELL_ERROR_CAST(0x80710746)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_RECV_EREMOTE            CELL_ERROR_CAST(0x80710747)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_RECV_EBADRPC            CELL_ERROR_CAST(0x80710748)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_RECV_ERPCMISMATCH       CELL_ERROR_CAST(0x80710749)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_RECV_EPROGUNAVAIL       CELL_ERROR_CAST(0x8071074a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_RECV_EPROGMISMATCH      CELL_ERROR_CAST(0x8071074b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_RECV_EPROCUNAVAIL       CELL_ERROR_CAST(0x8071074c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_RECV_ENOLCK             CELL_ERROR_CAST(0x8071074d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_RECV_ENOSYS             CELL_ERROR_CAST(0x8071074e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_RECV_EFTYPE             CELL_ERROR_CAST(0x8071074f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_RECV_EAUTH              CELL_ERROR_CAST(0x80710750)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_RECV_ENEEDAUTH          CELL_ERROR_CAST(0x80710751)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_RECV_EIDRM              CELL_ERROR_CAST(0x80710752)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_RECV_ENOMSG             CELL_ERROR_CAST(0x80710753)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_RECV_EOVERFLOW          CELL_ERROR_CAST(0x80710754)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_RECV_EILSEQ             CELL_ERROR_CAST(0x80710755)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_RECV_ENOTSUP            CELL_ERROR_CAST(0x80710756)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_RECV_ECANCELED          CELL_ERROR_CAST(0x80710757)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_RECV_EBADMSG            CELL_ERROR_CAST(0x80710758)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_RECV_ENODATA            CELL_ERROR_CAST(0x80710759)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_RECV_ENOSR              CELL_ERROR_CAST(0x8071075a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_RECV_ENOSTR             CELL_ERROR_CAST(0x8071075b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_RECV, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_RECV_ETIME              CELL_ERROR_CAST(0x8071075c)


/* ERR: CELL_HTTP_MAKE_ERROR(0x0800) */
/*
 * #define CELL_HTTP_ERROR_NET_SELECT               CELL_ERROR_CAST(0x80710800)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SELECT_EPERM            CELL_ERROR_CAST(0x80710801)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOENT           CELL_ERROR_CAST(0x80710802)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SELECT_ESRCH            CELL_ERROR_CAST(0x80710803)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SELECT_EINTR            CELL_ERROR_CAST(0x80710804)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SELECT_EIO              CELL_ERROR_CAST(0x80710805)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SELECT_ENXIO            CELL_ERROR_CAST(0x80710806)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SELECT_E2BIG            CELL_ERROR_CAST(0x80710807)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOEXC           CELL_ERROR_CAST(0x80710808)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SELECT_EBADF            CELL_ERROR_CAST(0x80710809)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SELECT_ECHILD           CELL_ERROR_CAST(0x8071080a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SELECT_EDEADLK          CELL_ERROR_CAST(0x8071080b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOMEM           CELL_ERROR_CAST(0x8071080c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SELECT_EACCES           CELL_ERROR_CAST(0x8071080d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SELECT_EFAULT           CELL_ERROR_CAST(0x8071080e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTBLK          CELL_ERROR_CAST(0x8071080f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SELECT_EBUSY            CELL_ERROR_CAST(0x80710810)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SELECT_EEXIST           CELL_ERROR_CAST(0x80710811)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SELECT_EXDEV            CELL_ERROR_CAST(0x80710812)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SELECT_ENODEV           CELL_ERROR_CAST(0x80710813)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTDIR          CELL_ERROR_CAST(0x80710814)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SELECT_EISDIR           CELL_ERROR_CAST(0x80710815)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SELECT_EINVAL           CELL_ERROR_CAST(0x80710816)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SELECT_ENFILE           CELL_ERROR_CAST(0x80710817)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SELECT_EMFILE           CELL_ERROR_CAST(0x80710818)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTTY           CELL_ERROR_CAST(0x80710819)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SELECT_ETXTBSY          CELL_ERROR_CAST(0x8071081a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SELECT_EFBIG            CELL_ERROR_CAST(0x8071081b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOSPC           CELL_ERROR_CAST(0x8071081c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SELECT_ESPIPE           CELL_ERROR_CAST(0x8071081d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SELECT_EROFS            CELL_ERROR_CAST(0x8071081e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SELECT_EMLINK           CELL_ERROR_CAST(0x8071081f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SELECT_EPIPE            CELL_ERROR_CAST(0x80710820)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SELECT_EDOM             CELL_ERROR_CAST(0x80710821)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SELECT_ERANGE           CELL_ERROR_CAST(0x80710822)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SELECT_EAGAIN           CELL_ERROR_CAST(0x80710823)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SELECT_EWOULDBLOCK      CELL_ERROR_CAST(0x80710823)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SELECT_EINPROGRESS      CELL_ERROR_CAST(0x80710824)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SELECT_EALREADY         CELL_ERROR_CAST(0x80710825)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTSOCK         CELL_ERROR_CAST(0x80710826)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SELECT_EDESTADDRREQ     CELL_ERROR_CAST(0x80710827)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SELECT_EMSGSIZE         CELL_ERROR_CAST(0x80710828)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROTOTYPE       CELL_ERROR_CAST(0x80710829)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOPROTOOPT      CELL_ERROR_CAST(0x8071082a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROTONOSUPPORT  CELL_ERROR_CAST(0x8071082b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SELECT_ESOCKTNOSUPPORT  CELL_ERROR_CAST(0x8071082c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SELECT_EOPNOTSUPP       CELL_ERROR_CAST(0x8071082d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SELECT_EPFNOSUPPORT     CELL_ERROR_CAST(0x8071082e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SELECT_EAFNOSUPPORT     CELL_ERROR_CAST(0x8071082f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SELECT_EADDRINUSE       CELL_ERROR_CAST(0x80710830)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SELECT_EADDRNOTAVAIL    CELL_ERROR_CAST(0x80710831)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SELECT_ENETDOWN         CELL_ERROR_CAST(0x80710832)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SELECT_ENETUNREACH      CELL_ERROR_CAST(0x80710833)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SELECT_ENETRESET        CELL_ERROR_CAST(0x80710834)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SELECT_ECONNABORTED     CELL_ERROR_CAST(0x80710835)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SELECT_ECONNRESET       CELL_ERROR_CAST(0x80710836)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOBUFS          CELL_ERROR_CAST(0x80710837)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SELECT_EISCONN          CELL_ERROR_CAST(0x80710838)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTCONN         CELL_ERROR_CAST(0x80710839)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SELECT_ESHUTDOWN        CELL_ERROR_CAST(0x8071083a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SELECT_ETOOMANYREFS     CELL_ERROR_CAST(0x8071083b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SELECT_ETIMEDOUT        CELL_ERROR_CAST(0x8071083c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SELECT_ECONNREFUSED     CELL_ERROR_CAST(0x8071083d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SELECT_ELOOP            CELL_ERROR_CAST(0x8071083e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SELECT_ENAMETOOLONG     CELL_ERROR_CAST(0x8071083f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SELECT_EHOSTDOWN        CELL_ERROR_CAST(0x80710840)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SELECT_EHOSTUNREACH     CELL_ERROR_CAST(0x80710841)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTEMPTY        CELL_ERROR_CAST(0x80710842)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROCLIM         CELL_ERROR_CAST(0x80710843)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SELECT_EUSERS           CELL_ERROR_CAST(0x80710844)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SELECT_EDQUOT           CELL_ERROR_CAST(0x80710845)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SELECT_ESTALE           CELL_ERROR_CAST(0x80710846)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SELECT_EREMOTE          CELL_ERROR_CAST(0x80710847)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SELECT_EBADRPC          CELL_ERROR_CAST(0x80710848)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SELECT_ERPCMISMATCH     CELL_ERROR_CAST(0x80710849)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROGUNAVAIL     CELL_ERROR_CAST(0x8071084a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROGMISMATCH    CELL_ERROR_CAST(0x8071084b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SELECT_EPROCUNAVAIL     CELL_ERROR_CAST(0x8071084c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOLCK           CELL_ERROR_CAST(0x8071084d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOSYS           CELL_ERROR_CAST(0x8071084e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SELECT_EFTYPE           CELL_ERROR_CAST(0x8071084f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SELECT_EAUTH            CELL_ERROR_CAST(0x80710850)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SELECT_ENEEDAUTH        CELL_ERROR_CAST(0x80710851)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SELECT_EIDRM            CELL_ERROR_CAST(0x80710852)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOMSG           CELL_ERROR_CAST(0x80710853)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SELECT_EOVERFLOW        CELL_ERROR_CAST(0x80710854)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SELECT_EILSEQ           CELL_ERROR_CAST(0x80710855)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOTSUP          CELL_ERROR_CAST(0x80710856)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SELECT_ECANCELED        CELL_ERROR_CAST(0x80710857)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SELECT_EBADMSG          CELL_ERROR_CAST(0x80710858)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SELECT_ENODATA          CELL_ERROR_CAST(0x80710859)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOSR            CELL_ERROR_CAST(0x8071085a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SELECT_ENOSTR           CELL_ERROR_CAST(0x8071085b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTP_ERROR_NET_SELECT, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SELECT_ETIME            CELL_ERROR_CAST(0x8071085c)


/*E Network failed on SSL Connect
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, SYS_NET_refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0b00) */
/*
 * #define CELL_HTTPS_ERROR_NET_SSL_CONNECT         CELL_ERROR_CAST(0x80710b00)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPERM       CELL_ERROR_CAST(0x80710b01)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOENT      CELL_ERROR_CAST(0x80710b02)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ESRCH       CELL_ERROR_CAST(0x80710b03)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EINTR       CELL_ERROR_CAST(0x80710b04)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EIO         CELL_ERROR_CAST(0x80710b05)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENXIO       CELL_ERROR_CAST(0x80710b06)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_E2BIG       CELL_ERROR_CAST(0x80710b07)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOEXC      CELL_ERROR_CAST(0x80710b08)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADF       CELL_ERROR_CAST(0x80710b09)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ECHILD      CELL_ERROR_CAST(0x80710b0a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EDEADLK     CELL_ERROR_CAST(0x80710b0b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMEM      CELL_ERROR_CAST(0x80710b0c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EACCES      CELL_ERROR_CAST(0x80710b0d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EFAULT      CELL_ERROR_CAST(0x80710b0e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTBLK     CELL_ERROR_CAST(0x80710b0f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EBUSY       CELL_ERROR_CAST(0x80710b10)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EEXIST      CELL_ERROR_CAST(0x80710b11)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EXDEV       CELL_ERROR_CAST(0x80710b12)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODEV      CELL_ERROR_CAST(0x80710b13)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTDIR     CELL_ERROR_CAST(0x80710b14)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EISDIR      CELL_ERROR_CAST(0x80710b15)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EINVAL      CELL_ERROR_CAST(0x80710b16)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENFILE      CELL_ERROR_CAST(0x80710b17)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EMFILE      CELL_ERROR_CAST(0x80710b18)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTTY      CELL_ERROR_CAST(0x80710b19)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ETXTBSY     CELL_ERROR_CAST(0x80710b1a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EFBIG       CELL_ERROR_CAST(0x80710b1b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSPC      CELL_ERROR_CAST(0x80710b1c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ESPIPE      CELL_ERROR_CAST(0x80710b1d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EROFS       CELL_ERROR_CAST(0x80710b1e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EMLINK      CELL_ERROR_CAST(0x80710b1f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPIPE       CELL_ERROR_CAST(0x80710b20)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EDOM        CELL_ERROR_CAST(0x80710b21)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ERANGE      CELL_ERROR_CAST(0x80710b22)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EAGAIN      CELL_ERROR_CAST(0x80710b23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EWOULDBLOCK CELL_ERROR_CAST(0x80710b23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EINPROGRESS CELL_ERROR_CAST(0x80710b24)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EALREADY    CELL_ERROR_CAST(0x80710b25)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSOCK    CELL_ERROR_CAST(0x80710b26)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EDESTADDRREQ CELL_ERROR_CAST(0x80710b27)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EMSGSIZE    CELL_ERROR_CAST(0x80710b28)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTOTYPE  CELL_ERROR_CAST(0x80710b29)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOPROTOOPT CELL_ERROR_CAST(0x80710b2a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTONOSUPPORT CELL_ERROR_CAST(0x80710b2b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ESOCKTNOSUPPORT CELL_ERROR_CAST(0x80710b2c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EOPNOTSUPP  CELL_ERROR_CAST(0x80710b2d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPFNOSUPPORT CELL_ERROR_CAST(0x80710b2e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EAFNOSUPPORT CELL_ERROR_CAST(0x80710b2f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRINUSE  CELL_ERROR_CAST(0x80710b30)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRNOTAVAIL CELL_ERROR_CAST(0x80710b31)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETDOWN    CELL_ERROR_CAST(0x80710b32)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETUNREACH CELL_ERROR_CAST(0x80710b33)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETRESET   CELL_ERROR_CAST(0x80710b34)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNABORTED CELL_ERROR_CAST(0x80710b35)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNRESET  CELL_ERROR_CAST(0x80710b36)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOBUFS     CELL_ERROR_CAST(0x80710b37)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EISCONN     CELL_ERROR_CAST(0x80710b38)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTCONN    CELL_ERROR_CAST(0x80710b39)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ESHUTDOWN   CELL_ERROR_CAST(0x80710b3a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ETOOMANYREFS CELL_ERROR_CAST(0x80710b3b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIMEDOUT   CELL_ERROR_CAST(0x80710b3c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNREFUSED CELL_ERROR_CAST(0x80710b3d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ELOOP       CELL_ERROR_CAST(0x80710b3e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENAMETOOLONG CELL_ERROR_CAST(0x80710b3f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTDOWN   CELL_ERROR_CAST(0x80710b40)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTUNREACH CELL_ERROR_CAST(0x80710b41)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTEMPTY   CELL_ERROR_CAST(0x80710b42)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCLIM    CELL_ERROR_CAST(0x80710b43)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EUSERS      CELL_ERROR_CAST(0x80710b44)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EDQUOT      CELL_ERROR_CAST(0x80710b45)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ESTALE      CELL_ERROR_CAST(0x80710b46)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EREMOTE     CELL_ERROR_CAST(0x80710b47)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADRPC     CELL_ERROR_CAST(0x80710b48)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ERPCMISMATCH CELL_ERROR_CAST(0x80710b49)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGUNAVAIL CELL_ERROR_CAST(0x80710b4a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGMISMATCH CELL_ERROR_CAST(0x80710b4b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCUNAVAIL CELL_ERROR_CAST(0x80710b4c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOLCK      CELL_ERROR_CAST(0x80710b4d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSYS      CELL_ERROR_CAST(0x80710b4e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EFTYPE      CELL_ERROR_CAST(0x80710b4f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EAUTH       CELL_ERROR_CAST(0x80710b50)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENEEDAUTH   CELL_ERROR_CAST(0x80710b51)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EIDRM       CELL_ERROR_CAST(0x80710b52)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMSG      CELL_ERROR_CAST(0x80710b53)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EOVERFLOW   CELL_ERROR_CAST(0x80710b54)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EILSEQ      CELL_ERROR_CAST(0x80710b55)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSUP     CELL_ERROR_CAST(0x80710b56)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ECANCELED   CELL_ERROR_CAST(0x80710b57)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADMSG     CELL_ERROR_CAST(0x80710b58)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODATA     CELL_ERROR_CAST(0x80710b59)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSR       CELL_ERROR_CAST(0x80710b5a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSTR      CELL_ERROR_CAST(0x80710b5b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_CONNECT, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIME       CELL_ERROR_CAST(0x80710b5c)


/*E Network failed on SSL Send
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, SYS_NET_refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0c00) */
/*
 * #define CELL_HTTPS_ERROR_NET_SSL_SEND            CELL_ERROR_CAST(0x80710c00)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPERM          CELL_ERROR_CAST(0x80710c01)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOENT         CELL_ERROR_CAST(0x80710c02)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ESRCH          CELL_ERROR_CAST(0x80710c03)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EINTR          CELL_ERROR_CAST(0x80710c04)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EIO            CELL_ERROR_CAST(0x80710c05)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENXIO          CELL_ERROR_CAST(0x80710c06)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_E2BIG          CELL_ERROR_CAST(0x80710c07)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOEXC         CELL_ERROR_CAST(0x80710c08)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EBADF          CELL_ERROR_CAST(0x80710c09)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ECHILD         CELL_ERROR_CAST(0x80710c0a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EDEADLK        CELL_ERROR_CAST(0x80710c0b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOMEM         CELL_ERROR_CAST(0x80710c0c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EACCES         CELL_ERROR_CAST(0x80710c0d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EFAULT         CELL_ERROR_CAST(0x80710c0e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTBLK        CELL_ERROR_CAST(0x80710c0f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EBUSY          CELL_ERROR_CAST(0x80710c10)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EEXIST         CELL_ERROR_CAST(0x80710c11)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EXDEV          CELL_ERROR_CAST(0x80710c12)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENODEV         CELL_ERROR_CAST(0x80710c13)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTDIR        CELL_ERROR_CAST(0x80710c14)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EISDIR         CELL_ERROR_CAST(0x80710c15)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EINVAL         CELL_ERROR_CAST(0x80710c16)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENFILE         CELL_ERROR_CAST(0x80710c17)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EMFILE         CELL_ERROR_CAST(0x80710c18)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTTY         CELL_ERROR_CAST(0x80710c19)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ETXTBSY        CELL_ERROR_CAST(0x80710c1a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EFBIG          CELL_ERROR_CAST(0x80710c1b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOSPC         CELL_ERROR_CAST(0x80710c1c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ESPIPE         CELL_ERROR_CAST(0x80710c1d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EROFS          CELL_ERROR_CAST(0x80710c1e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EMLINK         CELL_ERROR_CAST(0x80710c1f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPIPE          CELL_ERROR_CAST(0x80710c20)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EDOM           CELL_ERROR_CAST(0x80710c21)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ERANGE         CELL_ERROR_CAST(0x80710c22)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EAGAIN         CELL_ERROR_CAST(0x80710c23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EWOULDBLOCK    CELL_ERROR_CAST(0x80710c23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EINPROGRESS    CELL_ERROR_CAST(0x80710c24)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EALREADY       CELL_ERROR_CAST(0x80710c25)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSOCK       CELL_ERROR_CAST(0x80710c26)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EDESTADDRREQ   CELL_ERROR_CAST(0x80710c27)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EMSGSIZE       CELL_ERROR_CAST(0x80710c28)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROTOTYPE     CELL_ERROR_CAST(0x80710c29)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOPROTOOPT    CELL_ERROR_CAST(0x80710c2a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROTONOSUPPORT CELL_ERROR_CAST(0x80710c2b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ESOCKTNOSUPPORT CELL_ERROR_CAST(0x80710c2c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EOPNOTSUPP     CELL_ERROR_CAST(0x80710c2d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPFNOSUPPORT   CELL_ERROR_CAST(0x80710c2e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EAFNOSUPPORT   CELL_ERROR_CAST(0x80710c2f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EADDRINUSE     CELL_ERROR_CAST(0x80710c30)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EADDRNOTAVAIL  CELL_ERROR_CAST(0x80710c31)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENETDOWN       CELL_ERROR_CAST(0x80710c32)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENETUNREACH    CELL_ERROR_CAST(0x80710c33)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENETRESET      CELL_ERROR_CAST(0x80710c34)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ECONNABORTED   CELL_ERROR_CAST(0x80710c35)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ECONNRESET     CELL_ERROR_CAST(0x80710c36)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOBUFS        CELL_ERROR_CAST(0x80710c37)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EISCONN        CELL_ERROR_CAST(0x80710c38)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTCONN       CELL_ERROR_CAST(0x80710c39)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ESHUTDOWN      CELL_ERROR_CAST(0x80710c3a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ETOOMANYREFS   CELL_ERROR_CAST(0x80710c3b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ETIMEDOUT      CELL_ERROR_CAST(0x80710c3c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ECONNREFUSED   CELL_ERROR_CAST(0x80710c3d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ELOOP          CELL_ERROR_CAST(0x80710c3e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENAMETOOLONG   CELL_ERROR_CAST(0x80710c3f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTDOWN      CELL_ERROR_CAST(0x80710c40)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTUNREACH   CELL_ERROR_CAST(0x80710c41)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTEMPTY      CELL_ERROR_CAST(0x80710c42)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROCLIM       CELL_ERROR_CAST(0x80710c43)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EUSERS         CELL_ERROR_CAST(0x80710c44)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EDQUOT         CELL_ERROR_CAST(0x80710c45)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ESTALE         CELL_ERROR_CAST(0x80710c46)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EREMOTE        CELL_ERROR_CAST(0x80710c47)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EBADRPC        CELL_ERROR_CAST(0x80710c48)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ERPCMISMATCH   CELL_ERROR_CAST(0x80710c49)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROGUNAVAIL   CELL_ERROR_CAST(0x80710c4a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROGMISMATCH  CELL_ERROR_CAST(0x80710c4b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EPROCUNAVAIL   CELL_ERROR_CAST(0x80710c4c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOLCK         CELL_ERROR_CAST(0x80710c4d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOSYS         CELL_ERROR_CAST(0x80710c4e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EFTYPE         CELL_ERROR_CAST(0x80710c4f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EAUTH          CELL_ERROR_CAST(0x80710c50)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENEEDAUTH      CELL_ERROR_CAST(0x80710c51)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EIDRM          CELL_ERROR_CAST(0x80710c52)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOMSG         CELL_ERROR_CAST(0x80710c53)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EOVERFLOW      CELL_ERROR_CAST(0x80710c54)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EILSEQ         CELL_ERROR_CAST(0x80710c55)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSUP        CELL_ERROR_CAST(0x80710c56)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ECANCELED      CELL_ERROR_CAST(0x80710c57)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_EBADMSG        CELL_ERROR_CAST(0x80710c58)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENODATA        CELL_ERROR_CAST(0x80710c59)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOSR          CELL_ERROR_CAST(0x80710c5a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ENOSTR         CELL_ERROR_CAST(0x80710c5b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_SEND, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SSL_SEND_ETIME          CELL_ERROR_CAST(0x80710c5c)


/*E Network failed on SSL Receive
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, SYS_NET_refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0d00) */
/*
 * #define CELL_HTTPS_ERROR_NET_SSL_RECV            CELL_ERROR_CAST(0x80710d00)
 */
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPERM) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPERM          CELL_ERROR_CAST(0x80710d01)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOENT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOENT         CELL_ERROR_CAST(0x80710d02)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ESRCH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ESRCH          CELL_ERROR_CAST(0x80710d03)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EINTR) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EINTR          CELL_ERROR_CAST(0x80710d04)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EIO) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EIO            CELL_ERROR_CAST(0x80710d05)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENXIO) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENXIO          CELL_ERROR_CAST(0x80710d06)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_E2BIG) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_E2BIG          CELL_ERROR_CAST(0x80710d07)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOEXEC) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOEXC         CELL_ERROR_CAST(0x80710d08)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EBADF) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EBADF          CELL_ERROR_CAST(0x80710d09)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ECHILD) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ECHILD         CELL_ERROR_CAST(0x80710d0a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EDEADLK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EDEADLK        CELL_ERROR_CAST(0x80710d0b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOMEM) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOMEM         CELL_ERROR_CAST(0x80710d0c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EACCES) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EACCES         CELL_ERROR_CAST(0x80710d0d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EFAULT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EFAULT         CELL_ERROR_CAST(0x80710d0e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTBLK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTBLK        CELL_ERROR_CAST(0x80710d0f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EBUSY) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EBUSY          CELL_ERROR_CAST(0x80710d10)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EEXIST) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EEXIST         CELL_ERROR_CAST(0x80710d11)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EXDEV) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EXDEV          CELL_ERROR_CAST(0x80710d12)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENODEV) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENODEV         CELL_ERROR_CAST(0x80710d13)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTDIR) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTDIR        CELL_ERROR_CAST(0x80710d14)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EISDIR) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EISDIR         CELL_ERROR_CAST(0x80710d15)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EINVAL) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EINVAL         CELL_ERROR_CAST(0x80710d16)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENFILE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENFILE         CELL_ERROR_CAST(0x80710d17)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EMFILE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EMFILE         CELL_ERROR_CAST(0x80710d18)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTTY) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTTY         CELL_ERROR_CAST(0x80710d19)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ETXTBSY) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ETXTBSY        CELL_ERROR_CAST(0x80710d1a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EFBIG) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EFBIG          CELL_ERROR_CAST(0x80710d1b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOSPC) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOSPC         CELL_ERROR_CAST(0x80710d1c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ESPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ESPIPE         CELL_ERROR_CAST(0x80710d1d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EROFS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EROFS          CELL_ERROR_CAST(0x80710d1e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EMLINK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EMLINK         CELL_ERROR_CAST(0x80710d1f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPIPE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPIPE          CELL_ERROR_CAST(0x80710d20)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EDOM) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EDOM           CELL_ERROR_CAST(0x80710d21)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ERANGE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ERANGE         CELL_ERROR_CAST(0x80710d22)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EAGAIN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EAGAIN         CELL_ERROR_CAST(0x80710d23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EWOULDBLOCK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EWOULDBLOCK    CELL_ERROR_CAST(0x80710d23)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EINPROGRESS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EINPROGRESS    CELL_ERROR_CAST(0x80710d24)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EALREADY) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EALREADY       CELL_ERROR_CAST(0x80710d25)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTSOCK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSOCK       CELL_ERROR_CAST(0x80710d26)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EDESTADDRREQ) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EDESTADDRREQ   CELL_ERROR_CAST(0x80710d27)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EMSGSIZE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EMSGSIZE       CELL_ERROR_CAST(0x80710d28)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROTOTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROTOTYPE     CELL_ERROR_CAST(0x80710d29)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOPROTOOPT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOPROTOOPT    CELL_ERROR_CAST(0x80710d2a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROTONOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROTONOSUPPORT CELL_ERROR_CAST(0x80710d2b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ESOCKTNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ESOCKTNOSUPPORT CELL_ERROR_CAST(0x80710d2c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EOPNOTSUPP) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EOPNOTSUPP     CELL_ERROR_CAST(0x80710d2d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPFNOSUPPORT   CELL_ERROR_CAST(0x80710d2e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EAFNOSUPPORT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EAFNOSUPPORT   CELL_ERROR_CAST(0x80710d2f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EADDRINUSE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EADDRINUSE     CELL_ERROR_CAST(0x80710d30)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EADDRNOTAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EADDRNOTAVAIL  CELL_ERROR_CAST(0x80710d31)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENETDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENETDOWN       CELL_ERROR_CAST(0x80710d32)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENETUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENETUNREACH    CELL_ERROR_CAST(0x80710d33)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENETRESET) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENETRESET      CELL_ERROR_CAST(0x80710d34)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ECONNABORTED) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ECONNABORTED   CELL_ERROR_CAST(0x80710d35)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ECONNRESET) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ECONNRESET     CELL_ERROR_CAST(0x80710d36)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOBUFS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOBUFS        CELL_ERROR_CAST(0x80710d37)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EISCONN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EISCONN        CELL_ERROR_CAST(0x80710d38)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTCONN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTCONN       CELL_ERROR_CAST(0x80710d39)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ESHUTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ESHUTDOWN      CELL_ERROR_CAST(0x80710d3a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ETOOMANYREFS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ETOOMANYREFS   CELL_ERROR_CAST(0x80710d3b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ETIMEDOUT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ETIMEDOUT      CELL_ERROR_CAST(0x80710d3c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ECONNREFUSED) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ECONNREFUSED   CELL_ERROR_CAST(0x80710d3d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ELOOP) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ELOOP          CELL_ERROR_CAST(0x80710d3e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENAMETOOLONG) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENAMETOOLONG   CELL_ERROR_CAST(0x80710d3f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EHOSTDOWN) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTDOWN      CELL_ERROR_CAST(0x80710d40)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EHOSTUNREACH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTUNREACH   CELL_ERROR_CAST(0x80710d41)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTEMPTY) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTEMPTY      CELL_ERROR_CAST(0x80710d42)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROCLIM) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROCLIM       CELL_ERROR_CAST(0x80710d43)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EUSERS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EUSERS         CELL_ERROR_CAST(0x80710d44)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EDQUOT) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EDQUOT         CELL_ERROR_CAST(0x80710d45)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ESTALE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ESTALE         CELL_ERROR_CAST(0x80710d46)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EREMOTE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EREMOTE        CELL_ERROR_CAST(0x80710d47)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EBADRPC) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EBADRPC        CELL_ERROR_CAST(0x80710d48)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ERPCMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ERPCMISMATCH   CELL_ERROR_CAST(0x80710d49)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROGUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROGUNAVAIL   CELL_ERROR_CAST(0x80710d4a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROGMISMATCH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROGMISMATCH  CELL_ERROR_CAST(0x80710d4b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EPROCUNAVAIL) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EPROCUNAVAIL   CELL_ERROR_CAST(0x80710d4c)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOLCK) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOLCK         CELL_ERROR_CAST(0x80710d4d)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOSYS) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOSYS         CELL_ERROR_CAST(0x80710d4e)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EFTYPE) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EFTYPE         CELL_ERROR_CAST(0x80710d4f)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EAUTH          CELL_ERROR_CAST(0x80710d50)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENEEDAUTH) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENEEDAUTH      CELL_ERROR_CAST(0x80710d51)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EIDRM) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EIDRM          CELL_ERROR_CAST(0x80710d52)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOMSG) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOMSG         CELL_ERROR_CAST(0x80710d53)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EOVERFLOW) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EOVERFLOW      CELL_ERROR_CAST(0x80710d54)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EILSEQ) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EILSEQ         CELL_ERROR_CAST(0x80710d55)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOTSUP) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSUP        CELL_ERROR_CAST(0x80710d56)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ECANCELED) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ECANCELED      CELL_ERROR_CAST(0x80710d57)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_EBADMSG) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_EBADMSG        CELL_ERROR_CAST(0x80710d58)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENODATA) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENODATA        CELL_ERROR_CAST(0x80710d59)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOSR) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOSR          CELL_ERROR_CAST(0x80710d5a)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ENOSTR) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ENOSTR         CELL_ERROR_CAST(0x80710d5b)
/* ERR: CELL_HTTP_NET_ERROR(CELL_HTTPS_ERROR_NET_SSL_RECV, SYS_NET_ETIME) */
#define CELL_HTTP_ERROR_NET_SSL_RECV_ETIME          CELL_ERROR_CAST(0x80710d5c)

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _CELL_HTTP_NET_ERROR_H */
