/*   SCE CONFIDENTIAL                                       */
/*   PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*   Copyright (C) 2010 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __CELL_GCM_PM_H__
#define __CELL_GCM_PM_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*
  domain clocks
*/
typedef enum{
	CELL_GCM_PM_DOMAIN_HCLK = 0,
	CELL_GCM_PM_DOMAIN_GCLK = 1,
	CELL_GCM_PM_DOMAIN_RCLK = 2,
	CELL_GCM_PM_DOMAIN_SCLK = 3,
	CELL_GCM_PM_DOMAIN_MCLK = 4,
	CELL_GCM_PM_DOMAIN_ICLK = 5,
	CELL_GCM_PM_DOMAIN_NUM = 6
}CellGcmPerfMonDomain;

/*
  counter events
*/
typedef enum{
	CELL_GCM_PM_HCLK_COMMAND_FEED = 1,
	CELL_GCM_PM_HCLK_CELL_MASTER_LOCAL_MEM_READ = 5,

	CELL_GCM_PM_HCLK_CELL_MASTER_LOCAL_MEM_WRITE_TOTAL = 6,
	CELL_GCM_PM_HCLK_CELL_MASTER_LOCAL_MEM_WRITE_32BIT_PACKET = 7,
	CELL_GCM_PM_HCLK_CELL_MASTER_LOCAL_MEM_WRITE_128BIT_PACKET = 9,

	CELL_GCM_PM_HCLK_IOIF2HOST_READ_DATA = 10,
	CELL_GCM_PM_HCLK_IOIF2HOST_WRITE_DATA = 11,

}CellGcmPerfMonHclk;

typedef enum{
	CELL_GCM_PM_GCLK_SETUP2RASTER_ACTIVE = 2,
	CELL_GCM_PM_GCLK_SETUP2RASTER_IDLE = 3,
	CELL_GCM_PM_GCLK_SETUP2RASTER_STALLING = 4,
	CELL_GCM_PM_GCLK_SETUP2RASTER_STARVING = 5,
	CELL_GCM_PM_GCLK_INSTRUCTION_ISSUED_VPE0 = 9,
	CELL_GCM_PM_GCLK_PRIMITIVECOUNT = 20,
	CELL_GCM_PM_GCLK_CRASTER_OUTPUT_TILE_COUNT = 23,
	CELL_GCM_PM_GCLK_CRASTER_SEARCH_MODE = 24,
	CELL_GCM_PM_GCLK_IDX_GEOM_ATTRIBUTE_COUNT = 39,
	CELL_GCM_PM_GCLK_IDX_VTX_CACHE_HIT = 40,
	CELL_GCM_PM_GCLK_IDX_VTX_CACHE_MISS = 41,
	CELL_GCM_PM_GCLK_SETUP_POINTS = 44,
	CELL_GCM_PM_GCLK_SETUP_CULLS = 45,
	CELL_GCM_PM_GCLK_SETUP_LINES = 46,
	CELL_GCM_PM_GCLK_SETUP_TRIANGLES = 47,
	CELL_GCM_PM_GCLK_VPC_CULL_PRIMITIVE = 48,
	CELL_GCM_PM_GCLK_VPC_CULL_FRUSTUM = 49,
	CELL_GCM_PM_GCLK_VPC_CULL_ZERO_AREA = 50,
	CELL_GCM_PM_GCLK_VPC_CULL_BACKFACE = 51,
	CELL_GCM_PM_GCLK_VPC_CULL_WOULD_CLIP = 53,
	CELL_GCM_PM_GCLK_IDX_FETCH_FBI = 55,
	CELL_GCM_PM_GCLK_IDX_FETCH_SYS = 56,
	CELL_GCM_PM_GCLK_VAB_CMD_LOAD = 72,
	CELL_GCM_PM_GCLK_VAB_CMD_TRI = 74,
	CELL_GCM_PM_GCLK_RASTERIZEDPIXELCOUNT_1 = 80,
	CELL_GCM_PM_GCLK_RASTERIZEDPIXELCOUNT_2 = 81,
	CELL_GCM_PM_GCLK_IDX_POST_TRANSFORM_CACHE_HIT_1 = 82,
	CELL_GCM_PM_GCLK_IDX_POST_TRANSFORM_CACHE_HIT_2 = 83,
	CELL_GCM_PM_GCLK_IDX_POST_TRANSFORM_CACHE_MISS_1 = 84,
	CELL_GCM_PM_GCLK_IDX_POST_TRANSFORM_CACHE_MISS_2 = 85,
	CELL_GCM_PM_GCLK_IDX_VERTEX_COUNT_1 = 86,
	CELL_GCM_PM_GCLK_IDX_VERTEX_COUNT_2 = 87,

	CELL_GCM_PM_GCLK_ZCULL_TILES_TOTAL_TESTED_1 = 88,
	CELL_GCM_PM_GCLK_ZCULL_TILES_TOTAL_TESTED_2 = 89,

	CELL_GCM_PM_GCLK_ZCULL_TILES_Z_TRIVIALLY_REJECTED_1 = 90,
	CELL_GCM_PM_GCLK_ZCULL_TILES_Z_TRIVIALLY_REJECTED_2 = 91,

	CELL_GCM_PM_GCLK_ZCULL_TILES_STENCIL_CULLED_1 = 92,
	CELL_GCM_PM_GCLK_ZCULL_TILES_STENCIL_CULLED_2 = 93,

	CELL_GCM_PM_GCLK_ZCULL_TILES_Z_TRIVIALLY_ACCEPTED_1 = 94,
	CELL_GCM_PM_GCLK_ZCULL_TILES_Z_TRIVIALLY_ACCEPTED_2 = 95,

	CELL_GCM_PM_GCLK_ZCULL_TILES_NOT_CULLED_BUT_FAILS_ZTEST_1 = 96,
	CELL_GCM_PM_GCLK_ZCULL_TILES_NOT_CULLED_BUT_FAILS_ZTEST_2 = 97,

	CELL_GCM_PM_GCLK_ZCULL_TILES_DEPTH_BOUNDS_CULLED_1 = 98,
	CELL_GCM_PM_GCLK_ZCULL_TILES_DEPTH_BOUNDS_CULLED_2 = 99,

	CELL_GCM_PM_GCLK_ZCULL_TILES_NEAR_FAR_CLIPPED_1 = 100,
	CELL_GCM_PM_GCLK_ZCULL_TILES_NEAR_FAR_CLIPPED_2 = 101,

	CELL_GCM_PM_GCLK_ZCULL_TILES_TOTAL_CULLED_1 = 102,
	CELL_GCM_PM_GCLK_ZCULL_TILES_TOTAL_CULLED_2 = 103,

        CELL_GCM_PM_GCLK_HOST2FE_METHOD_ACTIVE = 104,
        CELL_GCM_PM_GCLK_HOST2FE_METHOD_IDLE = 105,
        CELL_GCM_PM_GCLK_HOST2FE_METHOD_STALLING = 106,
        CELL_GCM_PM_GCLK_HOST2FE_METHOD_STARVING = 107,

        CELL_GCM_PM_GCLK_FE_WAITS_FOR_IDLE_GRAPHICS_PIPE = 108,
	CELL_GCM_PM_GCLK_IDLE_GRAPHICS_PIPE = 109,

	CELL_GCM_PM_GCLK_PROP2FE_WRITE_TEX_LABEL = 111,
	CELL_GCM_PM_GCLK_XBAR2FE_WRITE_REPORT = 112,

}CellGcmPerfMonGclk;

typedef enum{
	CELL_GCM_PM_RCLK_CROP_COMP_WRITE = 2,
	CELL_GCM_PM_RCLK_ZREAD_INTERLOCK_STALL = 3,
	CELL_GCM_PM_RCLK_ZROP_COMP_READ_COMP_WRITE = 4,
	CELL_GCM_PM_RCLK_ZROP_NO_READ_COMP_WRITE = 5,
	CELL_GCM_PM_RCLK_ZROP_UNCOMP_READ_COMP_WRITE = 6,
	CELL_GCM_PM_RCLK_ZROP_TOTAL_WRITTEN = 7,

	CELL_GCM_PM_RCLK_CROP_SUBPACKET_COUNT = 8,
}CellGcmPerfMonRclk;


typedef enum{
	CELL_GCM_PM_SCLK_SQD_ENDSEG_ANY = 5,
	CELL_GCM_PM_SCLK_SQD_ENDSEG_RASTER_TIMEOUT = 7,
	CELL_GCM_PM_SCLK_SQD_ENDSEG_REGISTER_LIMIT = 8,
	CELL_GCM_PM_SCLK_SQD_ENDSEG_SHADER_STATE_BUNDLE = 9,
	CELL_GCM_PM_SCLK_SQD_ENDSEG_SLOT_LIMIT_FOR_SQC = 10,
	CELL_GCM_PM_SCLK_SQD_ENDSEG_TRIANGLE_LIMIT = 11,
	CELL_GCM_PM_SCLK_L1_TEXTURE_CACHE_REQUEST_GREATER_THAN_4_COUNT = 22,
	CELL_GCM_PM_SCLK_L1_TEXTURE_CACHE_INDEX_COLLISION = 23,
	CELL_GCM_PM_SCLK_TEXTURE_ANISO_COUNT_01 = 28,
	CELL_GCM_PM_SCLK_TEXTURE_ANISO_COUNT_02 = 29,
	CELL_GCM_PM_SCLK_TEXTURE_ANISO_COUNT_04 = 30,
	CELL_GCM_PM_SCLK_TEXTURE_ANISO_COUNT_08 = 32,
	CELL_GCM_PM_SCLK_TEXTURE_ANISO_COUNT_16 = 36,
	CELL_GCM_PM_SCLK_TEXTURE_QUAD_COUNT = 37,
	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET1_MISS_COUNT = 45,
	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET1_REQUEST_COUNT = 46,

	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET2_MISS_COUNT = 49,
	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET2_REQUEST_COUNT = 50,
	CELL_GCM_PM_SCLK_2D_TRANSFER_WAITS_FOR_3D = 59,

	CELL_GCM_PM_SCLK_SCT2TEX_ACTIVE = 60,
	CELL_GCM_PM_SCLK_SCT2TEX_STALLING = 61,
	CELL_GCM_PM_SCLK_SCT2TEX_STARVING = 63,

	CELL_GCM_PM_SCLK_SHADER_ALL_TEX_NOP_QUADS = 64,
	CELL_GCM_PM_SCLK_SHADER_ALL_QUADS = 65,
	CELL_GCM_PM_SCLK_SHADER_FIRST_PASS_QUADS = 66,
	CELL_GCM_PM_SCLK_SHADER_FIRST_PASS_TEX_NOP_QUADS = 67,
	CELL_GCM_PM_SCLK_SIF_FETCH_TEXTURE_PASS_COUNT = 70,
	CELL_GCM_PM_SCLK_SIF_FETCH_NO_TEXTURE_PASS_COUNT = 71,
	CELL_GCM_PM_SCLK_FINERASTERTILES_COVERED = 74,
	CELL_GCM_PM_SCLK_FINERASTERTILES_FASTZ = 76,
	CELL_GCM_PM_SCLK_FINERASTERBUNDLES = 77,

	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET3_MISS_COUNT = 104,
	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET3_REQUEST_COUNT = 105,

	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET4_MISS_COUNT = 108,
	CELL_GCM_PM_SCLK_L2_TEXTURE_CACHE_SET4_REQUEST_COUNT = 109,

	CELL_GCM_PM_SCLK_PREROP_VALID_PIXEL = 116,
	CELL_GCM_PM_SCLK_PREROP_VALID_PACKET = 116,

	CELL_GCM_PM_SCLK_SQD_ENDSEG_SLOT_LIMIT_FOR_QUAD = 117,

	CELL_GCM_PM_SCLK_PREROP_FE_FLUSH_ACTIVE = 119,

	CELL_GCM_PM_SCLK_SHADER_TOTAL_QUADS = 123,
	CELL_GCM_PM_SCLK_SHADER_TOTAL_FIRST_PASS_QUADS = 124,


}CellGcmPerfMonSclk;

typedef enum{
	CELL_GCM_PM_MCLK_FB_RW_COUNT1 = 1,
	CELL_GCM_PM_MCLK_FB_RW_COUNT2 = 2,
	CELL_GCM_PM_MCLK_FB_IDLE = 7,
	CELL_GCM_PM_MCLK_FB_RW_IDLE = 27,

	CELL_GCM_PM_MCLK_FB_STALLED = 30,
	CELL_GCM_PM_MCLK_COMPRESSED_FAST_CLEAR = 31,
	CELL_GCM_PM_MCLK_EXPANDED_FAST_CLEAR = 32,
	CELL_GCM_PM_MCLK_FB_COMPRESSED_WRITE = 33,
	CELL_GCM_PM_MCLK_FB_NORMAL_WRITE = 34,
	CELL_GCM_PM_MCLK_FB_COMPRESSED_READ = 38,
	CELL_GCM_PM_MCLK_FB_NORMAL_READ = 40,
	CELL_GCM_PM_MCLK_FB_CROP_READ = 41,
	CELL_GCM_PM_MCLK_FB_CROP_WRITE = 42,
	CELL_GCM_PM_MCLK_FB_TEXTURE_READ = 46,
	CELL_GCM_PM_MCLK_FB_ZROP_READ = 47,
	CELL_GCM_PM_MCLK_FB_HOST_READ = 128,
	CELL_GCM_PM_MCLK_FB_HOST_WRITE = 129,
	CELL_GCM_PM_MCLK_FB_GRFE_READ = 132,
	CELL_GCM_PM_MCLK_FB_GRFE_WRITE = 133,

}CellGcmPerfMonMclk;

typedef enum{
	CELL_GCM_PM_ICLK_SYS_NORMAL_WRITE = 5,
	CELL_GCM_PM_ICLK_SYS_NORMAL_READ = 7,
	CELL_GCM_PM_ICLK_DEBUG_AUDIO_TRANSFER = 8,
}CellGcmPerfMonIclk;


/*
  performance monitor functions
*/

enum {
	CELL_GCM_PM_MAX_EVENT = 4,
	CELL_GCM_PM_MAX_COUNTER = 4
};

int32_t cellGcmInitPerfMon(void);
int32_t cellGcmExitPerfMon(void);
int32_t cellGcmSetPerfMonEvent(const uint32_t domain, const uint32_t event[CELL_GCM_PM_MAX_EVENT]);
int32_t cellGcmGetPerfMonCounter(const uint32_t domain, uint32_t counter[CELL_GCM_PM_MAX_COUNTER], uint32_t *cycle);

/*
  error code
*/
#define CELL_GCM_ERROR_PM_STATE_INVALID		CELL_GCM_MAKE_ERROR(0x00f1)


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __CELL_GCM_PM_H__ */
