/*
	SCE CONFIDENTIAL
	PlayStation(R)3 Programmer Tool Runtime Library 475.001
	Copyright (C) 2007,2008,2009,2010,2011,2012 Sony Computer Entertainment Inc.
	All Rights Reserved.
*/
/**
	\internal
	\file fios_configuration.h

	Configuration switches for the File I/O Scheduler. You may edit or override this
	header file to control the behavior of FIOS.
*/

#ifndef __CELL_FIOS_CONFIGURATION_H__
#define __CELL_FIOS_CONFIGURATION_H__

/** Set to 1 to enable debug behaviors of FIOS, including debug and informational output. */
#ifndef FIOSDEBUG
# if (defined(NDEBUG) && NDEBUG)
#  define FIOSDEBUG         0
# elif (defined(DEBUG) && DEBUG)
#  define FIOSDEBUG         1
# elif (defined(_DEBUG) && _DEBUG)
#  define FIOSDEBUG         1
# else
#  define FIOSDEBUG         0
# endif
#endif

#ifndef FIOS_CONSTANT_LOG2
/** Preprocessor helper: log2 function for numeric constants. */
# define FIOS_CONSTANT_LOG2(val)    ((val <= 1) ? 0:      (val <= 2) ? 1:\
									 (val <= 4) ? 2:      (val <= 8) ? 3:\
									 (val <= 16) ? 4:     (val <= 32) ? 5:\
									 (val <= 64) ? 6:     (val <= 128) ? 7:\
									 (val <= 256) ? 8:    (val <= 512) ? 9:\
									 (val <= 1024) ? 10:  (val <= 2048) ? 11:12)
#endif

#ifndef FIOS_ALIGNOF
/** Preprocessor helper: Returns the log2 of the alignment of a class or other object. */
# define FIOS_ALIGNOF(t)	FIOS_CONSTANT_LOG2(__alignof(t))
#endif

#endif /* __CELL_FIOS_CONFIGURATION_H__ */
