/**
	\file edgelzma.h

	We keep a copy of EDGE lzma binaries+headers here to simplify
	building and testing against multiple versions.
	
	The authoritative EDGE releases are available on SCE DevNet as
	a separate download:
	 https://ps3.scedev.net/projects/psedge
*/
#ifndef __CELL_EDGELZMA_H__
#define __CELL_EDGELZMA_H__

/* This header is for EDGE LZMA 1.2.0. */
#include <edge/edge_version.h>
#define SCEA_EDGE_LZMA_VERSION    EDGE_SDK_VERSION

/* Include the headers. */
#include <edge/lzma/edgelzma_aligned.h>
#include <edge/lzma/edgelzma_inflate_queue_element.h>
#include <edge/lzma/edgelzma_ppu.h>

#endif /* __CELL_EDGELZMA_H__ */

